$('#p-calculoPoupanca').on('pageinit', function(event){
    console.log('Page Init Calculo Poupança');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#result-poupanca').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		$("#taxaSelic").val(removeMascPorcentagem($("#taxaSelic").val()));
		$("#taxaReferencial").val(removeMascPorcentagem($("#taxaReferencial").val()));
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parent().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				valorPoupanca: {
					required: true
				},
				taxaSelic: {
					required: true
				},
				taxaReferencial: {
					required: true
				}
			}
		});
		if (form.valid()) {
			$("#taxaSelic").val(addMascPorcentagem($("#taxaSelic").val()));
			$("#taxaReferencial").val(addMascPorcentagem($("#taxaReferencial").val()));
			console.log("Submit");
			$('#result-poupanca').show();
	    	var valorPoupanca = $('#valorPoupanca').val();
	    	var taxaSelic = $('#taxaSelic').val();
	    	var taxaReferencial = $('#taxaReferencial').val();
	    	var poupanca = calcularPoupanca(removerMascPorcentagem(taxaSelic), removerMascara(valorPoupanca), removerMascPorcentagem(taxaReferencial));
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado do Cálculo Poupança';
	    	resultado.itens = {'Taxa de Juros (%a.a.)': poupanca.taxaJuros + "%", 
					'Valor do Rendimento Anual': formatarRealDouble(poupanca.rendimento),
					'Valor Total do Montante em 1 Ano': formatarRealDouble(poupanca.total)};
	    	exibirResultado('result-poupanca', resultado);
	    	console.log('Registrar Evento');
		} else {
			if ($("#taxaSelic").val() != null && $("#taxaSelic").val() != '') {
				$("#taxaSelic").val(addMascPorcentagem($("#taxaSelic").val()));
			}
			if ($("#taxaReferencial").val() != null && $("#taxaReferencial").val() != '') {
				$("#taxaReferencial").val(addMascPorcentagem($("#taxaReferencial").val()));
			}
			$('#result-poupanca').hide();
		}
		return false;
	});
});


