$('#p-jurosCompostos').on('pageinit', function(event){
    console.log('Page Init Salario Liquido');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#result-juros-compostos').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		$("#taxaJuros").val(removeMascPorcentagem($("#taxaJuros").val()));
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parent().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				valorCapital: {
					required: true
				},
				taxaJuros: {
					required: true
				},
				numeroMeses: {
					required: true,
					min:1,
					max:999
				}
			}
		});
		if (form.valid()) {
			$("#taxaJuros").val(addMascPorcentagem($("#taxaJuros").val()));
			console.log("Submit");
			$('#result-juros-compostos').show();
	    	var valorCapital = $('#valorCapital').val();
	    	var taxaJuros = $('#taxaJuros').val();
	    	var numeroMeses = $('#numeroMeses').val();
	    	var montante = calcularJurosCompostos(removerMascara(valorCapital), removerMascPorcentagem(taxaJuros), numeroMeses);
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado do Cálculo de Juros Simples';
	    	resultado.itens = {'Valor do Montante': formatarRealDouble(montante)};
	    	exibirResultado('result-juros-compostos', resultado);
	    	console.log('Registrar Evento');
		} else {
			if ($("#taxaJuros").val() != null && $("#taxaJuros").val() != '') {
				$("#taxaJuros").val(addMascPorcentagem($("#taxaJuros").val()));
			}
			$('#result-juros-compostos').hide();
		}
		return false;
	});
});


