$('#p-jurosSimples').on('pageinit', function(event){
    console.log('Page Init Salario Liquido');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#result-juros-simples').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		$("#taxaJurosAnual").val(removeMascPorcentagem($("#taxaJurosAnual").val()));
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parent().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				valorCapital: {
					required: true
				},
				taxaJurosAnual: {
					required: true
				},
				numeroMeses: {
					required: true,
					min:1,
					max:999
				}
			}
		});
		if (form.valid()) {
			$("#taxaJurosAnual").val(addMascPorcentagem($("#taxaJurosAnual").val()));
			console.log("Submit");
			$('#result-juros-simples').show();
	    	var valorCapital = $('#valorCapital').val();
	    	var taxaJurosAnual = $('#taxaJurosAnual').val();
	    	var numeroMeses = $('#numeroMeses').val();
	    	var rs = calcularJurosSimples(removerMascara(valorCapital), removerMascPorcentagem(taxaJurosAnual), numeroMeses);
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado do Cálculo de Juros Simples';
	    	resultado.itens = {'Valor do Montante': formatarRealDouble(rs.valor), 
					'Valor dos Juros': formatarRealDouble(rs.juros)};
	    	exibirResultado('result-juros-simples', resultado);
	    	console.log('Registrar Evento');
		} else {
			if ($("#taxaJurosAnual").val() != null && $("#taxaJurosAnual").val() != '') {
				$("#taxaJurosAnual").val(addMascPorcentagem($("#taxaJurosAnual").val()));
			}
			$('#result-juros-simples').hide();
		}
		return false;
	});
});