$('#p-rendaPerCapita').on('pageinit', function(event){
    console.log('Page Init Renda Per Capita');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#result-renda-per-capita').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parent().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				valorRendimentos: {
					required: true
				},
				qtdMembros: {
					required: true,
					min:1,
					max:999
				}
			}
		});
		if (form.valid()) {
			console.log("Submit");
			$('#result-renda-per-capita').show();
	    	var valorRendimentos = $('#valorRendimentos').val();
	    	var qtdMembros = $('#qtdMembros').val();
	    	var valorRendaPerCapita = calcularRendaPerCapita(removerMascara(valorRendimentos), qtdMembros);
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado do Cálculo Renda Per Capita';
	    	resultado.itens = {'Renda Per Capita Familiar': formatarRealDouble(valorRendaPerCapita)};
	    	exibirResultado('result-renda-per-capita', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#result-renda-per-capita').hide();
		}
		return false;
	});
});


