$('#p-consumoEnergia').on('pageinit', function(event){
    console.log('Page Init Consumo de Energia');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#resultConsumoEnergia').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parent().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				qtdAparelhos: {
					required: true
				},
				qtdHorasPorDia: {
					required: true
				},
				potencia: {
					required: true
				},
				uf: {
					required: true
				}
			}
		});
		if (form.valid()) {
			console.log("Submit");
			$('#resultConsumoEnergia').show();
			
	    	var qtdAparelhos = $('#qtdAparelhos').val();
	    	var qtdHorasPorDia = $('#qtdHorasPorDia').val();
	    	var potencia = $('#potencia').val();
	    	var uf = $('#uf').val();
	    	var rs = calcularConsumoEnergia(qtdAparelhos, potencia, qtdHorasPorDia, uf);
	    	
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado do Consumo de Energia';
	    	resultado.itens = {'Consumo': rs.consumo, 
	    			'Valor do KWh': rs.valorKWh, 
	    			'Valor Total': rs.valorTotal};
	    	exibirResultado('resultConsumoEnergia', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#resultConsumoEnergia').hide();
		}
		return false;
	});
});


