$('#p-itbi').on('pageinit', function(event){
    console.log('Page Init ITBI');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#resultItbi').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		$("#imposto").val(removeMascPorcentagem($("#imposto").val()));
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parent().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				valorImovel: {
					required: true
				},
				imposto: {
					required: true
				}
			}
		});
		if (form.valid()) {
			$("#imposto").val(addMascPorcentagem($("#imposto").val()));
			console.log("Submit");
			$('#resultItbi').show();
	    	var valorImovel = $('#valorImovel').val();
	    	var imposto = $('#imposto').val();
	    	var rs = calcularImposto(removerMascara(valorImovel), removerMascPorcentagem(imposto));
	    	
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado do ITBI';
	    	resultado.itens = {'Valor': formatarRealDouble(rs)};
	    	
	    	exibirResultado('resultItbi', resultado);
	    	console.log('Registrar Evento');
		} else {
			if ($("#imposto").val() != null && $("#imposto").val() != '') {
				$("#imposto").val(addMascPorcentagem($("#imposto").val()));
			}
			$('#resultItbi').hide();
		}
		return false;
	});
});