$('#p-aceleracao').on('pageinit', function(event){
    console.log('Page Init Aceleração');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#resultAceleracao').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parent().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				velocidadeInicial: {
					required: true,
					max: 99999999999.00
				},
				velocidadeFinal: {
			    	required: true,
					max: 99999999999.00
			    },
			    tempoInicial: {
			    	required: true,
					max: 99999999999.00
			    },
			    tempoFinal: {
			    	required: true,
					max: 99999999999.00
			    }
			}
		});
		if (form.valid()) {
			console.log("Submit");
			$('#resultAceleracao').show();
	    	var velocidadeInicial = $('#velocidadeInicial').val();
	    	var velocidadeFinal = $('#velocidadeFinal').val();
	    	var tempoInicial = $('#tempoInicial').val();
	    	var tempoFinal = $('#tempoFinal').val();
	    	var rs = calcularAceleracao(velocidadeInicial, velocidadeFinal, tempoInicial, tempoFinal);
	    	
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado da Aceleração';
	    	resultado.itens = {'Aceleração': rs};
	    	
	    	exibirResultado('resultAceleracao', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#resultAceleracao').hide();
		}
		return false;
	});
});