$('#p-distancia').on('pageinit', function(event){
    console.log('Page Init Distância');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#resultDistancia').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parent().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				xa: {
					required: true,
					max: 99999999999.00
				},
				xb: {
			    	required: true,
					max: 99999999999.00
			    },
			    ya: {
			    	required: true,
					max: 99999999999.00
			    },
			    yb: {
			    	required: true,
					max: 99999999999.00
			    }
			}
		});
		if (form.valid()) {
			console.log("Submit");
			$('#resultDistancia').show();
	    	var xa = $('#xa').val();
	    	var xb = $('#xb').val();
	    	var ya = $('#ya').val();
	    	var yb = $('#yb').val();
	    	var rs = calcularDistancia(xa, xb, ya, yb);
	    	
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado da Distância entre Dois Pontos';
	    	resultado.itens = {'Distância': rs};
	    	
	    	exibirResultado('resultDistancia', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#resultDistancia').hide();
		}
		return false;
	});
});