$('#p-potencia').on('pageinit', function(event){
    console.log('Page Init Potenciação');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#resultPotencia').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorLabelContainer: "#containerErros-potencia",
		    wrapper: "div",
			rules: {
				expoente: {
					required: true,
					max: 99999999999.00
				},
		    	valor: {
			    	required: true,
					max: 99999999999.00
			    }
			},
			messages: {
				expoente: {
					required: "O campo Expoente é obrigatório."
				},
				valor: {
					required: "O campo Valor é obrigatório."
				}
			}
		});
		if (form.valid()) {
			console.log("Submit");
			$('#resultPotencia').show();
	    	var expoente = $('#expoente').val();
	    	var valor = $('#valor').val();
	    	var rs = calcularPotencia(valor, expoente);
	    	
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado da Potenciação';
	    	resultado.itens = {'Valor': rs};
	    	
	    	exibirResultado('resultPotencia', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#resultPotencia').hide();
		}
		return false;
	});
});