$('#p-probabilidade').on('pageinit', function(event){
    console.log('Page Init IMC');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#resultProbabilidade').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parent().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				casosFavoraveis: {
					required: true,
					max: 99999999999.00
				},
				casosPossiveis: {
			    	required: true,
					max: 99999999999.00
			    }
			}
		});
		if (form.valid()) {
			console.log("Submit");
			$('#resultProbabilidade').show();
	    	var casosFavoraveis = $('#casosFavoraveis').val();
	    	var casosPossiveis = $('#casosPossiveis').val();
	    	var rs = calcularProbabilidade(casosFavoraveis, casosPossiveis);
	    	
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado da Probabilidade';
	    	resultado.itens = {'Probabilidade': rs};
	    	
	    	exibirResultado('resultProbabilidade', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#resultProbabilidade').hide();
		}
		return false;
	});
});