$('#p-raiz').on('pageinit', function(event){
    console.log('Page Init IMC');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#resultRaiz').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorLabelContainer: "#containerErros-raiz",
		    wrapper: "div",
			rules: {
				expoente: {
					required: true,
					max: 99999999999.00
				},
		    	valor: {
			    	required: true,
					max: 99999999999.00
			    }
			},
			messages: {
				expoente: {
					required: "O campo Expoente é obrigatório."
				},
				valor: {
					required: "O campo Valor é obrigatório."
				}
			}
		});
		if (form.valid()) {
			console.log("Submit");
			$('#resultRaiz').show();
	    	var expoente = $('#expoente').val();
	    	var valor = $('#valor').val();
	    	var rs = calcularRaiz(valor, expoente);
	    	
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado da Raiz';
	    	resultado.itens = {'Valor': rs};
	    	
	    	exibirResultado('resultRaiz', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#resultRaiz').hide();
		}
		return false;
	});
});