$('#p-volume').on('pageinit', function(event){
    console.log('Page Init IMC');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#resultVolume').hide();
		$('#esfera').hide();
		$('#quadrado').hide();
		$('#triangulo').hide();
		$('#quadTri').hide();
		$('#forma').val("");
	});
   	
   	$('#forma').change(function() {
   		
   		if ($('#forma').val() == 'Q') {
   			$('#quadTri').show();
   			$('#quadrado').show();
   			$('#triangulo').hide();
   			$('#esfera').hide();
   			
   		} else if ($('#forma').val() == 'T') {
   			$('#quadTri').show();
   			$('#triangulo').show();
   			$('#quadrado').hide();
   			$('#esfera').hide();
   			
   		} else if ($('#forma').val() == 'E') {
   			$('#esfera').show();
   			$('#quadrado').hide();
   			$('#triangulo').hide();
   			$('#quadTri').hide();
   		
   		} else {
   			$('#esfera').hide();
   			$('#quadrado').hide();
   			$('#triangulo').hide();
   			$('#quadTri').hide();
   		}
   	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parents().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				forma: {
					required: true
				}
			}
		});
		if (form.valid()) {
			console.log("Submit");
			var rs;
			
			$('#resultVolume').show();
			
			if ($('#forma').val() == 'Q') {
				var base = $('#base').val();
		    	var altura = $('#altura').val();
		    	var profundidade = $('#profundidade').val();
		    	rs = calcularVolumeQuadrado(base, altura, profundidade);
		    	
			} else if ($('#forma').val() == 'T') {
				var base = $('#base').val();
		    	var altura = $('#altura').val();
		    	var profundidade = $('#profundidade').val();
		    	rs = calcularVolumeTriangulo(base, altura, profundidade);
		    	
			} else if ($('#forma').val() == 'E') {
				var raio = $('#raio').val();
		    	rs = calcularVolumeEsfera(raio);
			}
	    	
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado do Volume';
	    	resultado.itens = {'Valor': rs};
	    	
	    	exibirResultado('resultVolume', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#resultVolume').hide();
		}
		return false;
	});
});