$('#p-imc').on('pageinit', function(event){
    console.log('Page Init IMC');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#resultImc').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parent().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				peso: {
					required: true,
					max: 99999999999.00
				},
			    altura: {
			    	required: true,
					max: 99.99
			    }
			}
		});
		if (form.valid()) {
			console.log("Submit");
			$('#resultImc').show();
	    	var peso = $('#peso').val();
	    	var altura = $('#altura').val();
	    	var rs = calcularIMC(peso, altura);
	    	
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado do IMC';
	    	resultado.itens = {'Imc': rs};
	    	
	    	exibirResultado('resultImc', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#resultImc').hide();
		}
		return false;
	});
});