$('#p-pesoIdeal').on('pageinit', function(event){
    console.log('Page Init Peso Ideal');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#resultPesoIdeal').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parent().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				peso: {
					required: true,
					max: 99999999999.00
				},
				altura: {
					required: true,
					max: 99.99
				}
			}
		});
		if (form.valid()) {
			console.log("Submit");
			$('#resultPesoIdeal').show();
	    	var peso = $('#peso').val();
	    	var altura = $('#altura').val();
	    	var rs = calcularPesoIdeal(peso, altura);
	    	
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado do Peso Ideal';
	    	resultado.itens = {'Situação': rs};
	    	
	    	exibirResultado('resultPesoIdeal', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#resultPesoIdeal').hide();
		}
		return false;
	});
});