$('#p-decimoTerceiro').on('pageinit', function(event){
    console.log('Page Init Decimo Terceiro');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#result-decimo-terceiro').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parent().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				salarioBruto: {
					required: true
				},
				numeroDependentes: {
					required: true,
					min:0,
					max:99
				},
				quantidadeMeses: {
					required: true,
					min:1,
					max:12
				}
			}
		});
		if (form.valid()) {
			console.log("Submit");
			$('#result-decimo-terceiro').show();
	    	var salarioBruto = $('#salarioBruto').val();
	    	var numeroDependentes = $('#numeroDependentes').val();
	    	var quantidadeMeses = $('#quantidadeMeses').val();
	    	var valorDecimoTerceiro = calcularDecimoTerceiro(removerMascara(salarioBruto), quantidadeMeses, numeroDependentes);
	    	console.log("Resultado: "+valorDecimoTerceiro);
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado do Calculo Décimo Terceiro';
	    	resultado.itens = {'Valor Décimo Terceiro': formatarRealDouble(valorDecimoTerceiro)};
	    	exibirResultado('result-decimo-terceiro', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#result-decimo-terceiro').hide();
		}
		return false;
	});
});


