$('#p-ferias').on('pageinit', function(event){
    console.log('Page Init Decimo Terceiro');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#result-ferias').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parent().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				salarioBruto: {
					required: true
				},
				numeroDependentes: {
					required: true
				},
				qtdMesesTrabalhados: {
					required: true,
					min: 1,
					max: 12
				}
			}
		});
		if (form.valid()) {
			console.log("Submit");
			$('#result-ferias').show();
	    	var salarioBruto = $('#salarioBruto').val();
	    	var qtdMesesTrabalhados = $('#qtdMesesTrabalhados').val();
	    	var numeroDependentes = $('#numeroDependentes').val();
	    	var result = calcularFerias(removerMascara(salarioBruto), qtdMesesTrabalhados, numeroDependentes);
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado do Cálculo de Férias';
	    	resultado.itens = {'Valor das Férias': formatarRealDouble(result)};
	    	exibirResultado('result-ferias', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#result-ferias').hide();
		}
		return false;
	});
});


