$('#p-inss').on('pageinit', function(event){
    console.log('Page Init INSS');
    
    
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#result-inss').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorPlacement: function(error, element) {
				console.log(element);
			     error.appendTo(element.parent().prev("label") );
		    },
		    wrapper: "div",
			rules: {
				salarioBruto: {
					required: true
				},
				numeroDependentes: {
					required: true,
					min:0,
					max:99
				},
				outrosDescontos: {
					required: false
				}
			}
		});
		if (form.valid()) {
			console.log("Submit");
			$('#result-inss').show();
	    	var salarioBruto = $('#salarioBruto').val();
	    	var numeroDependentes = $('#numeroDependentes').val();
	    	var outrosDescontos = $('#outrosDescontos').val();
	    	var rs = calculaSalarioLiquido(removerMascara(salarioBruto), removerMascara(outrosDescontos), numeroDependentes);
	    	
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado do INSS';
	    	resultado.itens = {'Desconto INSS': rs.descInss,
					'Valor INSS': formatarRealDouble(rs.valorINSS)};
	    	
	    	exibirResultado('result-inss', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#result-inss').hide();
		}
		return false;
	});
	
});
