$('#p-irrf').on('pageinit', function(event){
    console.log('Page Init IRRF');
    
    
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#result-irrf').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorPlacement: function(error, element) {
				console.log(element);
			     error.appendTo(element.parent().prev("label") );
		    },
		    wrapper: "div",
			rules: {
				salarioBruto: {
					required: true
				},
				numeroDependentes: {
					required: true,
					min:0,
					max:99
				},
				outrosDescontos: {
					required: false
				}
			}
		});
		if (form.valid()) {
			console.log("Submit");
			$('#result-irrf').show();
	    	var salarioBruto = $('#salarioBruto').val();
	    	var numeroDependentes = $('#numeroDependentes').val();
	    	var outrosDescontos = $('#outrosDescontos').val();
	    	var rs = calculaSalarioLiquido(removerMascara(salarioBruto), removerMascara(outrosDescontos), numeroDependentes);
	    	
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado do IRRF';
	    	resultado.itens = {'Desconto Aliquota': rs.descAliquota,
	    			'Valor do IRRF': formatarRealDouble(rs.valorIPRF)};
	    	
	    	exibirResultado('result-irrf', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#result-irrf').hide();
		}
		return false;
	});
	
});
