$('#p-rescisao').on('pageinit', function(event){
    console.log('Page Init Rescisão CLT');
    
    definirDatePicker("#dataEntradaTrabalho");
    definirDatePicker("#dataSaidaTrabalho");
    
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#result-rescisao').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parent().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				salarioBruto: {
					required: true
				},
				dataEntradaTrabalho: {
					required: true
				},
				dataSaidaTrabalho: {
					required: true
				},
				motivoResicao: {
					required: true
				},
				avisoPrevio: {
					required: true
				},
				feriasVencidas: {
					required: true
				}
			}
		});
		if (form.valid()) {
			console.log("Submit");
			$('#result-rescisao').show();
	    	var salarioBruto = $('#salarioBruto').val();
	    	var dataEntradaTrabalho = $('#dataEntradaTrabalho').val();
	    	var dataSaidaTrabalho = $('#dataSaidaTrabalho').val();
	    	var motivoResicao = $('#motivoResicao').val();
	    	var avisoPrevio = $('#avisoPrevio').val();
	    	var feriasVencidas = $('#feriasVencidas').val();
	    	var result = calcRescisaoCLT(removerMascara(salarioBruto), dataEntradaTrabalho, dataSaidaTrabalho, avisoPrevio, motivoResicao, feriasVencidas);
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado do Cálculo da Rescisão CLT';
	    	resultado.itens = {
	    			'Férias Vencidas': result.feriasVencidas,
	    			'1/3 das Férias Vencidas': result.tercoFerias,
	    			'Férias Proporcionais (referência)': result.referenciaFeriasProporcionais,
	    			'Férias Proporcionais': result.feriasProporcionais,
	    			'1/3 Férias Proporcionais': result.feriasTercoProporcionais,
	    			'IRRF Férias (referência)': result.referenciaIRRFFerias,
	    			'IRRF Férias': result.descontoIRRFFerias,
	    			'Saldo Salário (referência)': result.referenciaSaldoSalarial,
	    			'Saldo Salário': result.saldoSalarial,
	    			'INSS do Saldo do Salário (referência)': result.referenciaINSSSalario,
	    			'INSS do Saldo do Salário': result.descontoINSSSaldoSalarial,
	    			'IRRF do Saldo do Salário (referência)': result.referenciaIRRFSaldoSalario,
	    			'IRRF do Saldo do Salário': result.descontoIRRFSaldoSalarial,
	    			'13º Proporcional (referência)': result.referencia13Proporcional,
	    			'13º Proporcional': result.decimoTerceiroProporcional,
	    			'INSS Sobre 13º Proporcional (referência)': result.referenciaINSS13Proporcional,
	    			'INSS Sobre 13º Proporcional': result.descontoINSS13Proporcional,
	    			'IRRF Sobre 13º Proporcional (referência)': result.referenciaIRRF13Proporcional,
	    			'IRRF Sobre 13º Proporcional': result.descontoIRRF13Proporcional,
	    			'Aviso Prévio (a receber)': result.avisoPrevioRecebe,
	    			'Aviso Prévio (a descontar)': result.avisoPrevioDesconta,
	    			'Valor Total (a receber)': result.vlTotalReceber,
	    			'Valor Total (a descontar)': result.vlTotalDescontar,
	    			'Valor da Rescisão': result.vlLiquidoReceber};
	    	exibirResultado('result-rescisao', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#result-rescisao').hide();
		}
		return false;
	});
});