$('#p-salarioLiquido').on('pageinit', function(event){
    console.log('Page Init Salario Liquido');
//    maskMoeda("salarioBruto");
//    maskMoeda("outrosDescontos");
    
    
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#result-salario-liquido').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorPlacement: function(error, element) {
				console.log(element);
			     error.appendTo(element.parent().prev("label") );
		    },
		    wrapper: "div",
			rules: {
				salarioBruto: {
					required: true
				},
				numeroDependentes: {
					required: true,
					min:0,
					max:99
				},
				outrosDescontos: {
					required: false
				}
			}
		});
		if (form.valid()) {
			console.log("Submit");
			$('#result-salario-liquido').show();
	    	var salarioBruto = $('#salarioBruto').val();
	    	var numeroDependentes = $('#numeroDependentes').val();
	    	var outrosDescontos = $('#outrosDescontos').val();
	    	var rs = calculaSalarioLiquido(removerMascara(salarioBruto), removerMascara(outrosDescontos), numeroDependentes);
	    	
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado do Cálculo Salário Líquido';
	    	resultado.itens = {'Sálario Liquido': formatarRealDouble(rs.salarioLiquido), 
					'Desconto Aliquota': rs.descAliquota,
					'Desconto INSS': rs.descInss,
					'Valor IRRF': formatarRealDouble(rs.valorIPRF),
					'Valor INSS': formatarRealDouble(rs.valorINSS)};
	    	
	    	exibirResultado('result-salario-liquido', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#result-salario-liquido').hide();
		}
		return false;
	});
	
});
