$('#p-saldoFGTS').on('pageinit', function(event){
    console.log('Page Init Saldo FGTS');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#result-saldo-fgts').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parent().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				salarioBruto: {
					required: true
				},
				quantidadeMeses: {
					required: true,
					min:1,
					max:12
				}
			}
		});
		if (form.valid()) {
			console.log("Submit");
			$('#result-saldo-fgts').show();
	    	var salarioBruto = $('#salarioBruto').val();
	    	var quantidadeMeses = $('#quantidadeMeses').val();
	    	var result = calcularFgts(removerMascara(salarioBruto), quantidadeMeses);
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado do Calculo Saldo FGTS';
	    	resultado.itens = {'Valor Total': formatarRealDouble(result.valorTotal),
	    						 'Valor Mês': formatarRealDouble(result.valorMes)};
	    	exibirResultado('result-saldo-fgts', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#result-saldo-fgts').hide();
		}
		return false;
	});
});


