$('#p-seguroDesemprego').on('pageinit', function(event){
    console.log('Page Init Decimo Terceiro');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#result-seguro-desemprego').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parent().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				salarioBruto: {
					required: true
				},
				numeroDependentes: {
					required: true,
					min:0,
					max:99
				},
				quantidadeMeses: {
					required: true,
					min:1,
					max:99
				}
			}
		});
		if (form.valid()) {
			console.log("Submit");
			$('#result-seguro-desemprego').show();
	    	var salarioBruto = $('#salarioBruto').val();
	    	var numeroDependentes = $('#numeroDependentes').val();
	    	var quantidadeMeses = $('#quantidadeMeses').val();
	    	var valorDecimoTerceiro = calcularDecimoTerceiro(removerMascara(salarioBruto), quantidadeMeses, numeroDependentes);
	    	console.log("Resultado: "+valorDecimoTerceiro);
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado do Calculo Décimo Terceiro';
	    	resultado.itens = {'Valor Décimo Terceiro': formatarRealDouble(valorDecimoTerceiro)};
	    	exibirResultado('result-seguro-desemprego', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#result-seguro-desemprego').hide();
		}
		return false;
	});
});


