$('#p-consorcio').on('pageinit', function(event){
    console.log('Page Init Consórcio');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#resultConsorcio').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		$("#valorPercentualTaxa").val(removeMascPorcentagem($("#valorPercentualTaxa").val()));
		$("#valorPercentualFundo").val(removeMascPorcentagem($("#valorPercentualFundo").val()));
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parent().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				valorTotalCredito: {
					required: true
				},
				qtdParcelas: {
					required: true,
					min:1,
					max:999
				},
				valorPercentualTaxa: {
					required: true
				},
				valorPercentualFundo: {
					required: true
				}
			}
		});
		if (form.valid()) {
			$("#valorPercentualTaxa").val(addMascPorcentagem($("#valorPercentualTaxa").val()));
			$("#valorPercentualFundo").val(addMascPorcentagem($("#valorPercentualFundo").val()));
			
			console.log("Submit");
			$('#resultConsorcio').show();
			
	    	var valorTotalCredito = $('#valorTotalCredito').val();
	    	var qtdParcelas = $('#qtdParcelas').val();
	    	var valorPercentualTaxa = $('#valorPercentualTaxa').val();
	    	var valorPercentualFundo = $('#valorPercentualFundo').val();
	    	var rs = calcularConsorcio(removerMascara(valorTotalCredito), removerMascara(qtdParcelas), removerMascPorcentagem(valorPercentualTaxa), removerMascPorcentagem(valorPercentualFundo));
	    	
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado do Consórcio';
	    	resultado.itens = {'Valor': formatarRealDouble(rs)};
	    	
	    	exibirResultado('resultConsorcio', resultado);
	    	console.log('Registrar Evento');
		} else {
			if ($("#valorPercentualTaxa").val() != null && $("#valorPercentualTaxa").val() != '') {
				$("#valorPercentualTaxa").val(addMascPorcentagem($("#valorPercentualTaxa").val()));
			}
			if ($("#valorPercentualFundo").val() != null && $("#valorPercentualFundo").val() != '') {
				$("#valorPercentualFundo").val(addMascPorcentagem($("#valorPercentualFundo").val()));
			}
			$('#resultConsorcio').hide();
		}
		return false;
	});
});