$('#p-velocidade-media').on('pageinit', function(event){
    console.log('Page Init Velocidade Média');
   	$('#limpar').click(function() {
   		var validator = $("#form").validate();
		validator.resetForm();
		$('#result-velocidade-media').hide();
	});

    var form = $('FORM');
	form.bind('submit', function() {
		form.validate({
			errorPlacement: function(error, element) {
			     error.appendTo(element.parents().prev("label"));
		    },
		    wrapper: "div",
			rules: {
				tipoMedida: {
					required: true
				},
				distancia: {
					required: true,
					max: 99999999999.00
				},
				tempo: {
					required: true,
					max: 99999999999.00
				}
			}
		});
		if (form.valid()) {
			console.log("Submit");
			$('#result-velocidade-media').show();
			
	    	var tipoMedida = $('#tipoMedida').val();
	    	var distancia = $('#distancia').val();
	    	var tempo = $('#tempo').val();
	    	
	    	var resultado = new Object();
	    	resultado.titulo = 'Resultado Velocidade Média';
	    	exibirResultado('result-velocidade-media', resultado);
	    	var valorVelocidadeMedia = calcularVelocidadeMedia(distancia, tempo, tipoMedida);
	    	if (valorVelocidadeMedia && tipoMedida == 1) {
                resultado.itens = {'Velocidade Média': valorVelocidadeMedia.metro};
            } else {
                resultado.itens = {'Velocidade Média': valorVelocidadeMedia.quilometro};
            }
	    	exibirResultado('result-velocidade-media', resultado);
	    	console.log('Registrar Evento');
		} else {
			$('#result-velocidade-media').hide();
		}
		return false;
	});
});