// Generated by CoffeeScript 1.6.1
var AnalogClock, Application, DigitalClock, Indicator, app, init, startButton;

Indicator = (function() {

  Indicator.prototype.dataPathRegex = /M ([+-]?[0-9]+\.?[0-9]*),([+-]?[0-9]+\.?[0-9]*) A ([+-]?[0-9]+\.?[0-9]*),([+-]?[0-9]+\.?[0-9]*) [0-1] ([0-1]) [0-1] ([+-]?[0-9]+\.?[0-9]*),([+-]?[0-9]+\.?[0-9]*)/i;

  function Indicator(el, max) {
    var all, args, mode, r, x1, x2, y1, y2, _ref;
    this.el = el;
    this.max = max;
    args = this.el.getAttribute('d').match(this.dataPathRegex);
    _ref = args.map(function(arg) {
      return parseFloat(arg);
    }), all = _ref[0], x1 = _ref[1], y1 = _ref[2], r = _ref[3], r = _ref[4], mode = _ref[5], x2 = _ref[6], y2 = _ref[7];
    this.cx = x1;
    this.cy = y1 + r;
    this.r = r;
    this.mode = mode;
  }

  Indicator.prototype.set = function(value) {
    return this.el.setAttribute('d', this.getPathData(value));
  };

  Indicator.prototype.getPathData = function(value) {
    var angle, mode, r, x1, x2, y1, y2;
    angle = 2 * value * Math.PI / this.max;
    r = this.r;
    x1 = this.cx;
    y1 = this.cy - this.r;
    x2 = this.cx + this.r * Math.sin(angle);
    y2 = this.cy - this.r * Math.cos(angle);
    if (value > this.max / 2) {
      mode = 1;
    } else {
      mode = 0;
    }
    return "M " + x1 + "," + y1 + " A " + r + "," + r + " 0 " + mode + " 1 " + x2 + "," + y2;
  };

  return Indicator;

})();

AnalogClock = (function() {

  function AnalogClock(doc) {
    this.doc = doc;
    this.second = new Indicator(this.doc.getElementById('seconds'), 60);
    this.minute = new Indicator(this.doc.getElementById('minutes'), 60);
    this.hour = new Indicator(this.doc.getElementById('hours'), 24);
    this.day = new Indicator(this.doc.getElementById('days'), 31);
    this.month = new Indicator(this.doc.getElementById('months'), 12);
  }

  AnalogClock.prototype.set = function(date) {
    this.second.set(date.getSeconds());
    this.minute.set(date.getMinutes());
    this.hour.set(date.getHours());
    this.day.set(date.getDate());
    this.month.set(date.getMonth());
  };

  return AnalogClock;

})();

DigitalClock = (function() {

  function DigitalClock(textElement) {
    this.textElement = textElement;
  }

  DigitalClock.prototype.pad = function(num) {
    var s;
    s = num.toString();
    while (s.length < 2) {
      s = "0" + s;
    }
    return s;
  };

  DigitalClock.prototype.set = function(date) {
    this.textElement.getElementsByClassName('seconds')[0].textContent = this.pad(date.getSeconds());
    this.textElement.getElementsByClassName('minutes')[0].textContent = this.pad(date.getMinutes());
    this.textElement.getElementsByClassName('hours')[0].textContent = this.pad(date.getHours());
    this.textElement.getElementsByClassName('days')[0].textContent = this.pad(date.getDate());
    this.textElement.getElementsByClassName('months')[0].textContent = this.pad(date.getMonth() + 1);
  };

  return DigitalClock;

})();

Application = (function() {

  function Application(startButton, analog, digital) {
    this.startButton = startButton;
    this.analog = analog;
    this.digital = digital;
  }

  Application.prototype.run = function() {
    var date;
    date = new Date();
    this.analog.set(date);
    return this.digital.set(date);
  };

  Application.prototype.start = function() {
    var _this = this;
    this.run();
    this.execution = setInterval(function() {
      return _this.run();
    }, 1000);
    return this.running = true;
  };

  Application.prototype.stop = function() {
    clearInterval(this.execution);
    return this.running = false;
  };

  return Application;

})();

init = function() {
  var analog, application, digital;
  analog = new AnalogClock(document);
  digital = new DigitalClock(document.getElementById('time'));
  return application = new Application(document.getElementById('start-button', analog, digital));
};

startButton = null;

app = null;

document.onclick = function() {
  var analog, digital;
  if (startButton) {
    document.documentElement.appendChild(startButton);
    startButton = false;
  } else {
    startButton = document.getElementById("start-button");
    console.log(startButton);
    startButton.parentNode.removeChild(startButton);
  }
  if (app) {
    app.stop();
    return app = null;
  } else {
    analog = new AnalogClock(document);
    digital = new DigitalClock(document.getElementById('time'));
    app = new Application(document.getElementById('start-button'), analog, digital);
    return app.start();
  }
};

