// Generated by CoffeeScript 1.6.3
(function() {
  (function() {
    var Weather;
    Weather = {
      init: function() {
        var that;
        that = this;
        return content.find(":submit").click(function(e) {
          var data;
          e.preventDefault();
          data = searchBox.val();
          if (data.length > 0) {
            that.city = data;
            searchBox.val("").focus();
            return that.gotInput(data);
          }
          return searchBox.val("").focus();
        });
      },
      convertToFarenheit: function(val) {
        return (((val - 273.15) * 1.8) + 32).toFixed(2) + " \u00B0F";
      },
      gotInput: function(city) {
        this.url = "http://api.openweathermap.org/data/2.5/weather?q=" + city + "&callback=?";
        return this.fetch();
      },
      fetch: function() {
        var that;
        that = this;
        return $.ajax({
          url: that.url,
          dataType: "json",
          success: function(data) {
            console.log(data);
            if (data.main) {
              that.weather = {
                city: data.name,
                country: data.sys.country,
                temp: that.convertToFarenheit(data.main.temp),
                humid: data.main.humidity,
                weatherdesc: data.weather[0].description
              };
              console.log("SUCCESS Connection");
              return that.attachTemplate(false);
            } else {
              that.attachTemplate(true);
              return console.log("DATA isn't available");
            }
          },
          error: function(data) {
            return console.log("ERROR Connection");
          }
        });
      },
      attachTemplate: function(error) {
        var data, template;
        template = Handlebars.compile(handleBar.html());
        data = this.weather;
        if (error) {
          data = {
            msg: "The city you have entered is not available"
          };
        }
        error = false;
        return outputLocation.prepend(template(data));
      }
    };
    return Weather.init(this.handleBar = $("#weather-template"), this.content = $("#main"), this.outputLocation = $("#output"), this.searchBox = $("#searchCity"));
  })();

}).call(this);

/*
//@ sourceMappingURL=custom.map
*/
