window.settings = window.domElements = window.objects = window.utils = window.variables = window.canvasElements = window.globals = window.events = window.constants = {};
objects.intro = objects.game = objects.records = objects.server = undefined;
events.CELL_CLEARED = "cell_cleared";
events.CELL_FILLED = "cell_filled";
variables.playerName = variables.currentScore = undefined;
variables.totalImages = variables.imagesLoaded = undefined;
constants.GAME_WIDTH = 600;
constants.GAME_HEIGHT = 600;
constants.GAME_MIN_WIDTH = 150;
constants.GAME_MIN_HEIGHT = 150;
constants.MILISECONDS_FOR_FRAME = 1000 / 25;
constants.SCREENS_ANIMATION_DURATION = 500;
variables.maxFigureSize = variables.sizeDifference = undefined;
variables.prisesImages = variables.figuresImages = undefined;
variables.param1 = "param1";
variables.param2 = "param2";

domElements.$introScreen = $("#intro_screen");
domElements.$gameScreen = $("#game_screen");
domElements.$recordScreen = $("#records_screen");
domElements.$infoScreen = $("#info_screen");
domElements.$preloader = $("#preloader");
domElements.$introGameName = $("#intro_game_name");
domElements.$canvas = $("#canvas");
domElements.invisibleClassName = "invisible";

utils.turnOnScreen = function($screen) {
    var $oldScreen, newZIndex;
    newZIndex = 3;
    if (typeof domElements.$activeScreen !== "undefined") {
        $oldScreen = domElements.$activeScreen;
        newZIndex = parseInt($oldScreen.css("z-index")) + 1;
    }
    domElements.$activeScreen = $screen;
    $screen.css("z-index", newZIndex);
    $screen.css("left", $(window).width() * -1);
    $screen.animate({left: 0}, constants.SCREENS_ANIMATION_DURATION, "swing", function() {
        if (($oldScreen != null) && $oldScreen != domElements.$activeScreen) $oldScreen.css({"left": "-2000px"});
    });
    utils.redrawDomBlockObject($screen);
}

utils.redrawDomBlockObject = function($object) {
    $object.css("display", "none");
    $object[0].offsetHeight;
    $object.css("display", "block");
}

utils.resizeAll = function() {
    utils.resizeCanvas();
}

utils.resizeCanvas = function() {
    var $canvasContainer = domElements.$gameScreen;
    var containerWidth = Math.max($canvasContainer.width(), constants.GAME_MIN_WIDTH);
    var containerHeight = Math.max($canvasContainer.height(), constants.GAME_MIN_HEIGHT);
    var ratio = constants.GAME_WIDTH / constants.GAME_HEIGHT;
    var marginLeft = 0;
    var marginTop = 0;
    var zoom = 1;

    var tempWidth = containerWidth;
    zoom = tempWidth / constants.GAME_WIDTH;
    var tempHeight = tempWidth / ratio;
    if(tempHeight > containerHeight) {
        tempHeight = containerHeight;
        tempWidth = containerHeight * ratio;
        zoom = tempHeight / constants.GAME_HEIGHT;
        marginLeft = (containerWidth - tempWidth) / 2;
    }else {
        marginTop = (containerHeight - tempHeight) / 2;
    }

    domElements.$canvas.width(tempWidth);
    domElements.$canvas.height(tempHeight);
    paper.view.viewSize = new paper.Size(tempWidth, tempHeight);
    paper.view.zoom = zoom;
    paper.view.size.width = tempWidth;
    paper.view.size.height = tempHeight;
    paper.view.center = new paper.Point(tempWidth / 2, tempHeight / 2);

    domElements.$canvas.css("margin-top", marginTop + "px");
    domElements.$canvas.css("margin-left", marginLeft + "px");
    paper.view.draw();
}

utils.setOrientationChangeListener = function() {
    $(window).bind('orientationchange', function(e){
        e.preventDefault();
        utils.pauseAndRedrawGame();
    });
}

utils.pauseAndRedrawGame = function() {
    objects.game.pauseGame(constants.MILISECONDS_FOR_FRAME);
    utils.redrawDomBlockObject(domElements.$activeScreen);
}
/*============= Set width of height in paper.Raster ============*/
// this.img.size.width = variables.playerImage.width * (settings.PLAYER_HEIGHT / variables.playerImage.height);

/*============= Get random element of array ============*/
// arr[Math.round(Math.random() * (arr.length - 1))]

/*============= Set variable with random variation's ============*/
// this.size = settings.START_SIZE + Math.round(Math.random() * (settings.VARIATIVE_SIZE * 2)) - settings.VARIATIVE_SIZE;