function Figure(type, color, point, size, points) {
    this.type = type;
    this.color = color;
    this.position = point;
    this.size = size;
    this.imageIndex = this.type == settings.IMAGE ? color : undefined;
    this.figure = undefined;
    this.points = points;

    this.setView();
}

Figure.prototype.setView = function() {
    switch (this.type) {
        case settings.STAR:
            this.drawStar();
            break;
        case settings.TRIANGLE:
            this.drawTriangle();
            break;
        case settings.RECTANGLE:
            this.drawRectangle();
            break;
        case settings.RHOMBUS:
            this.drawRhombus();
            break;
        case settings.CIRCLE:
            this.drawCircle();
            break;
        case settings.IMAGE:
            this.drawImage();
            break;
        default :
            this.drawRectangle();
            break;
    }
    if(this.type != settings.IMAGE) this.figure.fillColor = this.color;
    this.figure.position = this.position;
}

Figure.prototype.drawImage = function() {
    this.figure = new paper.Raster(variables.figuresImages[this.imageIndex]);
    this.figure.size = new paper.Size(this.size, this.size);
}

Figure.prototype.drawStar = function() {
    this.figure = new paper.Path.Star(new paper.Point(0, 0), 5, this.size / 4, this.size / 2);
}

Figure.prototype.drawTriangle = function() {
    this.figure = new paper.CompoundPath();
    this.figure.moveTo(0, this.size);
    this.figure.lineTo(this.size / 2, 0);
    this.figure.lineTo(this.size, this.size);
    this.figure.closePath();
}

Figure.prototype.drawRectangle = function() {
    this.figure = paper.Path.Rectangle(new paper.Point(0, 0), new paper.Size(this.size, this.size));
}

Figure.prototype.drawRhombus = function() {
    this.figure = new paper.CompoundPath();
    this.figure.moveTo(0, this.size / 2);
    this.figure.lineTo(this.size / 2, 0);
    this.figure.lineTo(this.size, this.size / 2);
    this.figure.lineTo(this.size / 2, this.size);
    this.figure.closePath();
}

Figure.prototype.drawCircle = function() {
    this.figure = new paper.Path.Circle(new paper.Point(0, 0), this.size / 2);
}

Figure.prototype.clear = function() {
    if(typeof (this.figure) != "undefined") {
        this.figure.remove();
        this.figure = undefined;
    }
}