function Records() {
    this.$alertBlock = $("#alert_block");
    this.$alertOkBtn = $("#ok_alert_btn");
    this.$okBtn = $("#ok_btn");
    this.$recordText = $("#record_text");
    this.$allRecordsBlock = $("#all_records_block");
    this.$nameBlock = $("#name_block");
    this.$okNameBtn = $("#ok_name_btn");
    this.$nameInput = $("#name_input");

    this.table = this.result = this.records = undefined;
    this.screenTimeout = undefined;
    this.setListeners();

}

Records.prototype.setNewRecords = function() {
    this.records = JSON.parse(objects.server.getRecords());
    this.result = variables.currentScore;
    variables.currentScore = undefined;
    this.$recordText.text("");
    this.$allRecordsBlock.empty();
    if(typeof(this.result) == "undefined") {
        this.buildRecordTable();
    }else {
        this.setCurrentRecord();
    }
}

Records.prototype.setListeners = function() {
    var records = this;
    this.setOkScreenListener();
    this.$okNameBtn.click(function(e) {
        if(records.$nameInput.val() == "") {
            records.$alertBlock.removeClass(domElements.invisibleClassName);
            return;
        }
        variables.playerName = records.$nameInput.val();
        records.$nameBlock.addClass(variables.invisibleClassName);
        records.checkResultAndBuildTable();
    });
    this.$alertOkBtn.click(function(e) {
        records.$alertBlock.addClass(domElements.invisibleClassName);
    });
}

Records.prototype.setOkScreenListener = function() {
    if(typeof(this.screenTimeout) != "undefined") {
        window.clearTimeout(this.screenTimeout);
        this.screenTimeout = undefined;
    }
    this.$okBtn.click(function(e) {
        utils.turnOnScreen(domElements.$introScreen);
        objects.records.$okBtn.unbind("click");
        objects.records.screenTimeout = window.setTimeout(function() {objects.records.setOkScreenListener();},
                constants.SCREENS_ANIMATION_DURATION);
    });
}

Records.prototype.buildRecordTable = function() {
    this.table = $("<table>", {
        "border": 1,
        "style": "width: 100%"
    });
    this.table.append("<tr><th width='20%'>Place</th><th>Name</th><th width='20%'>Points</th></tr>");
    for (var i = 0; i < this.records.length; i++) {
        str = "<tr>";
        str += "<td>" + (i + 1) + "</td>";
        str += "<td>" + this.records[i][objects.server.nameParameter] + "</td>";
        str += "<td>" + this.records[i][objects.server.pointsParameter] + "</td>";
        str += "</tr>";
        this.table.append(str);
    }
    this.$allRecordsBlock.append(this.table);
}

Records.prototype.setCurrentRecord = function() {
    if(typeof(variables.playerName) == "undefined") {
        this.$nameBlock.removeClass(domElements.invisibleClassName);
    }else {
        this.checkResultAndBuildTable()
    }
}

Records.prototype.checkResultAndBuildTable = function() {
    this.$recordText.text("Your result is " + this.result);
    this.updateRecordsIfNeeded();
    this.buildRecordTable();
}

Records.prototype.updateRecordsIfNeeded = function() {
    if(this.result <= this.records[this.records.length - 1][objects.server.pointsParameter]) return;
    var i = 0;
    while (i < this.records.length) {
        var prevResult = typeof(this.records[i - 1]) != "undefined" ? this.records[i - 1][objects.server.pointsParameter] : 1000000;
        if (this.result > this.records[i][objects.server.pointsParameter] && this.result <= prevResult) {
            this.records.splice(i, 0, objects.server.getRecordObject(variables.playerName, this.result));
            this.records.pop();
            objects.server.saveRecords(JSON.stringify(this.records));
            break;
        }
        i++;
    }
}