function Cell(point, size) {
    this.position = point;
    this.size = size;
    this.elementsPosition = new paper.Point(this.position.x + this.size.width / 2, this.position.y + this.size.height / 2);
    this.prise = this.figure = this.pointText = undefined;
    this.rect = this.selected = this.priseTimer = this.prisePoints = undefined;

    this.setView();
}

Cell.prototype.setView = function() {
    this.rect = new paper.Path.Rectangle(this.position, this.size);
    this.rect.strokeWidth = 2;
    this.rect.strokeColor = settings.CELL_UNSELECTED_COLOR;
}

Cell.prototype.onFrame = function() {
    if(typeof (this.priseTimer) != "undefined") {
        this.priseTimer += constants.MILISECONDS_FOR_FRAME;
        if(this.priseTimer >= settings.PRISE_TIME_MILLISECONDS) {
            this.clearPrise();
        }
    }

    if(typeof (this.pointText) != "undefined") {
        this.pointText.position.y -= 2;
        this.pointText.opacity -= 0.04;
        if(this.pointText.opacity < 0.1) this.removeText();
    }
}

Cell.prototype.rectClicked = function(point) {
    if(point.x >= this.rect.position.x - this.size.width / 2 && point.x <= this.rect.position.x + this.size.width / 2
            && point.y >= this.rect.position.y - this.size.height / 2 && point.y <= this.rect.position.y + this.size.height / 2) {
        return true;
    }
    return false;
}

Cell.prototype.addRandomPrise = function() {
    var priseSize = settings.FIGURE_MIN_SIZE + variables.sizeDifference;
    this.priseTimer = 0;
    var index = Math.round(Math.random() * (settings.PRISES.length - 1));
    this.prisePoints = settings.PRISES[index][settings.pointsParameter];
    this.prise = new paper.Raster(variables.prisesImages[index]);
    this.prise.position = this.elementsPosition;
    this.prise.size = new paper.Size(priseSize, priseSize);
    $(this).trigger(events.CELL_FILLED);
}

Cell.prototype.clearPrise = function() {
    this.prisePoints = undefined;
    this.priseTimer = undefined;
    this.removePrise();
    $(this).trigger(events.CELL_CLEARED);
}

Cell.prototype.clearFigure = function() {
    this.removeFigure();
    this.unselect();
    $(this).trigger(events.CELL_CLEARED);
}

Cell.prototype.setFigure = function(type, color) {
    this.figure = new Figure(type, color, this.elementsPosition, settings.FIGURE_MIN_SIZE, settings.START_FIGURE_POINTS);
    $(this).trigger(events.CELL_FILLED);
}

Cell.prototype.isEqualsFigures = function(figure) {
    var colorParam1 = this.figure.type == settings.IMAGE ? this.figure.imageIndex : this.figure.color;
    var colorParam2 = figure.type == settings.IMAGE ? figure.imageIndex : figure.color;
    if(colorParam1 != colorParam2 || this.figure.type != figure.type || this.figure.size != figure.size) return false;

    objects.game.points += this.figure.points;
    objects.game.setTexts();
    this.setPointsText(this.figure.points);

    var type = this.figure.type;
    var points = this.figure.points * 2;
    var figureSize = this.figure.size + variables.sizeDifference;
    if(figureSize > variables.maxFigureSize) {
        this.clearFigure();
        return true;
    }
    this.removeFigure();

    this.figure = new Figure(type, colorParam1, this.elementsPosition, figureSize, points);
    this.figure.figure.moveBelow(this.pointText);
    return true;
}

Cell.prototype.setPointsText = function(points) {
    this.pointText = new paper.PointText({
        content: points,
        fillColor: settings.POINTS_TEXT_COLOR,
        fontFamily: 'Times new roman',
        fontWeight: 'bold',
        fontSize: settings.POINTS_TEXT_SIZE
    });
    this.pointText.position = this.elementsPosition;
}

Cell.prototype.unselect = function() {
    this.selected = false;
    this.rect.strokeWidth = 2;
    this.rect.strokeColor = settings.CELL_UNSELECTED_COLOR;
}

Cell.prototype.select = function() {
    this.selected = true;
    this.rect.strokeWidth = 3;
    this.rect.strokeColor = settings.CELL_SELECTED_COLOR;
}

Cell.prototype.clear = function() {
    this.removePrise();
    this.removeFigure();
    this.removeText();
}

Cell.prototype.removePrise = function() {
    if(typeof (this.prise) != "undefined") {
        this.prise.remove();
        this.prise = undefined;
    }
}

Cell.prototype.removeFigure = function() {
    if(typeof (this.figure) != "undefined") {
        this.figure.clear();
        this.figure = undefined;
    }
}

Cell.prototype.removeText = function() {
    if(typeof (this.pointText) != "undefined") {
        this.pointText.remove();
        this.pointText = undefined;
    }
}