function Game() {
    this.$recordsPopup = $("#records_popup");
    this.$popupPointsParagraph = $("#points_paragraph");
    this.$popupPlayAgainBtn = $("#records_popup_btn");
    this.$popupPlayAgainBtn.click(function(e) {
        objects.game.$recordsPopup.addClass(domElements.invisibleClassName);
        objects.game.startNewGame();
        utils.turnOnScreen(domElements.$gameScreen);
    });

    this.$pointsSpan = $("#points_span");
    this.points = undefined;

    this.tick = this.timer = this.clearTimeout = this.pauseTimeout = undefined;
    this.background = undefined;
    this.cells = this.filledCells = this.emptyCells = this.selectedCell = undefined;
    this.counter = this.timeForSpawn = this.gameFiguresTypes = undefined;

    this.setView();
    this.setCells();
}

Game.prototype.setView = function() {
    this.background = new paper.Path.Rectangle(new paper.Point(0, 0), new paper.Size(constants.GAME_WIDTH, constants.GAME_HEIGHT));
    this.background.fillColor = settings.BACKGROUND_COLOR;
}

Game.prototype.setCells = function() {
    this.cells = new Array();
    var cellWidth = constants.GAME_WIDTH / settings.CELLS_ROWS_COLUMNS_COUNT;
    var cellHeight = constants.GAME_HEIGHT / settings.CELLS_ROWS_COLUMNS_COUNT;
    variables.maxFigureSize = Math.min(cellWidth - settings.FIGURES_PADDING * 2, cellHeight - settings.FIGURES_PADDING * 2);
    variables.sizeDifference = (variables.maxFigureSize - settings.FIGURE_MIN_SIZE) / (settings.FIGURES_UNION_COUNT - 1);
    var size = new paper.Size(cellWidth, cellHeight);
    for(var i = 0; i < settings.CELLS_ROWS_COLUMNS_COUNT; i++) {
        for(var j = 0; j < settings.CELLS_ROWS_COLUMNS_COUNT; j++) {
            var cell = new Cell(new paper.Point(cellWidth * i, cellHeight * j), size);
            this.addCellListeners(cell);
            this.cells.push(cell);
        }
    }
}

Game.prototype.addCellListeners = function(cell) {
    $(cell).bind(events.CELL_CLEARED, function(e) {
        var filledIndex = objects.game.emptyCells.indexOf(e.target);
        objects.game.emptyCells.push(e.target);
        objects.game.filledCells.splice(filledIndex, 1);
    });
    $(cell).bind(events.CELL_FILLED, function(e) {
        var emptyIndex = objects.game.emptyCells.indexOf(e.target);
        objects.game.filledCells.push(e.target);
        objects.game.emptyCells.splice(emptyIndex, 1);
        if(objects.game.filledCells.length == objects.game.cells.length) objects.game.endGame();
    });
}

Game.prototype.setMouseClick = function(mousePoint) {
    for(var i = 0; i < this.cells.length; i++) {
        if(this.cells[i].rectClicked(mousePoint)) {
            if(typeof (this.cells[i].prise) != "undefined") {
                this.points += this.cells[i].prisePoints;
                this.setTexts();
                this.cells[i].setPointsText(this.cells[i].prisePoints);
                this.cells[i].clearPrise();
            }
            if(typeof (this.cells[i].figure) != "undefined") {
                if(typeof (this.selectedCell) == "undefined") {
                    this.cells[i].select();
                    this.selectedCell = this.cells[i];
                }else {
                    if(this.cells[i] == this.selectedCell) return;
                    if(this.cells[i].isEqualsFigures(this.selectedCell.figure)) {
                        this.selectedCell.clearFigure();
                        this.selectedCell = undefined;
                    }else {
                        this.selectedCell.unselect();
                        this.selectedCell = this.cells[i];
                        this.cells[i].select();
                    }
                }
            }
            break;
        }
    }
}

Game.prototype.startNewGame = function() {
    this.points = 0;
    this.filledCells = new Array();
    this.emptyCells = new Array();
    for(var i = 0; i < this.cells.length; i++) this.emptyCells.push(this.cells[i]);
    this.selectedCell = undefined;
    this.setTexts();
    this.tick = 0;
    this.counter = 0;
    this.timeForSpawn = settings.START_APPEARANCE_SPEED_MILLISECONDS;
    this.generateGameFiguresTypes();
    for(var i = 0; i < settings.START_FIGURES_PAIRS; i++) this.spawnOnePair();
    this.timer = window.setInterval(function() {
        objects.game.onFrame();
    }, constants.MILISECONDS_FOR_FRAME);
}

Game.prototype.generateGameFiguresTypes = function() {
    this.gameFiguresTypes = new Array();
    for(var i = 0; i < settings.FIGURES_TYPE_PER_GAME; i++) this.gameFiguresTypes.push(this.getRandomFigureType());
}

Game.prototype.getRandomFigureType = function() {
    var figureType = new Object();
    figureType[variables.param1] = settings.GAME_FIGURES[Math.round(Math.random() * (settings.GAME_FIGURES.length - 1))];
    figureType[variables.param2] = settings.GAME_COLORS[Math.round(Math.random() * (settings.GAME_COLORS.length - 1))];
    if(figureType[variables.param1] == settings.IMAGE) {
        figureType[variables.param2] = Math.round(Math.random() * (settings.CUSTOM_FIGURES_IMAGES_PATHS.length - 1));
    }
    for(var i = 0; i < this.gameFiguresTypes.length; i++) {
        if(this.gameFiguresTypes[i][variables.param1] == figureType[variables.param1] && this.gameFiguresTypes[i][variables.param2]
                == figureType[variables.param2]) {
            return this.getRandomFigureType();
        }
    }
    return figureType;
}

Game.prototype.pauseGame = function(pauseMilliseconds) {
    if(typeof (this.timer) == "undefined") return;
    window.clearInterval(this.timer);
    this.timer = undefined;
    this.pauseTimeout = window.setTimeout(function(){objects.game.resumeGame();}, pauseMilliseconds);
}

Game.prototype.resumeGame = function() {
    window.clearTimeout(this.pauseTimeout);
    this.pauseTimeout = undefined;
    this.timer = window.setInterval(function() {objects.game.onFrame();}, constants.MILISECONDS_FOR_FRAME);
}

Game.prototype.onFrame = function() {
    this.tick += constants.MILISECONDS_FOR_FRAME;
    if(this.tick % settings.LEVEL_DURATION_IN_SECONDS * 1000 == 0) {
        this.timeForSpawn -= settings.MINUS_APPEARENCE_SPEED_PER_LEVEL;
        this.timeForSpawn = Math.max(this.timeForSpawn, settings.MIN_APPEARENCE_SPEED);
    }

    this.counter += constants.MILISECONDS_FOR_FRAME;
    if(this.counter >= this.timeForSpawn) {
        this.counter = 0;
        this.spawnOnePair();
    }

    for(var i = 0; i < this.cells.length; i++) this.cells[i].onFrame();
	this.spawnPriseIfNeeded();
	paper.view.draw();
}

Game.prototype.spawnOnePair = function() {
    var figureType = this.gameFiguresTypes[Math.round(Math.random() * (this.gameFiguresTypes.length - 1))];
    this.emptyCells[Math.round(Math.random() * (this.emptyCells.length - 1))].setFigure(figureType[variables.param1], figureType[variables.param2]);
    if(this.emptyCells.length == 0) {
        this.endGame();
        return;
    }
    this.emptyCells[Math.round(Math.random() * (this.emptyCells.length - 1))].setFigure(figureType[variables.param1], figureType[variables.param2]);
}

Game.prototype.spawnPriseIfNeeded = function() {
    if(Math.random() > settings.PRISE_POSSIBILITY_PER_FRAME / 100) return;
    this.emptyCells[Math.round(Math.random() * (this.emptyCells.length - 1))].addRandomPrise();
}

Game.prototype.endGame = function() {
    window.clearInterval(this.timer);
    this.timer = undefined;
    this.clearTimer = window.setTimeout(function() {
        objects.game.removeGameObjects();
    }, constants.MILISECONDS_FOR_FRAME * 2);
}

Game.prototype.removeGameObjects = function() {
    window.clearTimeout(this.clearTimer);
    this.clearTimer = undefined;

    variables.currentScore = this.points;
    for(var i = 0; i < this.cells.length; i++) {
        this.cells[i].clear();
    }

    if(typeof (this.selectedCell) != "undefined") {
        this.selectedCell.unselect();
        this.selectedCell = undefined;
    }

    if(settings.RECORDS_ENABLED) {
        objects.records.setNewRecords();
        utils.turnOnScreen(domElements.$recordScreen);
    }else {
        this.$recordsPopup.removeClass(domElements.invisibleClassName);
        this.$popupPointsParagraph.text(this.points);
    }
}

Game.prototype.setTexts = function() {
    this.$pointsSpan.text(this.points);
}