function Intro() {
    this.$playBtn = $("#play_btn");
    this.$recordBtn = $("#records_btn");
	this.$infoBtn = $("#info_btn");
    domElements.$introGameName.text(settings.GAME_NAME);
    document.title = settings.GAME_NAME;

    if(!settings.RECORDS_ENABLED) {
        this.$recordBtn.addClass(domElements.invisibleClassName);
    }
	
    this.screenTimeout = undefined;
    this.setListeners();
}

Intro.prototype.setListeners = function() {
    if(typeof(this.screenTimeout) != "undefined") {
        window.clearTimeout(this.screenTimeout);
        this.screenTimeout = undefined;
    }
    this.$playBtn.click(function(e) {
        objects.intro.disableButtons();
        objects.game.startNewGame();
        utils.turnOnScreen(domElements.$gameScreen);
    });
    this.$recordBtn.click(function(e) {
        objects.intro.disableButtons();
        objects.records.setNewRecords();
        utils.turnOnScreen(domElements.$recordScreen);
    });    
	this.$infoBtn.click(function(e) {
        objects.intro.disableButtons();
		objects.records.setNewRecords();
		utils.turnOnScreen(domElements.$infoScreen);
    });
}

Intro.prototype.disableButtons = function() {
    this.$recordBtn.unbind("click");
	this.$infoBtn.unbind("click");
    this.$playBtn.unbind("click");
    this.screenTimeout = window.setTimeout(function(){objects.intro.setListeners();},
            constants.SCREENS_ANIMATION_DURATION);
}