globals.loadGameData = function() {
    variables.imagesLoaded = 0;
    variables.totalImages = settings.PRISES.length;

    variables.prisesImages = new Array();
    for(var i = 0; i < settings.PRISES.length; i++) {
        var img = new Image();
        utils.setImageLoadListener(img);
        img.src = settings.PRISES[i][settings.imagePathParameter];
        variables.prisesImages.push(img);
    }

    variables.figuresImages = new Array();
    for(var i = 0; i < settings.CUSTOM_FIGURES_IMAGES_PATHS.length; i++) {
        var img = new Image();
        utils.setImageLoadListener(img);
        img.src = settings.CUSTOM_FIGURES_IMAGES_PATHS[i];
        variables.figuresImages.push(img);
    }
}

utils.loadOneImage = function(imagePath) {
    var img = new Image();
    utils.setImageLoadListener(img);
    img.src = imagePath;
}

utils.setImageLoadListener = function(img) {
    var oneImageLoaded = function() {
        variables.imagesLoaded++;
        if (variables.imagesLoaded == variables.totalImages) {
            domElements.$preloader.addClass(domElements.invisibleClassName);
            globals.initGameObjects();
        }
    }
    img.onload = function(e) {
        oneImageLoaded();
    };
    img.onerror = function(e) {
        oneImageLoaded();
        alert(img.src + " is missing");
    }
}

globals.initGameObjects = function() {
    if(settings.RECORDS_ENABLED) {
        objects.server = new Server();
        objects.records = new Records();
    }
    objects.intro = new Intro();
    objects.game = new Game();
    utils.turnOnScreen(domElements.$introScreen);
}


globals.init = function() {
    var canvas = document.getElementById("canvas");
    paper.setup(canvas);
    globals.loadGameData();
    utils.setVirtualMouseEvents();
    utils.setOrientationChangeListener();
    utils.resizeAll();
    $(window).resize(function(e) {
        utils.resizeAll();
    });
};

globals.init();