$(window).load(function () {
    jQuery.support.cors = true;
    var serverURL = "http://swipe.nthgensoftware.com/rest/";
    var isFirefox = navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
    var LOADER = '<img class="loader" src="images/loader.gif" />';
    var videosLoaded = false;
    var feedsLoaded = false;
    var appsLoaded = false;
    var videos = [];
    var feeds = [];
    var apps = [];

    var videoOpen = false;
    var appOpen = false;

    function log(message) {
        if(isFirefox) {
           // alert(message);
        } else {
            console.log(message);
        }
    }
    //UI
    $('#navigation .nav .content').each(function() {
       $(this).css({height: $(this).height() - 80});
    });
    if(isFirefox) {
        $('#header-background img').attr('src', 'images/top-header-firefox.png');
        $('#video-details .video').css('display', 'none');
        $('#video-details .details').css('marginTop', '-100px');
    } else {
        $('#video-details .title-image').css('display', 'none');
        $('#video-details .play-icon').css('display', 'none');
    }

    //Sticky Navigation
    $navigationContainer = $('#navigationContainer');
    $navItemWidth = $('.nav.pos1').width();
    $navHeader = $('#main-nav ul');
    $navHeaderWidth = $navHeader.width();
    var minSwipeDistance = $navItemWidth/4;
    $navPositions = [0, $navItemWidth, $navItemWidth*2, $navItemWidth*3];
    $targetScroll = 0;
    $activePage = 0;
    function setPageActive(index) {
        $.each($navHeader.find('li'), function(count, elem) {
            if(count == index) {
                $(elem).addClass('active');
            } else {
                $(elem).removeClass('active');
            }
        });
        $activePage = index;

        switch ($activePage) {
            case 0:
                if(!videosLoaded)
                    loadVideos();
                break;
            case 1:
                if(!feedsLoaded)
                    loadFeeds();
                break;
            case 2:
                if(!appsLoaded)
                    loadApps();
                break;
        }
    }
    function swipeLeft() {
        if(videoOpen) {
            return;
        }
        var currentPos = $navigationContainer.scrollLeft()/$navItemWidth;
        if(currentPos < 2) {
            $scrollLeft = $navigationContainer.scrollLeft();
            var closest = null;
            $.each($navPositions, function(){
                if (closest == null || Math.abs(this - $scrollLeft) < Math.abs(closest - $scrollLeft)) {
                    closest = this;
                }
            });
            $targetScroll = closest + $navItemWidth;
            $navigationContainer.stop(false).animate({
                scrollLeft: $targetScroll
            }, 350);
            $navHeader.stop(false).animate({
                marginLeft: parseInt($navHeader.css('marginLeft').replace("px","")) - ($navHeaderWidth/6)
            }, 350);
            setPageActive($activePage + 1);
        }
    }
    function swipeRight() {
        if(videoOpen) {
            return;
        }
        var currentPos = $navigationContainer.scrollLeft()/$navItemWidth;
        if(currentPos > 0) {
            $scrollLeft = $navigationContainer.scrollLeft();
            var closest = null;
            $.each($navPositions, function(){
                if (closest == null || Math.abs(this - $scrollLeft) < Math.abs(closest - $scrollLeft)) {
                    closest = this;
                }
            });
            $targetScroll = closest - $navItemWidth;
            $navigationContainer.stop(false).animate({
                scrollLeft: $targetScroll
            }, 350);
            $navHeader.stop(false).animate({
                marginLeft: parseInt($navHeader.css('marginLeft').replace("px","")) + ($navHeaderWidth/6)
            }, 350);
            setPageActive($activePage - 1);
        }
    }
    var touchStartX = 0;
    var touchStartY = 0;
    document.addEventListener('touchstart', function(event) {
        touchStartX = event.touches[0].pageX;
        touchStartY = event.touches[0].pageY;
    });
    document.addEventListener('touchmove', function(event) {
        var endX = event.touches[0].pageX;
        var endY = event.touches[0].pageY;

        if(videoOpen || appOpen) {
            return;
        } else if(touchStartX == 0 || touchStartY == 0) {
            return;
        } else if (touchStartY - endY > 10 || touchStartY - endY < -10) {
            return;
        }

        if(endX - touchStartX > minSwipeDistance) {
            swipeRight();
            touchStartX = 0;
        } else if (touchStartX - endX > minSwipeDistance) {
            swipeLeft();
            touchStartX = 0;
        } else if((touchStartX-endX > (minSwipeDistance/4) || touchStartX-endX < -(minSwipeDistance/4)) || $navigationContainer.scrollLeft() != $targetScroll) {
            var target = $targetScroll+(touchStartX-endX);
            if(target > 0 && target < $navigationContainer.width()*2) {
                $navigationContainer.stop(false).animate({
                    scrollLeft: target
                }, 0);
            }
        }
    });
    document.addEventListener('touchend', function(event) {
       touchStartX = 0;
        touchStartY = 0;
        $navigationContainer.stop(false).animate({
            scrollLeft: $targetScroll
        }, 300);
    });
    $(window).on('scroll', function() {
        $('html, body').stop(false).animate({
            scrollLeft: 0
        }, 0);
    });
    $('#navLeft').click(function() {
        swipeRight();
    });
    $('#navRight').click(function() {
       swipeLeft();
    });
    setPageActive(0);

    //REST API
    function createCORSRequest(method, url) {
        var xhr = new XMLHttpRequest();
        if(url.indexOf("http") == -1) {
            url = serverURL+url;
        }
        log("Creating " + method + " request for: " + url);
        if ("withCredentials" in xhr) {
            xhr.open(method, url, true);
        } else {
            //ERROR: CORS not supported.
            xhr = null;
        }
        return xhr;
    }

    function loadVideos() {
        log("Loading Videos...");
        $videoContainer = $('.nav.pos1 .content');
        $videoContainer.html(LOADER);
        var xhr = createCORSRequest('GET', "getVideos");
        xhr.onreadystatechange = function (oEvent) {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    log("Videos Loaded!");
                    videosLoaded = true;
                    videos = [];
                    var json = jQuery.parseJSON(xhr.responseText);
                    $videoContainer.html("");
                    $.each(json, function(count, video) {
                        videos.push(video);
                        $videoContainer.append(Mustache.render($('#videoPreview').html(), video));
                        var appContainer = $videoContainer.find('.featured').find('.apps').last();
                        $.each(video.featuredApps, function(count, app) {
                           appContainer.append(Mustache.render($('#miniAppPreview').html(), app));
                        });
                    });
                    $.each($videoContainer.find('.videoPreview'), function(count, elem) {
                        $(elem).attr('data-pos', count);
                        $(elem).click(function() {
                            openVideoAtPosition($(this).attr('data-pos'));
                        });
                    });
                } else {
                    log("Error: " + xhr.statusText);
                    //TODO: Error message
                }
            }
        };
        xhr.send();
    }
    function loadFeeds() {
        log("Loading Feeds...");
        $feedsContainer = $('.nav.pos2 .content');
        $feedsContainer.html(LOADER);
        var xhr = createCORSRequest('GET', "getFeeds");
        xhr.onreadystatechange = function (oEvent) {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    log("Feeds Loaded!");
                    feedsLoaded = true;
                    feeds = [];
                    $xml = $( jQuery.parseXML(xhr.responseText) );
                    var title = $xml.find("title").first().text();
                    $feedsContainer.html("");
                    $.each($xml.find("item"), function(count, item) {
                        $item = $(item);
                        var feedItem = {
                            "name": $item.find('title').text(),
                            "source": title,
                            "thumb": "",
                            "url": $item.find('link').text(),
                            "timeago": jQuery.timeago(Date.parse($item.find('pubDate').text()))
                        };
                        if(isFirefox) {
                            feedItem.thumb = $item.find('media\\:content').last().attr('url');
                        } else {
                            feedItem.thumb = $item.find('content').last().attr('url');
                        }
                        feeds.push(feedItem);


                        //Mustache won't work here for some reason, lets do it manual
                        $preview = $( $('#feedPreview').html() );
                        $preview.find(".title").html(feedItem.name);
                        $preview.find(".details").html(feedItem.source + " - " + feedItem.timeago);
                        if(feedItem.thumb != null) {
                            $preview.find('.thumbnail').attr('src', feedItem.thumb);
                        } else {
                            $preview.find('.thumbnail').attr('src', 'images/rss-filler-mobile.jpg');
                        }
                        $preview.click(function() {
                           openFeed(feedItem);
                        });
                        $feedsContainer.append($preview);
                    });
                } else {
                    log("Error: " + xhr.statusText);
                    //TODO: Error message
                }
            }
        };
        xhr.send();
    }
    function loadApps() {
        log("Loading Apps...");
        $appsContainer = $('.nav.pos3 .content');
        $appsContainer.html(LOADER);
        var xhr = createCORSRequest('GET', "getApps");
        xhr.onreadystatechange = function (oEvent) {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    log("Apps Loaded!");
                    appsLoaded = true;
                    apps = [];
                    var json = jQuery.parseJSON(xhr.responseText);
                    $appsContainer.html("");
                    $.each(json, function(count, app) {
                        apps.push(app);
                        var output = Mustache.render($('#appPreview').html(), app);
                        $appsContainer.append(output);
                        if(app.androidURL == null) {
                            $appsContainer.find('.playstore').last().hide();
                        }
                        if(app.firefoxURL == null) {
                            $appsContainer.find(".marketplace").last().hide();
                        }
                    });
                    $.each($appsContainer.find('.appPreview'), function(count, block) {
                        $(block).click(function() {
                            openApp(apps[count], "Apps");
                        });
                        $(block).addClass(count%2 == 0 ? "even":"odd");
                    });
                } else {
                    log("Error: " + xhr.statusText);
                    //TODO: Error message
                }
            }
        };
        xhr.send();
    }

    //Detail Pages
    function setBackButton(text) {
        if(text == null) {
            $('#back').html("");
        } else {
            $('#back').html('<img src="images/chevron.png" height="16"/><span class="text">'+text+'</span>');
        }
    }


    function openVideoAtPosition(pos) {
        openVideo(videos[pos]);
    }
    function openVideo(video) {
        document.location.hash="video";
        var $videoContainer = $('#video-details');
        $videoContainer.find(".content .title").html(video.name);
        $videoContainer.find(".content .description").html(video.description);

        var appContainer = $videoContainer.find(".content .featured .app-list").html(video.description);
        appContainer.html("");
        $.each(video.featuredApps, function(count, app) {
            appContainer.append("<div class='divider'></div>");

            var output = Mustache.render($('#appPreview').html(), app);
            appContainer.append(output);
            appContainer.find(".appPreview").last().click(function() {
               openApp(app, "Video");
            });
            if(app.androidURL == null) {
                appContainer.find('.playstore').last().hide();
            }
            if(app.firefoxURL == null) {
                appContainer.find(".marketplace").last().hide();
            }
        });

        if(isFirefox) {
            $videoContainer.find(".content .title-image").attr('src', video.videoThumbnail);
            $videoContainer.find(".content .title-image, .content .play-icon").click(function() {
                openYoutubeVideo(video.youtubeID);
            });
        } else {
            var frame = document.createElement('iframe');
            frame.setAttribute('src','http://www.youtube.com/embed/'+video.youtubeID+'?autoplay=0');
            frame.setAttribute('type', 'text/html');
            frame.setAttribute('width', $videoContainer.find(".video").css('width').replace("px", ""));
            frame.setAttribute('height', $videoContainer.find(".video").height());
            frame.setAttribute('frameborder', '0');
            frame.setAttribute('allowfullscreen', 1);
            $videoContainer.find('.video').html(frame);
        }
        $videoContainer.find('.twitter-share').html('<a id="twitter-btn" href="https://twitter.com/share" class="twitter-share-button" data-url="http://www.youtube.com/v/'+video.youtubeID+'" data-text="Check out the latest episode of Swipe! '+video.name+'" data-via="swipe" data-hashtags="swipe">Tweet</a><script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?"http":"https";if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+"://platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document, "script", "twitter-wjs");</script>');
        if(window.twttr) {
            twttr.widgets.load();
        }


        $videoContainer.show();
        $navigationContainer.hide();
        $('#main-nav').hide();
        setBackButton('Videos');
        videoOpen = true;
    }
    function closeVideo() {
        videoOpen = false;
        setBackButton(null);
        var $videoContainer = $('#video-details');
        $videoContainer.hide();
        $navigationContainer.show();
        $('#main-nav').show();
    }
    function openYoutubeVideo(youtubeID) {
        if(isFirefox) {
            window.open('https://www.youtube.com/watch?feature=player_embedded&showinfo=0&modestbranding=1&title=&v='+youtubeID, '_blank');
        } else {
            window.open('http://www.youtube.com/v/'+youtubeID);
        }
    }

    function openFeedAtPosition(pos) {
        openFeed(feeds[pos]);
    }
    function openFeed(feed) {
        window.open(feed.url);
    }

    var $appContainer = $('#app-details');
    function openAppAtPosition(pos) {
        openApp(apps[pos], backText);
    }
    function openApp(app, backText) {
        if(isFirefox) {
            if(app.firefoxURL != null) {
                window.open(app.firefoxURL);
            }
        } else {
            if(app.androidURL != null) {
                window.open(app.androidURL);
            }
        }
//        document.location.hash="app";
//
//        $appContainer.find('.details .title').html(app.name);
//        $appContainer.find('.details .developerName').html(app.developerName);
//        $appContainer.find('.details .genre').html(app.genre);
//        $appContainer.find('.details img').attr('src', app.iconURL);
//        $appContainer.find('.description-screenshots .description .cont').html(app.description);
//
//        $appContainer.find('.rating').each(function() {
//            $.each($(this).find('span'), function(count, span) {
//                if(count < parseInt(app.rating)) {
//                    $(span).addClass("highlight");
//                }
//            });
//        });
//
//        $appContainer.show();
//        $navigationContainer.hide();
//        $('#main-nav').hide();
//        setBackButton(backText);
//        appOpen = true;
    }
    function closeApp() {
//        appOpen = false;
//        if(videoOpen) {
//            document.location.hash = "video";
//            var $videoContainer = $('#video-details');
//            $videoContainer.show();
//            setBackButton("Videos");
//            $appContainer.hide();
//        } else {
//            setBackButton(null);
//            $appContainer.hide();
//            $navigationContainer.show();
//            $navigationContainer.animate({
//                scrollLeft: $targetScroll
//            }, 0);
//            $('#main-nav').show();
//        }
    }

    $(window).hashchange( function(){
        var hash = document.location.hash.replace("#", "");
        if(hash == null || hash.length == 0 || hash == "home") {
            if(appOpen) {
                closeApp();
            } else if(videoOpen) {
                closeVideo();
            }
        }
    });
    $('#back').click(function() {
        document.location.hash = 'home';
    });

    $('#refresh').click(function() {
        reload();
    });
    $('#refresh').on('touchstart', function() {
       $(this).find('img').attr('src', 'images/refresh-button-on.png');
    });
    $('#refresh').on('touchend', function() {
       $(this).find('img').attr('src', 'images/refresh-button.png');
    });

    function reload() {
        if(appsLoaded) {
            loadApps();
        }
        if(feedsLoaded) {
            loadFeeds();
        }
        if(videosLoaded) {
            loadVideos();
        }
    }
});