/*
 IDBWrapper - A cross-browser wrapper for IndexedDB
 Copyright (c) 2011 - 2013 Jens Arps
 http://jensarps.de/

 Licensed under the MIT (X11) license
*/
(function(h,i,j){"function"===typeof define?define(i):"undefined"!==typeof module&&module.exports?module.exports=i():j[h]=i()})("IDBStore",function(){var h=function(a){throw a;},i={storeName:"Store",storePrefix:"IDBWrapper-",dbVersion:1,keyPath:"id",autoIncrement:!0,onStoreReady:function(){},onError:h,indexes:[]},j=function(a,c){for(var b in i)this[b]="undefined"!=typeof a[b]?a[b]:i[b];this.dbName=this.storePrefix+this.storeName;this.dbVersion=parseInt(this.dbVersion,10);c&&(this.onStoreReady=c);
b="object"==typeof window?window:self;this.idb=b.indexedDB||b.webkitIndexedDB||b.mozIndexedDB;this.keyRange=b.IDBKeyRange||b.webkitIDBKeyRange||b.mozIDBKeyRange;this.features={hasAutoIncrement:!b.mozIndexedDB};this.consts={READ_ONLY:"readonly",READ_WRITE:"readwrite",VERSION_CHANGE:"versionchange",NEXT:"next",NEXT_NO_DUPLICATE:"nextunique",PREV:"prev",PREV_NO_DUPLICATE:"prevunique"};this.openDB()};j.prototype={version:"1.3.0",db:null,dbName:null,dbVersion:null,store:null,storeName:null,keyPath:null,
autoIncrement:null,indexes:null,features:null,onStoreReady:null,onError:null,_insertIdCount:0,openDB:function(){var a=this.idb.open(this.dbName,this.dbVersion),c=!1;a.onerror=function(a){var c=!1;"error"in a.target?c="VersionError"==a.target.error.name:"errorCode"in a.target&&(c=12==a.target.errorCode);if(c)this.onError(Error("The version number provided is lower than the existing one."));else this.onError(a)}.bind(this);a.onsuccess=function(a){if(!c)if(this.db)this.onStoreReady();else if(this.db=
a.target.result,"string"==typeof this.db.version)this.onError(Error("The IndexedDB implementation in this browser is outdated. Please upgrade your browser."));else if(this.db.objectStoreNames.contains(this.storeName))this.store=this.db.transaction([this.storeName],this.consts.READ_ONLY).objectStore(this.storeName),this.indexes.forEach(function(a){var b=a.name;b?(this.normalizeIndexData(a),this.hasIndex(b)?this.indexComplies(this.store.index(b),a)||(c=!0,this.onError(Error('Cannot modify index "'+
b+'" for current version. Please bump version number to '+(this.dbVersion+1)+"."))):(c=!0,this.onError(Error('Cannot create new index "'+b+'" for current version. Please bump version number to '+(this.dbVersion+1)+".")))):(c=!0,this.onError(Error("Cannot create index: No index name given.")))},this),c||this.onStoreReady();else this.onError(Error("Something is wrong with the IndexedDB implementation in this browser. Please upgrade your browser."))}.bind(this);a.onupgradeneeded=function(a){this.db=
a.target.result;this.store=this.db.objectStoreNames.contains(this.storeName)?a.target.transaction.objectStore(this.storeName):this.db.createObjectStore(this.storeName,{keyPath:this.keyPath,autoIncrement:this.autoIncrement});this.indexes.forEach(function(a){var b=a.name;b||(c=!0,this.onError(Error("Cannot create index: No index name given.")));this.normalizeIndexData(a);this.hasIndex(b)?this.indexComplies(this.store.index(b),a)||(this.store.deleteIndex(b),this.store.createIndex(b,a.keyPath,{unique:a.unique,
multiEntry:a.multiEntry})):this.store.createIndex(b,a.keyPath,{unique:a.unique,multiEntry:a.multiEntry})},this)}.bind(this)},deleteDatabase:function(){this.idb.deleteDatabase&&this.idb.deleteDatabase(this.dbName)},put:function(a,c,b,d){null!==this.keyPath&&(d=b,b=c,c=a);d||(d=h);b||(b=k);var f=!1,e=null,g=this.db.transaction([this.storeName],this.consts.READ_WRITE);g.oncomplete=function(){(f?b:d)(e)};g.onabort=d;g.onerror=d;null!==this.keyPath?(this._addIdPropertyIfNeeded(c),a=g.objectStore(this.storeName).put(c)):
a=g.objectStore(this.storeName).put(c,a);a.onsuccess=function(a){f=!0;e=a.target.result};a.onerror=d},get:function(a,c,b){b||(b=h);c||(c=k);var d=!1,f=null,e=this.db.transaction([this.storeName],this.consts.READ_ONLY);e.oncomplete=function(){(d?c:b)(f)};e.onabort=b;e.onerror=b;a=e.objectStore(this.storeName).get(a);a.onsuccess=function(a){d=!0;f=a.target.result};a.onerror=b},remove:function(a,c,b){b||(b=h);c||(c=k);var d=!1,f=null,e=this.db.transaction([this.storeName],this.consts.READ_WRITE);e.oncomplete=
function(){(d?c:b)(f)};e.onabort=b;e.onerror=b;a=e.objectStore(this.storeName)["delete"](a);a.onsuccess=function(a){d=!0;f=a.target.result};a.onerror=b},batch:function(a,c,b){b||(b=h);c||(c=k);"[object Array]"!=Object.prototype.toString.call(a)&&b(Error("dataArray argument must be of type Array."));var d=this.db.transaction([this.storeName],this.consts.READ_WRITE);d.oncomplete=function(){(g?c:b)(g)};d.onabort=b;d.onerror=b;var f=a.length,e=!1,g=!1,l=function(){f--;0===f&&!e&&(g=e=!0)};a.forEach(function(a){var c=
a.type,f=a.key,g=a.value,a=function(a){d.abort();e||(e=!0,b(a,c,f))};if("remove"==c)g=d.objectStore(this.storeName)["delete"](f),g.onsuccess=l,g.onerror=a;else if("put"==c)null!==this.keyPath?(this._addIdPropertyIfNeeded(g),g=d.objectStore(this.storeName).put(g)):g=d.objectStore(this.storeName).put(g,f),g.onsuccess=l,g.onerror=a},this)},putBatch:function(a,c,b){this.batch(a.map(function(a){return{type:"put",value:a}}),c,b)},removeBatch:function(a,c,b){this.batch(a.map(function(a){return{type:"remove",
key:a}}),c,b)},getAll:function(a,c){c||(c=h);a||(a=k);var b=this.db.transaction([this.storeName],this.consts.READ_ONLY),d=b.objectStore(this.storeName);d.getAll?this._getAllNative(b,d,a,c):this._getAllCursor(b,d,a,c)},_getAllNative:function(a,c,b,d){var f=!1,e=null;a.oncomplete=function(){(f?b:d)(e)};a.onabort=d;a.onerror=d;a=c.getAll();a.onsuccess=function(a){f=!0;e=a.target.result};a.onerror=d},_getAllCursor:function(a,c,b,d){var f=[],e=!1,g=null;a.oncomplete=function(){(e?b:d)(g)};a.onabort=d;
a.onerror=d;a=c.openCursor();a.onsuccess=function(a){(a=a.target.result)?(f.push(a.value),a["continue"]()):(e=!0,g=f)};a.onError=d},clear:function(a,c){c||(c=h);a||(a=k);var b=!1,d=null,f=this.db.transaction([this.storeName],this.consts.READ_WRITE);f.oncomplete=function(){(b?a:c)(d)};f.onabort=c;f.onerror=c;f=f.objectStore(this.storeName).clear();f.onsuccess=function(a){b=!0;d=a.target.result};f.onerror=c},_addIdPropertyIfNeeded:function(a){!this.features.hasAutoIncrement&&"undefined"==typeof a[this.keyPath]&&
(a[this.keyPath]=this._insertIdCount++ +Date.now())},getIndexList:function(){return this.store.indexNames},hasIndex:function(a){return this.store.indexNames.contains(a)},normalizeIndexData:function(a){a.keyPath=a.keyPath||a.name;a.unique=!!a.unique;a.multiEntry=!!a.multiEntry},indexComplies:function(a,c){return["keyPath","unique","multiEntry"].every(function(b){return"multiEntry"==b&&void 0===a[b]&&!1===c[b]?!0:c[b]==a[b]})},iterate:function(a,c){var c=m({index:null,order:"ASC",autoContinue:!0,filterDuplicates:!1,
keyRange:null,writeAccess:!1,onEnd:null,onError:h},c||{}),b="desc"==c.order.toLowerCase()?"PREV":"NEXT";c.filterDuplicates&&(b+="_NO_DUPLICATE");var d=!1,f=this.db.transaction([this.storeName],this.consts[c.writeAccess?"READ_WRITE":"READ_ONLY"]),e=f.objectStore(this.storeName);c.index&&(e=e.index(c.index));f.oncomplete=function(){if(d)if(c.onEnd)c.onEnd();else a(null);else c.onError(null)};f.onabort=c.onError;f.onerror=c.onError;b=e.openCursor(c.keyRange,this.consts[b]);b.onerror=c.onError;b.onsuccess=
function(b){if(b=b.target.result){if(a(b.value,b,f),c.autoContinue)b["continue"]()}else d=!0}},query:function(a,c){var b=[],c=c||{};c.onEnd=function(){a(b)};this.iterate(function(a){b.push(a)},c)},count:function(a,c){var c=m({index:null,keyRange:null},c||{}),b=c.onError||h,d=!1,f=null,e=this.db.transaction([this.storeName],this.consts.READ_ONLY);e.oncomplete=function(){(d?a:b)(f)};e.onabort=b;e.onerror=b;e=e.objectStore(this.storeName);c.index&&(e=e.index(c.index));e=e.count(c.keyRange);e.onsuccess=
function(a){d=!0;f=a.target.result};e.onError=b},makeKeyRange:function(a){var c="undefined"!=typeof a.lower,b="undefined"!=typeof a.upper;switch(!0){case c&&b:a=this.keyRange.bound(a.lower,a.upper,a.excludeLower,a.excludeUpper);break;case c:a=this.keyRange.lowerBound(a.lower,a.excludeLower);break;case b:a=this.keyRange.upperBound(a.upper,a.excludeUpper);break;default:throw Error('Cannot create KeyRange. Provide one or both of "lower" or "upper" value.');}return a}};var k=function(){},n={},m=function(a,
c){var b,d;for(b in c)d=c[b],d!==n[b]&&d!==a[b]&&(a[b]=d);return a};j.version=j.prototype.version;return j},this);