/*
 Swiper - Fun puzzle game involving sliding blocks, physics and stuff.
 Copyright (c) 2013 skakac.com
 http://skakac.com/

*/
var cip = 0;
var options = {
    TYPE: "Interstitial",
    REFRESH_RATE: 18,
    APP_ID: "skakac_Software_Swiper_ffOS_other"
};

 

function prekoEkranaAD(over){

	if(!over){ over = 0; cip++; }
	console.log("add "+cip);
	if (navigator.onLine){
		if(over == 1 || cip%3 == 0){
			console.log("ad");
			var myAd = Inneractive.createAd(options);
			myAd.placement("center", "center");
			myAd.addTo(document.getElementById('reklama'));
		}
	}
}

var database = new IDBStore({
  storeName: 'level_times',
  dbVersion: 1,
  keyPath: 'level',
  onStoreReady: function(){}
});

var level_data = {
	0: {
		name: "As it starts",
        start: {x:4,y:8},
        layout: "00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,01111111111111116110,01000100000001000010,01000100000000000010,01000100010000000010,01000100010000000010,01000100010000000010,01000100010000000010,01000100010000000010,01000100010000000110,01000000010010000010,01111111111111111110,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000"
    },
	1: {
        name: "Baby steps",
        start: {x:2,y:5},
        triggers : null,
		layout: "00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,11111111111111111111,10011111000000001111,10011000000000000011,10110000000000000001,10000000000000000001,10000000000001000001,10000000000001100001,10000000000000000006,10000000000000000001,10000000000000000001,10000000000001000111,10000000000001001111,10000000000001111111,10000000001111111111,11111111111111111111,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000"	
	},
	2: {
        name: "You got this one",
        start: {x:10,y:14},
        triggers : null,
		layout: "00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000016111111000,01111111110000001000,01100000000000001000,01000000000111101000,01000111111100001000,01001000000101001000,01001000000001001000,01011011011111001000,01010010001011001000,01010011000010001000,01010011111110001000,01000000100000001000,01011100100000001000,01000111100000001000,01000000000000001000,01111111111111111000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000"	
	},
	3: {
        name: "Which way?",
        start: {x:9,y:14},
        triggers : null,
		layout: "00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,11111111111111111111,10000000000000000001,60010000010000000001,11100000001000100001,11001111100000000001,10000000101000000001,10111001101000100001,10001000101000100001,11001111000111111101,11000000000000000101,11101111000111100001,10000000101000100001,10000000101100100001,10000000101000000101,10000000001111101101,10000000010000000001,10010000000000000001,11111111111111111111,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000"
		
	},
	4: {
        name: "Going big",
        start: {x:2,y:2},
        triggers : null,
		layout: "11111111111111111611,10000000000000001011,10000011100000001001,10000000000000001011,10000000000110011001,10000000000100000011,10000000000100000001,10101000000000000011,10000000000000000001,10000011100000000011,10000000000010000001,10111000000000010011,10000000001000010001,10000000001110010011,10000000000000000001,10100000000000000011,10100000001110000001,10101110000000000011,10100010000000000001,11100000000000000011,11000000001000000001,11011000001000000011,10000001001000000001,10000001011000000011,10000001111001110001,10000000000000000011,10000000110000100001,11110000110000100011,10000000000000100001,11111111111111111111"	
	},
	5: {
        name: "You are good at this",
        start: {x:17,y:1},
        triggers : null,
		layout: "11111111111111111111,10000010000000000001,10010000011010001011,10010001000010000001,10011000000010001011,10000000000000100001,10000000000000100001,10000010000000100111,10000010110000000001,11000010110001000001,11001110000001000011,11000000000000000006,11100000000110000011,11000000000000000001,10000000000011100001,10000001100010000001,10000011000000000001,10010000000000000001,10011000010001000101,10001001010101010101,10001100000000000001,10000100000000000001,10011111101111100001,11111111111111111111,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000"	
	},
	6: {
        name: "Bad walls!",
        start: {x:16,y:2},
        triggers : null,
		layout: "22211111111111111122,20001000000000000002,22000000001000000002,22000010001000000001,22000010001000000001,22000010111000000001,20010000011000000001,20000000001000000001,20010100000000000001,10000000000000001001,10000000000000001001,10000000011100001001,10000010010000000001,10000010000000000001,10000011000000000001,10010000000010000001,10010000000000000001,10000000000110000101,10011100000000000001,10000000000000000001,10000000000100000001,20000000000100000001,20000010000100000001,22000010000000111001,10000010000000111001,10011110000110111001,10000000000000000001,11000000000000000002,10000000000000000002,11111111116111111222"	
	},
	7: {
        name: "Golden Key",
        start: {x:5,y:14},
        triggers: {
			0: {
				key:{x:16,y:16},
				target:{x:3,y:16}
			}
		},
		layout: "00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00111111111111111100,00100000000000000100,00100000000000000100,00100000000000000100,00100000000000000100,00100011111000000100,00100010001000000100,00100010101000000100,00100010101000000100,00100110101000000100,00100000101000000100,00100111101000000100,00600000000000000100,00100111111000001100,00100000000000000100,00100000000000000100,00100000000000000100,00100000000000000100,00100000000000000100,00100000000000000100,00100000000000000100,00111111111111111100,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000"
	},
	8: {
        name: "Keys, keys, keys!",
        start: {x:3,y:27},
		triggers: {
			0: {
				key:{x:17,y:14},
				target:{x:14,y:13}
			},
			1: {
				key:{x:2,y:12},
				target:{x:2,y:9}
			},
		},
		layout: "00000000000000000000,01611111000000000000,01000001000000000000,01000001000000000000,01000001000000000000,01000001000000000000,01011111111111110000,01001000101000110000,01000100000000010000,01000001000000010000,01000000000001010000,01000100010001010000,01000001000101010000,01111111111111011110,01000000000000012010,01000000011100022010,01000000011100020010,01000000000000020010,01100000000000000010,01111000000000000010,01111100000010000010,01000000000010000010,01000000001110000010,01000000000000000010,01000000000000110010,01111000000000000010,01100000000000001110,01100000000000001110,01111122221111111110,00000000000000000000"	
	},
	9: {
        name: "It's physics",
        start: {x:4,y:5},
        triggers: {
			0: {
				key:{x:14,y:9},
				target:{x:8,y:5}
			}
		},
		layout: "00000000000000000000,00000000000000000000,00000000000000000000,00111111161111110000,00100001401000010000,00100001701000010000,00100100000000010000,00100100000000010000,00100111000000020000,00100000000000520000,00101111000000020000,00100000000000010000,00100000000000010000,00100000000000010000,00100000000000010000,00100000000000010000,00100000000000010000,00100000000000010000,00110000000000010000,00100000000000010000,00200000000000010000,00200001000000010000,00200001200000110000,00222222211111110000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000"	
	},
	10: {
        name: "Mass times acceleration",
        start: {x:4,y:9},
        triggers: {
			0: {
				key:{x:7,y:14},
				target:{x:14,y:18}
			}
		},
		layout: "00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00222111111111161100,00222000000000000100,00222000000000000100,00220000000000000100,00100000000100000100,00111111000100000100,00100000000000000100,00100000000000000100,00100000000000000100,00100000000000000100,00100000000000000100,00100015000001400100,00100011111222700200,00100000000000000200,00111111111111122200,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000"	
	},
	11: {
        name: "Well you know",
        start: {x:15,y:6},
        triggers: {
			0: {
				key:{x:3,y:9},
				target:{x:11,y:10}
			},
			1: {
				key:{x:6,y:11},
				target:{0:{x:11,y:12},1:{x:11,y:14}}
			}
		},
		layout: "00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00111111111111111110,00100000000000001110,00100100000000000010,00100000000000000010,00100000000000000010,00150000000410000010,00110000000700000010,00100050000000001010,00111111100700000010,00600000101400000010,00110000111711111110,00100000000000000010,00100000000000000010,00100000000000000010,00100000000000000010,00100000000000000010,00100000000000000010,00100000000000000010,00111111122022111110,00000000002220000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000"	
	},
	12: {
        name: "True path",
        start: {x:4,y:3},
        triggers: {
			0: {
				key:{x:4,y:8},
				target:{x:1,y:10}
			},
			1: {
				key:{x:6,y:1},
				target:{x:1,y:2}
			},
			2: {
				key:{x:13,y:10},
				target:{0:{x:13,y:9},1:{x:14,y:7}}
			}
		},
		layout: "11111111111111111111,14000150000100000001,17000100000100000001,10000100000000000001,10000000000000000001,10000000000000000001,10000000000001410001,10000000000001710001,60005000010004000001,17000000000017000011,10000000000005000001,10000000000001100001,10000000000001100001,10000000000000000001,10000000000000000001,10000000000000000001,10000000000000000001,10000000000000000001,10000000000000000001,10000000000000000001,10000000000000000001,10000000000000000001,10000000000000000001,10000000000000000001,10000000000000000001,11100000000000000001,10101000001111000001,20002200000000002002,20022200000000022202,22222222222222222222"	
	},
	13: {
        name: "Just do it",
        start: {x:2,y:20},
        triggers: {
			0: {
				key:{x:1,y:22},
				target:{x:5,y:22}
			},
			1: {
				key:{x:6,y:20},
				target:{x:4,y:8}
			},
			2: {
				key:{x:8,y:20},
				target:{0:{x:6,y:19},1:{x:7,y:19}}
			},
			3: {
				key:{x:10,y:20},
				target:{x:3,y:6}
			},
			4: {
				key:{x:12,y:20},
				target:{x:4,y:6}
			},
			5: {
				key:{x:14,y:20},
				target:{x:4,y:4}
			},
			6: {
				key:{x:16,y:20},
				target:{x:18,y:14}
			}
		},
		layout: "00000000000000000000,02220000000000000000,22222611111111111111,12014010000000000001,10017000000000000001,10044000000000000001,10077000000000000001,10100000000000000001,10117111111100000001,10010100000000000001,10011100000000000001,22200000000000000001,22200000000000000001,22000000000000000001,11111111111111111171,10000000000000000001,10000000000000000001,10001111111111111111,10000044001000000001,10000077000000000001,10300050505050505001,11000011000000000011,15000700000000000011,21110000000000100001,22210000011111211111,22211111111112222222,00000000000000000000,00000000000000000000,00000000000000000000,00000000000000000000"	
	},
	14: {
        name: "Distraction",
        start: {x:2,y:2},
        triggers: {
			0: {
				key:{x:5,y:2},
				target:{x:2,y:12}
			},
			1: {
				key:{x:2,y:5},
				target:{x:7,y:2}
			}
		},
		layout: "11111111111111111111,11000214010010000001,10000507011110000001,10000000001100001101,10000000000000000101,12500000000011100101,10000100000010000101,10000110000010001101,10000000000000000001,10000000000000000001,10000010000000000001,10400111111110000001,10700100000000000001,10000000000000222201,10000011111000210101,11010000000000200001,10000000000000210001,11010000011000200001,10000000001110210001,11010000000010000001,10000000000000000001,11011111100000000001,10010000100000100001,11010000000001110011,11000000000001110001,11011000110000000001,11000000011000000001,11000000001000000001,10000000000000000006,11111111111111111111"	
	},
	15: {
        name: "The Gatekeeper",
        start: {x:10,y:13},
        triggers: {
			0: {
				key:{x:11,y:20},
				target:{x:7,y:27}
			},
			1: {
				key:{x:3,y:3},
				target:{x:7,y:28}
			},
			2: {
				key:{x:18,y:11},
				target:{x:3,y:10}
			}
		},
		layout: "11111111111111111111,10000000000000000001,10100001111100000001,10150000000000000011,10110000000000000001,10110010000110110001,10110011000110110001,10110001000000000001,10040001000121212001,10040000000000000001,10170000000000000001,10100001000000001151,10100011000010000101,10100000003000000101,10100100000000000101,10000100001000000001,10200100000000000001,10000000000000100001,10200000000000110001,10000000000000010001,10200000000500000001,10000000111100001001,10210000000000222001,10000000000000200001,10200000000100200001,10000000100100200001,10201000000100000001,10000007000000001111,10000007000000000001,11111116111111111111"	
	},	
	16: {
        name: "Offset",
        start: {x:6,y:25},
        triggers: {
			0: {
				key:{x:10,y:14},
				target:{x:14,y:14}
			},
			1: {
				key:{x:14,y:8},
				target:{x:14,y:5}
			},
			2: {
				key:{x:3,y:10},
				target:{0:{x:7,y:4},1:{x:7,y:11},2:{x:7,y:21}}
			}
		},
		layout: "00000000000002200000,00000000000022220000,00111116111122221110,00111114111112210010,00100007000000400010,00100000000000700010,00100000000000000010,00100000000000000010,00100000000000500010,00100000000000000010,00150000000000010010,00111117111110011110,00110000000000000010,00110000000000400220,00100000000050702222,00100000001111112222,00100000000000000220,00100000000000000010,00110000000000000010,00010000000000011110,00011100000000000010,00022117111111110010,02222210000000000010,22222220000000000110,22220000000000010100,22220030000000000100,22200005000000000100,02200000000000001100,00222200000000001100,00011111111111111000"	
	},
	17: {
        name: "Sort of",
        start: {x:11,y:18},
        triggers: {
			0: {
				key:{x:1,y:16},
				target:{x:6,y:10}
			}
		},
		layout: "11111111111111122222,10010011111000002222,10011010001000100222,10000000100000100222,11000000100010000022,10000000111111100022,10000001111111110011,10000001111100010001,11000011111000110001,11100141110000110001,11100171110000000001,10000100000000000001,10000201111000010002,10000201000000010002,10000201001010010002,60000001011110010002,15000001000010000001,10000011001011000011,10000001001311100001,10000001011111111001,10000000011111110001,10001000010000000001,10001000010000000011,11001110010000000111,11000000011100000111,11000000000000000001,22000000000000000001,22200000000000000111,22222221100000000112,22222221111111111122"	
	},
	18: {
        name: "What",
        start: {x:18,y:28},
        triggers: {
			0: {
				key:{x:1,y:15},
				target:{x:6,y:14}
			},
			1: {
				key:{x:18,y:10},
				target:{x:18,y:2}
			},
			2: {
				key:{x:12,y:11},
				target:{0:{x:6,y:4},1:{x:5,y:4}}
			},
			3: {
				key:{x:7,y:1},
				target:{x:5,y:28}
			},
			4: {
				key:{x:5,y:25},
				target:{x:3,y:28}
			}
		},
		layout: "11111116111112222111,10000005000112222041,10011410100000222071,10000440100000222001,10000770100000220001,10000000000000000001,10000000000000000001,10000011110000000001,10000222200000000051,10000222200000000001,10022222200000000001,22222220000050000001,22222220000000000001,10000040000000000001,10000070000000000001,15000000000000000001,10000000000000000022,10000000000000000022,10000000000000222222,10000000000002222222,10000000000002222222,10222000000000022222,22222200000000000001,22222200000000000011,10000100000000000001,10000500000000000001,10000000000000000001,10000000000000000001,10000700000000100001,11111111111111111111"	
	}

};

Game = {
  
  grid_sizes: {
    width:  20,
    height: 30,
    tile: {
      width:  16,
      height: 16
    }
  },
 level:0,
  width: function() {
    return this.grid_sizes.width * this.grid_sizes.tile.width;
  },
  height: function() {
    return this.grid_sizes.height * this.grid_sizes.tile.height;
  },
  start: function() {
    Crafty.init(Game.width(), Game.height());
    Crafty.background('assets/images/background.png');
  	Crafty.scene("loading");
  	prekoEkranaAD(1);
  }

 
}

/*
//
// Game Components
//
 */
Crafty.c("Wall", {
	init: function() {
    this.requires('2D, Canvas, Solid, spr_wall, Collision, solid_wall')
    .attr({w:Game.grid_sizes.tile.width, h:Game.grid_sizes.tile.height}).collision();
  }
});

Crafty.c("BadWall", {
	init: function() {
    this.requires('2D, Canvas, Solid, spr_badwall, Collision, solid_wall')
    .attr({w:Game.grid_sizes.tile.width, h:Game.grid_sizes.tile.height});
  }
});

Crafty.c("Key", {
	init: function() {
    this.requires('2D, Canvas, Solid, spr_key, Collision')
    .attr({w:Game.grid_sizes.tile.width, h:Game.grid_sizes.tile.height});
  }
});

Crafty.c("Keylock", {
	init: function() {
    this.requires('2D, Canvas, Solid, spr_keylock, Collision, solid_wall')
    .attr({w:Game.grid_sizes.tile.width, h:Game.grid_sizes.tile.height});
  }
});

Crafty.c("Box", {
	can_move : true,
	just_hit : false,
	wall_hit : false,
	init: function() {
    this.requires('2D, Canvas, Solid, spr_box, Gravity, Collision, solid_wall')
    .attr({w:Game.grid_sizes.tile.width, h:Game.grid_sizes.tile.height}).gravity("solid_wall");
    this.bind("EnterFrame", function(){
    	if(!this.can_move && this.just_hit){
	    		this.just_hit = false;
	    	}
    });

  	},
  	check_wall: function(speed){
  		var wall = false;
  		this.onHit("solid_wall", function(target){
	    if(this.can_move){
	    	wall = true;
	    	this.can_move = false;	    		
	    	this.just_hit = true;
	    	this.wall_hit = true;
	    	if(target[0].normal.x == -1)
		       	this.attr({x: this.x - speed});
		    if(target[0].normal.x == 1)
		       	this.attr({x: this.x + speed});
	    }
		});
  		if(!this.wall_hit) this.can_move = true;
  		if(!wall){ this.wall_hit = false }	
  		
  	}
});

Crafty.c("Finish", {
	init: function() {
    this.requires('2D, Canvas, spr_clear,Collision');
  }
});

Crafty.c('Slide', {
    moveb :{up: false, down: false, left:false, right:false},

    ResetMove: function(){
    	var move = this.moveb;
	    move.up = move.down = move.left = move.right = false;
    },

    Keys: function(){
    	var move = this.moveb;
    	var swipe_sensitivity = 0.05;
		var target = document.getElementById('cr-stage');
		Hammer(target, { swipe_velocity: swipe_sensitivity });
		Hammer(target).on("swipe", function(event) {
			if(!move.up && !move.down && !move.left && !move.right)
				switch(event.gesture.direction){
					case "up": move.up = true; break;
					case "down": move.down = true; break;
					case "left": move.left = true; break;
					case "right": move.right = true; break;
				}
		});				    				    
    },

    Stop: function(speed){
    	var move = this.moveb;
    	if (move.up)
			this.attr({y: this.y + speed}); 
	    else if (move.down)
	       	this.attr({y: this.y - speed});
	    else if (move.left)
		    this.attr({x: this.x + speed});
		else if (move.right)
		   	this.attr({x: this.x - speed});        
		move.up = move.down = move.left = move.right = false;		    				    
    },

    Slide: function(){
    	var speed = 4;
    	var move = this.moveb;
    	if(move.up || move.down || move.left || move.right)
    		return;
    	this.bind('EnterFrame', function() {
    		if(move.up)
    			return this.attr({y: this.y - speed});
    		else if(move.down)
    			return this.attr({y: this.y + speed});    		
    		else if(move.left)
    			return this.attr({x: this.x - speed});
    		else if(move.right)
    			return this.attr({x: this.x + speed});
	    });
	    this.collision();
		this.onHit("Wall", function() {
	        this.Stop(speed);
	      });
		this.onHit("Keylock", function() {
	        this.Stop(speed);
	      });
		this.onHit("Box", function(target) {
			var box = target[0];
	        box.obj.check_wall(speed);	  
		    if(box.obj.just_hit){  	
		        if(move.left)
		        	this.attr({x: this.x + speed});
		        else if(move.right)
    				this.attr({x: this.x - speed});
    			else if(move.down)
    				this.attr({y: this.y - speed});
    			else if(move.up)
    				this.attr({y: this.y + speed});
	        }
	        if(!box.obj.can_move){ 
		        this.Stop(speed);
		        
		    }
		    if(box.obj.can_move){		    
		    	if(box.normal.x == -1)
	        		box.obj.attr({x: box.obj.x + speed});
	        	if(box.normal.x == 1)
	        		box.obj.attr({x: box.obj.x - speed}); 
		    	
		    }
		    if(box.normal.y == -1 && box.obj.can_move){ this.attr({y: this.y - speed}); move.down = false; box.obj.can_move = true;}
		    if(box.normal.y == 1 && box.obj.can_move){ this.attr({y: this.y + speed}); move.up = false; box.obj.can_move = true;}

	    });
	    return this.Keys();
    }

});

Crafty.c("Player_box", {
	init: function() {
    this.requires('2D, Canvas, Keyboard, Controls, spr_player, Collision, Slide, solid_wall');
  }
 
});




/*
//
// Game Scenes
//
 */

//Loading scene
Crafty.scene("loading", function() {
	var load_text;
	load_text = Crafty.e("2D, DOM, Text");
	load_text.attr({
		w: Game.width(),
		h: 20,
		x: 0,
	    y: Game.height() / 2 - 20
	});
	load_text.css({
		"text-align": "center",
		"color": "#FFF"
	});
	load_text.text('Loading...');
	var openDB
	Crafty.load(['assets/music/beat.mp3', 'assets/music/beat.ogg', 'assets/music/clear.mp3', 'assets/music/clear.ogg', 'assets/music/beep.mp3', 'assets/music/beep.ogg', 'assets/music/bad_beep.mp3', 'assets/music/bad_beep.ogg'], function(){});
	// Load our sprite map image
	Crafty.load(['assets/images/tiles16v2.png', 'assets/images/lvlbg.png', 'assets/images/background.png', 'assets/images/logo.png', 'assets/images/playb.png', 'assets/images/creditb.png', 'assets/images/levelsb.png'], function(){	
		Crafty.audio.add({
			beat: ["assets/music/beat.mp3",
			"assets/music/beat.ogg"],
			clear: ["assets/music/clear.mp3",
			"assets/music/clear.ogg"],
			beep: ["assets/music/beep.mp3",
			"assets/music/beep.ogg"],
			bbeep: ["assets/music/bad_beep.mp3",
			"assets/music/bad_beep.ogg"],
			});

		Crafty.sprite(16, 'assets/images/tiles16v2.png', {
			spr_wall:  [0, 0],
			spr_badwall: [1, 0],
			spr_player: [2, 0],
			spr_box: [3, 0],
			spr_key: [4, 0],
			spr_keylock: [6, 0],
			spr_clear: [5, 0],
			spr_back: [0, 1, 3, 3],
			spr_restart: [3, 1, 3, 3]
		});
		makelevels();	 
		Crafty.scene('menu');


	});


});
//END Loading scene

//Credits scene
Crafty.scene("credit", function() {
	var back, text;
	back = Crafty.e("2D, Canvas, spr_back, Mouse").attr({x:12, y:420, w:48,h:48});
	var div = document.getElementById('info');
	div.innerHTML = "<b>Swiper</b> is fun puzzle game for Firefox OS<br />made in 7 days for Telenor firefox<br /> challenge.<br /><br />This game features simple graphics, <br />physics objects, time challenges <br />and lots of blocks. Have fun.<br/><br />Game by: Dusan Stojadinovic<br />Developed by: skakac.com";
	div.style.display = "block";

	
	back.bind('Click', function() {
		div.removeAttribute("style");
		div.innerHTML = "";
		div.style.display = "none";
		Crafty.scene("menu");
	});

 });
//END Credits scene

//Win scene
Crafty.scene("win", function() {
	var back, text;
	back = Crafty.e("2D, Canvas, spr_back, Mouse").attr({x:12, y:420, w:48,h:48});
	var div = document.getElementById('info');
	div.innerHTML = "<b>Congratulations you finished all levels</b><br />that is all for now, there<br /> will be new levels and features in<br /> new version of this game.<br /> Thank you for playing.";
	div.style["-webkit-box-shadow"] = "none";
	div.style["box-shadow"] = "none";
	div.style.background = "transparent";
	div.style["text-align"] = "left";
	div.style["line-height"] = "20px";
	div.style.display = "block";

	
	back.bind('Click', function() {
		div.removeAttribute("style");
		div.innerHTML = "";
		div.style.display = "none";
		Crafty.scene("menu");
	});

 });
//END Win scene

//Levels scene
Crafty.scene("levels_menu", function() {
	var back, text, play;
	Crafty.background("url('assets/images/background.png')");	
	play = Crafty.e("2D, Canvas, Image, Mouse").image("assets/images/playb.png").attr({x:77,y:300});
	back = Crafty.e("2D, Canvas, spr_back, Mouse").attr({x:12, y:420, w:48,h:48});	

	var div = document.getElementById('stage_report');
	div.innerHTML = "";
	div.innerHTML = "<div class='level'>Level: <select id='level_s'></select></div>";
	var select = document.getElementById('level_s');
	for(var i=0; i<Object.keys(level_data).length; i++){
		select.options[select.options.length] = new Option(i, i);
	}
	div.style.display = "block";

	
	play.bind('Click', function() {
		div.innerHTML = "";
		div.style.display = "none";
		//Crafty.audio.remove("menu_music");
		Crafty.background("url('assets/images/lvlbg.png')");
    	Crafty.scene("level"+select.value);
    	Game.level = select.value;	    
		Crafty.audio.play("beat",-1, 0.1);
	});

	back.bind('Click', function() {
		div.innerHTML = "";
		play.destroy();
		play.unbind("Click");
		div.style.display = "none";
		Crafty.scene("menu");
	});

 });
//END Levels scene
//Menu scene
Crafty.scene("menu", function() {
	Crafty.audio.stop("beat");
	document.getElementById('stage_report').style.display = "none";
    Crafty.background("url('assets/images/background.png')");
	var logo, playB, creditB, levelsB;
	logo = Crafty.e("2D, Canvas, Image").image("assets/images/logo.png").attr({x:57,y:68});

	playB = Crafty.e("2D, Canvas, Image, Mouse").image("assets/images/playb.png").attr({x:77,y:230});	
	levelsB = Crafty.e("2D, Canvas, Image, Mouse").image("assets/images/levelsb.png").attr({x:98,y:290});
	creditB = Crafty.e("2D, Canvas, Image, Mouse").image("assets/images/creditb.png").attr({x:104,y:340});
	Crafty.e("2D, DOM, Text").attr({x:145,y:460, w:200}).text("&copy; skakac.com | v1.4").textColor('#000000').textFont("size", "10pt");
	
	playB.bind('Click', function() {
		Crafty.background("url('assets/images/lvlbg.png')");
		Crafty.audio.play("beat",-1, 0.1);
    	Crafty.scene("level"+Game.level);
	});
	creditB.bind('Click', function() {
		Crafty.background("url('assets/images/lvlbg.png')");
    	Crafty.scene("credit");	    

	});
	levelsB.bind('Click', function() {
    	Crafty.scene("levels_menu");	
	});

 });
//END Menu scene

makelevels = function(){
	makelevel = function(lvl, level, triggers){
		Crafty.scene("level"+lvl, function(){
			showStageName(lvl, level.name);			
			var player, restart, back, time;
			time = new Date().getTime();

			player = Crafty.e("Player_box").attr({x:level.start.x*16, y:level.start.y*16, w:16,h:16});
			player.ResetMove();
			player.Slide();			

			Crafty.e("Reset");
			player.onHit("BadWall", function(){
				Crafty.audio.play("bbeep", 1, 0.5);
				resetlevel(player);
			});

			var levels_layout = level.layout.split(",");
			for(var l=0; l<Game.grid_sizes.height; l++){
				if(!levels_layout[l]) return;
				levels_layout[l] = levels_layout[l].split('');
				for(var e=0; e<=Game.grid_sizes.width;e++){
					var tile;
					switch(levels_layout[l][e]){
						case "1": tile = Crafty.e("Wall"); break;
						case "2": tile = Crafty.e("BadWall"); break;
						case "4": tile = Crafty.e("Box"); break;
						case "6": tile = Crafty.e("Finish"); break;
						default: tile = false; break;
					}
					if(tile)
					tile.attr({
						x:e*Game.grid_sizes.tile.height,
						y:l*Game.grid_sizes.tile.width				
					});		
				}
			}
			if(triggers){
				for(var t=0; t<triggers; t++){
					var key, target;
					key = Crafty.e("Key, triger"+t).attr({
						x:level.triggers[t].key.x*Game.grid_sizes.tile.height,
						y:level.triggers[t].key.y*Game.grid_sizes.tile.width				
					}).triger_id = t;
					if(typeof level.triggers[t].target.x == "undefined"){
						for(var mt = 0; mt<Object.keys(level.triggers[t].target).length; mt++){
							target =Crafty.e("Keylock, triger"+t).attr({
								x:level.triggers[t].target[mt].x*Game.grid_sizes.tile.height,
								y:level.triggers[t].target[mt].y*Game.grid_sizes.tile.width				
							}).triger_id = t;
						}
					}
					else{
						target =Crafty.e("Keylock, triger"+t).attr({
								x:level.triggers[t].target.x*Game.grid_sizes.tile.height,
								y:level.triggers[t].target.y*Game.grid_sizes.tile.width				
							}).triger_id = t;
					}
				}
				player.onHit("Key", function(target) {
					Crafty.audio.play("beep", 1);
			    	Crafty("triger"+target[0].obj.triger_id).destroy();
		        });
			}
			player.onHit("Finish", function() {
				var end_time = new Date().getTime() - time;
	        	player.Stop();
	        	stageReport(lvl, level.name, end_time);
	      	});
			back = Crafty.e("2D, Canvas, spr_back, Mouse").attr({x:12, y:420, w:48,h:48});
			restart = Crafty.e("2D, Canvas, spr_restart, Mouse").attr({x:272, y:420, w:48,h:48});
			back.bind('Click', function() {
				Crafty.scene("menu");
			});
			restart.bind('Click', function() {
				resetlevel(player);
			});

		});
	};

	for(var i=0; i<Object.keys(level_data).length; i++){
		var triggers = 0;
		var level = level_data[i];
		if(level_data[i].triggers != null)
			triggers = Object.keys(level_data[i].triggers).length;
		makelevel(i, level, triggers);
	}

};
function resetlevel(player){
	player.ResetMove();
	Crafty.scene("level"+Game.level);
}
function showStageName(lvl, name){
	var div = document.getElementById('stage_name');
	div.innerHTML = "Level "+lvl+": "+name;
	div.style.display = "block";
	setTimeout(function(){div.style.display = "none";},1500);
}
function stageReport(level, name, time){
	prekoEkranaAD();
	Crafty.audio.play("clear", 1);
	var div, report = true;
	time = (time / 1000).toFixed(2);
	showBest(level, time);
	var div = document.getElementById('stage_report');
	div.innerHTML = "<div class='level'>Level "+level+": "+name+"</div>";
	div.innerHTML += "<div class='times'><div id='time'>Time: "+time+" sec</div><div id='best'></div></div>";
	div.innerHTML += "<div class='control'>Next</div>";
	div.style.display = "block";
	Hammer(div).on("tap", function() {
		if(report){
			document.getElementById('stage_report').style.display = "none";
			report = false;
			if(Game.level < Object.keys(level_data).length-1){
				Game.level++;
				Crafty.scene("level"+Game.level);
			}
			else{
				Game.level = 0;
				Crafty.scene("win");
			}
		}
	});	
}

function showBest(level, time){
	database.get(level, function(data){
		if(typeof data == "undefined"){
			document.getElementById('best').innerHTML = "Best: "+time+" sec";
			database.put({level:level, time:time}, function(){}, function(){});
		}
		else{
			var best = data.time;
			if(best > time){
				database.put({level:level, time:time}, function(){}, function(){});
			}
			document.getElementById('best').innerHTML = "Best: "+best+" sec";
		}
	}, function(e){console.log(e);return false;});
}

//END  scene

