// autogenerated at: 2015-01-12 16:24
pc.legacy = {shaderChunks:{}};
pc.legacy.shaderChunks.particlePS = "// FRAGMENT SHADER INPUTS: VARYINGS\nvarying vec2 vUv0;\nvarying float vAge;\nvarying vec4 vColor;\n\n// FRAGMENT SHADER INPUTS: UNIFORMS\nuniform sampler2D texture_colorMap;\nuniform sampler2D texture_opacityMap;\nuniform sampler2D texture_rampMap;\n\nvoid main(void)\n{\n    vec4 colorMult = texture2D(texture_rampMap, vec2(vAge, 0.5)) * vColor;\n    vec3 rgb = texture2D(texture_colorMap, vUv0).rgb;\n    float a = texture2D(texture_opacityMap, vUv0).r;\n    gl_FragColor = vec4(rgb, a) * colorMult;\n}\n"
pc.legacy.shaderChunks.particleVS = "\n// VERTEX SHADER BODY\nvoid main(void)\n{\n    vec2 uv = particle_uvLifeTimeFrameStart.xy;\n    float lifeTime = particle_uvLifeTimeFrameStart.z;\n    float frameStart = particle_uvLifeTimeFrameStart.w;\n    vec3 position = particle_positionStartTime.xyz;\n    float startTime = particle_positionStartTime.w;\n\n    vec3 velocity = (matrix_model * vec4(particle_velocityStartSize.xyz, 0.0)).xyz + particle_worldVelocity;\n    float startSize = particle_velocityStartSize.w;\n\n    vec3 acceleration = (matrix_model * vec4(particle_accelerationEndSize.xyz, 0.0)).xyz + particle_worldAcceleration;\n    float endSize = particle_accelerationEndSize.w;\n\n    float spinStart = particle_spinStartSpinSpeed.x;\n    float spinSpeed = particle_spinStartSpinSpeed.y;\n\n    float localTime = mod((particle_time - particle_timeOffset - startTime), particle_timeRange);\n    float percentLife = localTime / lifeTime;\n\n    float frame = mod(floor(localTime / particle_frameDuration + frameStart), particle_numFrames);\n    float uOffset = frame / particle_numFrames;\n    float u = uOffset + (uv.x + 0.5) * (1.0 / particle_numFrames);\n\n    vUv0 = vec2(u, uv.y + 0.5);\n    vColor = particle_colorMult;\n\n"
pc.legacy.shaderChunks.particleEndVS = "\n    float size = mix(startSize, endSize, percentLife);\n    size = (percentLife < 0.0 || percentLife > 1.0) ? 0.0 : size;\n    float s = sin(spinStart + spinSpeed * localTime);\n    float c = cos(spinStart + spinSpeed * localTime);\n\n    vec4 rotatedPoint = vec4((uv.x * c + uv.y * s) * size, 0.0, (uv.x * s - uv.y * c) * size, 1.0);\n    vec3 center = velocity * localTime + acceleration * localTime * localTime + position;\n\n    vec4 q2 = particle_orientation + particle_orientation;\n    vec4 qx = particle_orientation.xxxw * q2.xyzx;\n    vec4 qy = particle_orientation.xyyw * q2.xyzy;\n    vec4 qz = particle_orientation.xxzw * q2.xxzz;\n\n    mat4 localMatrix =\n         mat4((1.0 - qy.y) - qz.z, qx.y + qz.w, qx.z - qy.w, 0,\n              qx.y - qz.w, (1.0 - qx.x) - qz.z, qy.z + qx.w, 0,\n              qx.z + qy.w, qy.z - qx.w, (1.0 - qx.x) - qy.y, 0,\n              center.x, center.y, center.z, 1);\n    rotatedPoint = localMatrix * rotatedPoint;\n    vAge = percentLife;\n    gl_Position = matrix_viewProjection * vec4(rotatedPoint.xyz + matrix_model[3].xyz, 1.0);\n}\n"
pc.legacy.shaderChunks.particleEndBBRDVS = "\n    vec3 basisX = matrix_viewInverse[0].xyz;\n    vec3 basisZ = matrix_viewInverse[1].xyz;\n    float size = mix(startSize, endSize, percentLife);\n    size = (percentLife < 0.0 || percentLife > 1.0) ? 0.0 : size;\n    float s = sin(spinStart + spinSpeed * localTime);\n    float c = cos(spinStart + spinSpeed * localTime);\n    vec2 rotatedPoint = vec2(uv.x * c + uv.y * s,\n                             -uv.x * s + uv.y * c);\n    vec3 localPosition = vec3(basisX * rotatedPoint.x +\n                              basisZ * rotatedPoint.y) * size +\n                              velocity * localTime +\n                              acceleration * localTime * localTime +\n                              position;\n    vAge = percentLife;\n    gl_Position = matrix_viewProjection * vec4(localPosition + matrix_model[3].xyz, 1.0);\n}\n"
pc.legacy.shaderChunks.particleStartVS = "\n// VERTEX SHADER INPUTS: ATTRIBUTES\nattribute vec4 particle_uvLifeTimeFrameStart; // uv, lifeTime, frameStart\nattribute vec4 particle_positionStartTime;    // position.xyz, startTime\nattribute vec4 particle_velocityStartSize;    // velocity.xyz, startSize\nattribute vec4 particle_accelerationEndSize;  // acceleration.xyz, endSize\nattribute vec4 particle_spinStartSpinSpeed;   // spinStart.x, spinSpeed.y\nattribute vec4 particle_colorMult;            // multiplies color and ramp textures\n\n// VERTEX SHADER INPUTS: UNIFORMS\nuniform mat4 matrix_viewProjection;\nuniform mat4 matrix_model;\nuniform mat4 matrix_viewInverse;\nuniform vec3 particle_worldVelocity;\nuniform vec3 particle_worldAcceleration;\nuniform float particle_timeRange;\nuniform float particle_time;\nuniform float particle_timeOffset;\nuniform float particle_frameDuration;\nuniform float particle_numFrames;\n\n// VERTEX SHADER OUTPUTS\nvarying vec2 vUv0;\nvarying float vAge;\nvarying vec4 vColor;\n"
pc.legacy.shaderChunks.particleStartRotationVS = "// VERTEX SHADER INPUTS: ROTATION ATTRIBUTE (not used on billboards)\nWattribute vec4 particle_orientation;\n"
