﻿	var score = 0;
	var highScore = 0;
	var currentPlace = 0;
	var patternLength = 3;
	var newFlag = true;
	var currentPattern = new Array();

	var colourArray = new Array(
		"",
	    "rgb(164,196,0)",	//Lime
	    "rgb(27,161,226)",	//Cyan
	    "rgb(244,114,208)", //Pink
	    "rgb(250,104,0)",	//Orange
	    "rgb(109,135,100)",	//Olive
		"rgb(96,169,23)",	//Green
		"rgb(0,80,239)",	//Cobalt
		"rgb(216,0,115)",	//Magenta
		"rgb(240,163,10)",	//Amber
		"rgb(100,118,135)",	//Steel
		"rgb(0,138,0)",		//Emerald
		"rgb(106,0,255)",	//Indigo
		"rgb(162,0,37)",	//Crimson
		"rgb(227,200,0)",	//Yellow
		"rgb(118,96,138)",	//Mauve
		"rgb(0,171,169)",	//Teal
	    "rgb(170,0,255)",	//Violet
	    "rgb(229,20,0)",	//Red
	    "rgb(130,90,44)",	//Brown
		"rgb(135,121,78)"	//Taupe
	);

	function displayGameover() {
	    document.getElementById("gameover").style.visibility = "visible";
	    
	    document.getElementById("scoreText").innerHTML = "You scored " + score + " points.";

		if (score > highScore){
			highScore = score;
			if(typeof(Storage)!=="undefined"){	
				localStorage.highScore = highScore;
			}
			document.getElementById("scoreText").innerHTML += " You set a new record! Congratulations!";
		}	
		else{
			document.getElementById("scoreText").innerHTML += " Your record is " + highScore + " points";
		}

	    score = 0;	
		if(typeof(Storage)!=="undefined"){	
			localStorage.score = score;
		}					
	    				
	    bindEvent(document.getElementById("newGame3"), "click", function () {
	        document.getElementById("gameover").style.visibility = "hidden";
	        if (typeof (Storage) !== "undefined") {
	            if (localStorage.highScore) {
	                highScore = localStorage.highScore;
	            }
	            else {
	                localStorage.highScore = highScore;
	            }
	        }
	        startNewGame();
	    });
	}
	

	function initializeGame(){

		try{	
			if(typeof(Storage)!=="undefined")
			{	
				if (localStorage.score){
					score = localStorage.score;					
				}
				else{
					localStorage.score = score;			
				}

				if (localStorage.highScore){
					highScore = localStorage.highScore;				
				}
				else{
					localStorage.highScore = highScore;			
				}				

				if (localStorage.patternLength){
					patternLength = localStorage.patternLength;											
				}
				else{
					localStorage.patternLength = patternLength;			
				}
			}
						
			generatePattern();	
			
			showPattern(0);				
		}
		catch(err)
		{
			alert("initializeGame() error: " + err);
		}
	}
	
	function startNewGame(){
	    try {
	        if (newFlag) {
	            newFlag = false;
	            if (score > highScore) {
	                highScore = score;
	                if (typeof (Storage) !== "undefined") {
	                    localStorage.highScore = highScore;
	                }
	            }
	            score = 0;

	            if (typeof (Storage) !== "undefined") {
	                localStorage.score = score;
	            }

	            patternLength = 3;

	            if (typeof (Storage) !== "undefined") {
	                localStorage.patternLength = patternLength;
	            }

	            currentPlace = 0;

	            for (var i = 1; i < 21; i++) {
	                document.getElementById("s" + i + "color").style.background = "";
	                document.getElementById("s" + i).style.background = "";
	            }

	            generatePattern();

	            showPattern(0);
	        }
		}
		catch(err)
		{
			alert("startNewGame() error: " + err);
		}			
	}

	function generatePattern(){
		try{
			var min = 1;
			
			var max = 20;
			
			currentPattern = new Array();
			
			for (var i=0;i<patternLength;i++){
				var random = Math.floor(Math.random() * (max - min + 1)) + min;			
				currentPattern[i] = random;
			}

		}
		catch(err)
		{
			alert("generatePattern() error: " + err);
		}
	}
	
	function showPattern(position){
		try{
			var pattern = 0;
			
			pattern = currentPattern[position];
			
			newFlag = false;

			document.getElementById("s"+pattern+"color").style.background = colourArray[pattern];
			
			setTimeout(function(){
				document.getElementById("s"+pattern+"color").style.background = "";
			},500);	
						
			if (position < (patternLength-1)){
				position = parseInt(position) + 1;
				setTimeout(function(){showPattern(position)},700);	
			}
			else{
				setTimeout(function(){enableTouch();},700);
				newFlag = true;
			}
		}
		catch(err)
		{
			alert("showPattern(" + position + ") error: " + err);
		}		
	}

	function bindEvent(el,eventName, eventHandler){
		try{
			if (el.addEventListener){
				el.addEventListener(eventName, eventHandler, false);
			}
			else if(el.attachEvent){
				el.attachEvent('on'+eventName, eventHandler);		
			}
		}
		catch(err)
		{
			alert("bindEvent() error: " + err);
		}		
	}
	
	function unbindEvent(el,eventName, eventHandler){
		try{
			if (el.removeEventListener){
				el.removeEventListener(eventName, eventHandler, false);
			}
			else if(el.detachEvent){
				el.detachEvent('on'+eventName, eventHandler);		
			}
		}
		catch(err)
		{
			alert("unbindEvent(" + el + " , " + eventName + " , " + eventHandler + ") error: " + err);
		}		
	}
		
	function enableTouch(){
		try{
			for (var i=1;i<21;i++){
				bindEvent(document.getElementById("s"+i), "click", clicked);
			}
		}
		catch(err)
		{
			alert("enableTouch() error: " + err);
		}				
	}

	function diableTouch(){
		try{
			for (var i=1;i<21;i++){
				unbindEvent(document.getElementById("s"+i), "click", clicked);
			}
		}
		catch(err)
		{
			alert("disableTouch() error: " + err);
		}
	}

	function clicked(ev){
		try{

			diableTouch();

			if (ev.target){
				var target = ev.target.id;
			}else if (ev.srcElement){
				var target = ev.srcElement.id;
			}

			var regExp = new RegExp("^[A-Za-z]*");
			tapped = target.replace(regExp,'');
			var regExp = new RegExp("[A-Za-z]*$");
			tapped = tapped.replace(regExp,'');

			document.getElementById("s" + tapped + "color").style.background = colourArray[tapped];
			setTimeout(function(){document.getElementById("s" + tapped + "color").style.background = "";},200);

			if (tapped == currentPattern[currentPlace]){
				currentPlace = parseInt(currentPlace) + 1;	
				if (currentPlace == patternLength){
					setTimeout(function(){document.getElementById(target).style.background = "";},200);
					score = parseInt(score) + 1;
					if(typeof(Storage)!=="undefined"){	
						localStorage.score = score;
					}
    				patternLength = parseInt(patternLength) + 1;					
					if(typeof(Storage)!=="undefined"){	
						localStorage.patternLength = patternLength;
					}					
					currentPlace = 0;
					generatePattern();											
					setTimeout(function(){showPattern(0)},1000);
				}
				else{
					enableTouch();
				}			
			}
			else{
				diableTouch();	
				setTimeout(function(){showError();},250);				
				currentPlace = 0;
				if(typeof(Storage)!=="undefined"){	
					localStorage.patternLength = 3;
				}					
			}		
		}
		catch(err){
			alert("clicked(" + ev + ") error: " + err);
		}
	}
	
	function showError(){
		try{
			for (var i=1;i<21;i++){
			 	document.getElementById("s"+i+"color").style.background = "Red";
			 	document.getElementById("s"+i).style.background = "rgb(29, 29, 29)";
			}
			displayGameover();
		}
		catch(err)
		{
			alert("showError() error: " + err);
		}				
	}
	
	function openMoz(type, url){
	    var openURL = new MozActivity({
	        name: "view",
	        data: {
	            type: type,
	            url: url
	        }
	    });		
	}