/*

noteList : array of note object

note :
- type : "checklist_note" or "text_note"
- title : text
- content : content of a text note, null if not a text note
- contentChecklist : null if text note, else array of checklist item

checklist item : 
- content : text
- checkeck : boolean
*/

var index = null;

// do not check an element when draging a row for example
var disableChecking = false;

window.addEventListener("load", function() {
  console.log("checklistnote.js : HTML loaded");

	$("#back, #glyphBack").on('click',back);
	$("#divAddItem").on('click',function () {$("#dialogAddItem").dialog();});
	$("#dialogAddItem input").keyup(function(event) { if(event.keyCode == 13) { $(".ui-dialog-titlebar-close").click(); addItemFromPopup(); } });
	$("#dialogAddItem [name=buttonOk]").on('click',function() { $(".ui-dialog-titlebar-close").click(); addItemFromPopup(); });
	$("#dialogAddItem [name=buttonCancel]").on('click',function() { $(".ui-dialog-titlebar-close").click(); });
	$("#noteTitle").change(saveNoteAndUpload);
	$("#divMoveNote").on('click',toggleSortable);

	// load note list from disk
	loadNoteList();

	index = getParameterByName('index');
	if(index != "") {
		var note = noteList[index];
		$("#divTutorial").remove();

		$("#noteTitle").val(note.title);

		for(i=0;i<note.contentChecklist.length;i++) {
			var rowClass='glyphicon-ban-circle';
			var strikeStyle='';

			if(note.contentChecklist[i].checked) {
				rowClass='glyphicon-ok-circle';
				strikeStyle='style="text-decoration:line-through;"'
			}

			html = '<tr><td class="text-left" '+strikeStyle+'>'+note.contentChecklist[i].content+'</td><td class="tdIconNoteList" style="vertical-align: middle"><span class="glyphicon '+rowClass+'"></td><td style="width: 1px"><button type="button" class="btn btn-default glyphicon glyphicon-pencil"></td><td style="width: 1px"><button type="button" class="btn btn-default glyphicon glyphicon-trash"></td></tr>';
			$("#tableItemList").append(html);

			addEventsOnTr();
		}
	}
});

/**
  * Toggle sortable table of notes
  */
var sortEnabled = false;
function toggleSortable() {

	if(sortEnabled) {
		$( "#tableItemList tbody" ).sortable('disable');
		$( "#tableItemList tbody" ).disableSelection('disabled');
		$("#divMoveNote").css('color','#777');
	} else {
		$("#divMoveNote").css('color','#00D400');

		// take care of moving rows
  	var oldIndex, newIndex;
  	$( "#tableItemList tbody" ).sortable({
  	    helper: function(event, ui) {
  	      ui.children().each(function() {
  	                      $(this).width($(this).width());
  	                      });
  	      return ui;
  	      },
  	    start: function(event, ui) {
  	        disableChecking = true;
  	        oldIndex = $(ui.item).index();
  	      },
  	    stop: function(event, ui) {
  	        newIndex = $(ui.item).index();
  	        if(newIndex != oldIndex) {
							saveNoteAndUpload();
  	        }
  	        setTimeout(function(){
  	          disableChecking = false;
  	        }, 500);
  	      }
  	  });
  	$( "#tableItemList tbody" ).disableSelection();
	}

	sortEnabled = !sortEnabled;
}

function addEventsOnTr() {
	var isTapHold=false, tapTimer, vmousedownY;
	$("#tableItemList tr td:nth-child(1), #tableItemList tr td:nth-child(2)").unbind().on("vmousedown vmouseup", function (event) {
		if (event.type == 'vmousedown') {
			//set the timer to run the `taphold` function in 1 second
			var obj = this;
			tapTimer = setTimeout(function () {
				isTapHold = true;
				//editItemPopup(obj); disabled since 20150218
				}, 1000);

			/**
				* we detect if user scrolls the list or click on a row by checking the event Y coordinate
				* if Y on vmouseup is too different (like 20px) from Y on vmousedown, then user scrolled and we dont fire rowClicked()
				*/
			vmousedownY = event.screenY;
		} else {
			//event.type == 'vmouseup'
			//clear the timeout if it hasn't yet occured
			clearTimeout(tapTimer);    

			//if the flag is set to false then this is a `tap` event
			if (!isTapHold && Math.abs(vmousedownY-event.screenY) < 20) {
				//this is a tap, not a tap-hold
				rowClicked(this);
			}

			//reset flag
			isTapHold = false;
		}
});

	$(".glyphicon-pencil").unbind().click( editItemPopup );
	$(".glyphicon-trash").unbind().click( deleteItemPopup );
}

function saveNoteAndUpload() {
	// save note
	var note = {
		type : "checklist_note",
		title : $("#noteTitle").val(),
	};

	var itemList = [];

	rowList = $('#tableItemList tr');
	for(i=0;i<rowList.length;i++) {
		var rowClass=$("span",rowList[i]).attr('class');
		var rowChecked = true;
		if(rowClass.match(/ban/)) {
			rowChecked=false;
		}

		var item = {
			content : $("td:first",rowList[i]).html(),
			checked : rowChecked
		}

		itemList.push(item);
	}

	//console.log(itemList);
	//console.log(JSON.parse(JSON.stringify(itemList)));

	note.contentChecklist = itemList;
	if(index === "") {
		index = noteList.push(note) - 1;
	} else {
		noteList[index] = note;
	}
	saveNotelist();

	delayedUpload();
}

/**
	* Called when note upload is finished
	*/
function syncCompleted(syncChange) {
	//do nothing
}

function back() {
	window.location.href = "index.html";
}

function addItemFromPopup() {
	var usertext = $("#dialogAddItem input").val();

	$("#divTutorial").remove();
	
	//reset input
	$("#dialogAddItem input").val('');

	html = '<tr><td class="text-left">'+usertext+'</td><td class="tdIconNoteList" style="vertical-align: middle"><span class="glyphicon glyphicon-ban-circle"></td><td style="width: 1px"><button type="button" class="btn btn-default glyphicon glyphicon-pencil"></td><td style="width: 1px"><button type="button" class="btn btn-default glyphicon glyphicon-trash"></td></tr>';
	$("#tableItemList").append(html);

	addEventsOnTr();

	saveNoteAndUpload();
}

/**
	* Edit item popup
	*/
function editItemPopup(e) {
	//get current item text
	var trObj = e.target.parentNode.parentNode;
	var text = htmlDecode($("td:first",trObj).html());
	$("#dialogEditItem input").val(text);

	$("#dialogEditItem").dialog();

	$("#dialogEditItem input").unbind().keyup(function(event) { if(event.keyCode == 13) { editItem(trObj); } });
	$("#dialogEditItem [name=buttonOk]").unbind().on('click',function() {editItem(trObj);});
	$("#dialogEditItem [name=buttonCancel]").unbind().on('click',function() { $(".ui-dialog-titlebar-close").click(); });
}

function editItem(trObj) {
	$(".ui-dialog-titlebar-close").click();
	
	var text = $("#dialogEditItem input").val();
	$("td:first",trObj).html(htmlEncode(text));
	
	saveNoteAndUpload();
}

/**
	* Called when user click on a checklist item
	* @param item TR object
	*/
function rowClicked(item) {
	if(disableChecking) return;

	//console.log(item);
	var rowClass=$("span",item.parentNode).attr('class');

	if(rowClass.match(/ban/)) {
		//row is unchecked, we check it
		$("span",item.parentNode).attr('class','glyphicon glyphicon-ok-circle');
		$("td:first",item.parentNode).attr('style','text-decoration:line-through');
	} else {
		$("span",item.parentNode).attr('class','glyphicon glyphicon-ban-circle');
		$("td:first",item.parentNode).attr('style','');
	}

	saveNoteAndUpload();
}

/**
	* Show popup to confirm note deletion
	*/
function deleteItemPopup(event) {
	//console.log("deleteNotePopup : "+$(this.parentNode.parentNode).index());
	$("#dialogDeleteItem").dialog();
	
	//close popup if user click on either one of the button
	$("#dialogDeleteItem .btn-danger").unbind().on('click',function() { $(".ui-dialog-titlebar-close").click(); });
	
	$("#buttonDeleteItemOk").unbind().on('click',null, $(this.parentNode.parentNode).index(), deleteItem);
}

function deleteItem(event) {
	//console.log('deleteNote() =>'+event.data);
	$(".ui-dialog-titlebar-close").click(); //hide popup
	
	$("#tableItemList tr").get(event.data).remove();
	//console.log($("#tableNoteList tr"));

	saveNoteAndUpload();
}
