/*

noteList : array of note object

note :
- type : "checklist_note" or "text_note"
- title : text
- content : content of a text note, null if not a text note
- contentChecklist : null if text note, else array of checklist element

checklist element : 
- content : text
- checkeck : boolean
*/

// do not edit a note when draging a row for example
var disableEdit = false;

document.webL10n.ready(function() { //Do not use "load" event here because webL10n might not be initialized and we need it for cloud status icon
  console.log("index.hs : HTML loaded");

	/* put listener */
	$("#divAddNote").on('click',chooseNoteTypePopup);
	$("#divMoveNote").on('click',toggleSortable);
	
	$(".navbar img[name=cloudIcon]").on('click',function() {$("#dialogCloud").dialog();});
	$("#buttonForceSync").on('click',function () {checkSync(true);});
	$("#buttonSynchronizeWithOtherDevice").on('click',function() {window.location='pair.html';});

	$("#imgAddTextNote").on('click',addTextNote);
	$("#imgAddChecklistNote").on('click',addChecklistNote);

	//load noteList from disk
	if(loadNoteList()) {
		$("#divTutorial").hide();
	} else {
		$("#divTutorial").show();
	}

	showNoteList();

	login(loginCompleted);

	//console.log(noteList);

});

function loginCompleted(loginStatus) {
	if(loginStatus) {
		console.log('index.js/loginCompleted(): login ok');
		checkSync();
	} else {
		console.log('index.js/loginCompleted(): login error');
	}
}

/**
	* Called after synchronisation has been done
	* @param syncChange one of: 
	* - "none" (nothing happened)
	* - "upload" (notes have been uploaded to server)
	* - "download" (notes have been download from server)
	*/
function syncCompleted(syncChange) {
	if(syncChange=='download') {
		showNoteList();
	}
}

/**
	* Show notes in noteList
	*/
function showNoteList() {
	//remove all elements in table
	$("#tableNoteList tr").remove();

	if(noteList.length > 0) {
		for(var i=0;i<noteList.length;i++) {
			var html = '';
			if(noteList[i] === null) continue; //happened one time, strange...
			if(noteList[i].type=='text_note') {
				var title = noteList[i].title;
				if(title.length == 0) title = noteList[i].content.substr(0,15);
				html = '<tr id="tr'+i+'">' +
						'<td class="tdIconNoteList">' +
							'<img src="icons/textnote.png" class="imgNoteList"></td><td>'+htmlEncode(title)+
						'</td>'+
						'<td class="text-right">'+
							'<button class="btn btn-default glyphicon glyphicon-trash">'+
						'</td>'+
					'</tr>';
				$("#tableNoteList").append(html);
				$("#tr"+i).on('click',(function() { return function() { editTextNote(this); }; })(i));
			} else {
				var title = noteList[i].title;
				if(title.length == 0 && noteList[i].contentChecklist.length>0) title = noteList[i].contentChecklist[0].content;
				html = '<tr id="tr'+i+'"><td class="tdIconNoteList"><img src="icons/checklist.png" class="imgNoteList"></td><td>'+htmlEncode(title)+' <span class="badge">'+getNumberOfUncheckedItemInNote(noteList[i])+"/"+noteList[i].contentChecklist.length+'</span></td><td class="text-right"><button class="btn btn-default glyphicon glyphicon-trash"></td></tr>';
				$("#tableNoteList").append(html);
				$("#tr"+i).on('click',(function() { return function() { editChecklistNote(this); }; })(i));
			}
		}
		$(".glyphicon-trash").click( deleteNotePopup );
	}

}

/**
	* Toggle sortable table of notes
	*/
var sortEnabled = false;
function toggleSortable() {

	if(sortEnabled) {
		$( "#tableNoteList tbody" ).sortable('disable');
		$( "#tableNoteList tbody" ).disableSelection('disabled');
		$("#divMoveNote").css('color','#777');
	} else {
		$("#divMoveNote").css('color','#00D400');

		// take care of moving rows
		var oldIndex, newIndex;
		$( "#tableNoteList tbody" ).sortable({
				helper: function(event, ui) {
					ui.children().each(function() {
													$(this).width($(this).width());
													});
					return ui; 
					},
				start: function(event, ui) {
						disableEdit = true;
						oldIndex = $(ui.item).index();
					},
				stop: function(event, ui) {
						newIndex = $(ui.item).index();
						if(newIndex != oldIndex) {
							var note_temp = noteList[oldIndex];
							noteList[oldIndex] = noteList[newIndex];
							noteList[newIndex] = note_temp;
							saveNotelist();
							checkSync();
						}
						setTimeout(function(){
							disableEdit = false;
						}, 500);
					}
			});
		$( "#tableNoteList tbody" ).disableSelection();
	}

	sortEnabled = !sortEnabled;
}


function chooseNoteTypePopup() {
	$("#dialogAddNote").dialog();
}

function addTextNote() {
	$("#dialogAddNote .ui-dialog-titlebar-close").click();
	window.location.href = "textnote.html";
}

function addChecklistNote() {
	$(".ui-dialog-titlebar-close").click();
	window.location.href = "checklistnote.html";
}

/**
	* Edit text note
	* @param tr TR html element
	*/
function editTextNote(tr) {
	if(disableEdit) return;
	window.location.href = "textnote.html?index="+$(tr).index();
}

/**
	* Edit checklist note
	* @param tr TR html element
	*/
function editChecklistNote(tr) {
	if(disableEdit) return;
	window.location.href = "checklistnote.html?index="+$(tr).index();
}

/**
	* Show popup to confirm note deletion
	*/
function deleteNotePopup(event) {
	//console.log("deleteNotePopup : "+$(this.parentNode.parentNode).index());
	$("#dialogDeleteNote").dialog();

	//close popup if user click on either one of the button
	$("#dialogDeleteNote .btn-danger").unbind().on('click',function() { $(".ui-dialog-titlebar-close").click(); });

	$("#buttonDeleteNoteOk").unbind().on('click',null, $(this).closest('tr').index(), deleteNote);

	// prevent opening note because of onclick on <tr>
	event.stopPropagation();
}

function deleteNote(event) {
	//console.log('deleteNote() =>'+event.data);
	$(".ui-dialog-titlebar-close").click(); //hide popup

	noteList.splice(event.data,1);
	saveNotelist();
	$("#tableNoteList tr").get(event.data).remove();
	//console.log($("#tableNoteList tr"));

	checkSync();
}
