/**
	* JS for pair page
	*/

window.addEventListener("load", function() {
  console.log("index.hs : HTML loaded");

	/* put listener */
	$("#btnEnterPairCode").click(function() {$("#dialogEnterPairCode").dialog();});
	$("#buttonEnterPairCodeOk").click(function() {pairDevice();});
	$("#buttonEnterPairCodeCancel").click(function() {$(".ui-dialog-titlebar-close").click();});

	$("#btnUnpair").click(function() {$("#dialogUnpair").dialog();});
	$("#buttonUnpairOk").click(function() {unpair(); $(".ui-dialog-titlebar-close").click();});
	$("#buttonUnpairCancel").click(function() {$(".ui-dialog-titlebar-close").click();});

	$("#buttonPairingSuccessfullOk").click(function() {$(".ui-dialog-titlebar-close").click();});
	$("#buttonUnpairingSuccessfullOk").click(function() {$(".ui-dialog-titlebar-close").click();});

	/* get pair code from server */
	$.ajax({
    type: "GET",
    url: baseUrl+"/ajax/user.php",
    xhrFields: {
      withCredentials: true
    },
    data: { getPairCode: "" }
    })
    .always(function(data,textStatus, jqXHR) {

			if(textStatus != "success") {
				$("#imgLoading").hide();
				$("#spanLoading").hide();
				$("#spanError").show();
			} else {
				if(data=='') {
					generatePairCode();
				} else {
					$("#imgLoading").hide();
					$("#spanLoading").hide();
					$("#spanPairCode").html(data);
				}
			}
		});

	getNumberOfDevices();
});

/**
	* get number of devices in sync to hide unpair button if == 0
	*/
function getNumberOfDevices() {
	$.ajax({
    type: "GET",
    url: baseUrl+"/ajax/user.php",
    xhrFields: {
      withCredentials: true
    },
    data: { getNumberOfDevices: "" }
    })
    .always(function(data,textStatus, jqXHR) {

			if(textStatus == "success") {
				if(data==1) {
					$("#divUnpair").hide();
				} else {
					$("#divUnpair").show();
				}
			}
		});
}

/**
	* Ask server to generate a new pair code
	*/
function generatePairCode() {

	$.ajax({
    type: "GET",
    url: baseUrl+"/ajax/user.php",
    xhrFields: {
      withCredentials: true
    },
    data: { generatePairCode: "" }
    })
    .always(function checkSyncResponse(data,textStatus, jqXHR) {
			if(textStatus != "success") {
				$("#imgLoading").hide();
				$("#spanLoading").hide();
				$("#spanError").show();
			} else {
				$("#imgLoading").hide();
				$("#spanLoading").hide();
				$("#spanPairCode").html(data);
			}
		});
}

/**
	* Pair device (called when clicking OK in enter pair code popup
	*/
function pairDevice() {
	//check that pair code format is valid
	var pairCode = $('#inputPC').val();

	if(pairCode.length != 6) {
		$('#divInputEPC').addClass('form-group has-error');
		$('#divInputEPC label').removeClass('hidden');
		$('#divInputEPC span').removeClass('hidden');
	} else {
		$('#divInputEPC').removeClass('form-group has-error');
		$('#divInputEPC label').addClass('hidden');
		$('#divInputEPC span').addClass('hidden');

		//ask server for pairing
		$.ajax({
  	  type: "GET",
  	  url: baseUrl+"/ajax/user.php",
  	  xhrFields: {
  	    withCredentials: true
  	  },
  	  data: { pairDevice: pairCode }
  	  })
  	  .always(function(data,textStatus, jqXHR) {
				if(textStatus == "success") {
					if(data=='ok') {
						$(".ui-dialog-titlebar-close").click();

						$('#dialogPairSuccessfull').dialog(); //show dialog successfull pairing

						$("#divUnpair").show();
					} else if(data == 'invalid pair code') {
						$('#divInputEPC').addClass('form-group has-error');
						$('#divInputEPC label').removeClass('hidden');
						$('#divInputEPC span').removeClass('hidden');
					}
				}
			});

	}
}

function unpair() {
	//stop sync
	$.ajax({
	  type: "GET",
	  url: baseUrl+"/ajax/user.php",
	  xhrFields: {
	    withCredentials: true
	  },
	  data: { stopPairing: "" }
	  })
	  .always(function(data,textStatus, jqXHR) {
			if(textStatus == "success") {
				if(data=='ok') {
					$("#divUnpair").hide();
				}
			}
		});

}
