/*

noteList : array of note object

note :
- type : "checklist_note" or "text_note"
- title : text
- content : content of a text note, null if not a text note
- contentChecklist : null if text note, else array of checklist element

checklist element : 
- content : text
- checkeck : boolean
*/

var index = null;

window.addEventListener("load", function() {
  console.log("textnote.js : HTML loaded");

	$("#back, #glyphBack").on('click',back);

	// load note list from disk
	loadNoteList();

	index = getParameterByName('index');
	if(index != "") {
		//fill inputs
		$("#noteTitle").val(noteList[index].title);
		$("#textareaContent").text(noteList[index].content);
	}

	$("#textareaContent").autosize();

	$("#textareaContent").keyup(saveNoteAndUpload);

	$("#noteTitle").change(saveNoteAndUpload);
});

function saveNoteAndUpload() {
	//save note
	var note = {
		type : "text_note",
		title : $("#noteTitle").val(),
		content : $("#textareaContent").val()
	};

	//console.log(note);
	//console.log(JSON.parse(JSON.stringify(note)));

	if(index === "") {
		index = noteList.push(note) - 1;
	} else {
		noteList[index] = note;
	}
	saveNotelist();

	delayedUpload();
}

/**
  * Called when note upload is finished
  */
function syncCompleted(syncChange) {
	//do nothing
}

function back() {
	window.location.href = "index.html";
}
