function JsonDatasource(file) {
    var dict = null;
    this.file = file;

    var index = {
        abc: {},
        length: {}
    };

    // szavak indexelése
    var doIndex = function (dict) {
        // első betű index tartomány szerint
        index.abc[0] = {};
        for (var i in dict.abc) {
            index.abc[0][dict.abc[i]] = [0, 0];
        }

        // végigmegyünk az összes szón és betűnként létrehozzuk a tartományokat
        var pL = '';
        for (var i = 0; i < dict.words.length; i++) {
            var word = dict.words[i];

            var L = word[0];

            if (pL == L)
                index.abc[0][L][1] = i;
            else
                index.abc[0][L][0] = i;

            index.abc[0][L]['range'] = true;

            pL = L;

            // indexelünk szóhossz szerint
            if (!index.length[word.length])
                index.length[word.length] = [];

            //index.length[word.length].push(word);
            index.length[word.length].push(i);

            // végigmegyünk az összes betűn és pozíció ill. betű szerint indexeljük a többi helyet, itt már index
            // listát használva tartomány helyett
            for (var c = 1; c < word.length; c++) {
                if (!index.abc[c])
                    index.abc[c] = {};

                if (!index.abc[c][word[c]])
                    index.abc[c][word[c]] = [];

                //index.abc[c][word[c]].push(word);
                index.abc[c][word[c]].push(i);
            }
        }
    };

    this.load = function (progress, completed) {
        var xhr = new XMLHttpRequest();

        xhr.addEventListener("progress", function (event) {
            if (event.lengthComputable) {
                progress((event.loaded / event.total) * 80, 'Fájl betöltése...');
            }
            else {
                progress(80, 'Fájl betöltése...');
            }
        }, false);

        xhr.onload = function (event) {
            progress(90, 'Feldolgozás...');

            dict = JSON.parse(xhr.responseText);

            doIndex(dict);

            progress(100, 'Kész!');
            completed();
        };

        xhr.open("GET", this.file, true);
        xhr.send();

        return xhr;
    };

    this.getAbc = function () {
        return dict.abc;
    };

    var _cache = {
        cache: [],
        length: 0
    };
    var _cachePartial = {
        cache: [],
        length: 0
    };

    this.query = function (st) {
        var result = [];

        function getMarkers(pattern) {
            // megkeressük az első konkrét betű pozícióját a mintában
            var result = {
                first: -1,
                count: 0,
                letters: {}
            };

            for (var i = 0; i < pattern.length; i++) {
                if (pattern[i] != '_') {
                    result.count++;

                    result.letters[i] = pattern[i];

                    if (result.first === false)
                        result.first = i;
                }
            }

            return result;
        }

        var result = null;

        // szóhossz alapján 1 véletlenszerű szó kiválasztása
        if (!st.pattern && st.single && st.length) {
            var i = Math.round(Math.random() * (index.length[st.length].length - 1));
            var wordIndex = index.length[st.length][i];
            result = dict.words[wordIndex];
        }

        if (!st.pattern && st.exists && st.length) {
            result = typeof index.length[st.length] != 'undefined';
        }

        // minta alapján szűkíteni...
        if (st.pattern) {
            // megkeressük az első konkrét betű pozícióját a mintában
            var markers = getMarkers(st.pattern);

            var cache = _cache;
            if (st.partial)
                cache = _cachePartial;

            // ha van konkrét betű
            if (markers.count) {
                // a cache.cache érvénytelen, ha más mintha hosszhoz készült
                if (cache.length != st.pattern.length) {
                    cache.cache = [];
                    cache.length = st.pattern.length;

                    //console.log('cache miss! (diff params)')
                }
                else {
                    //console.log('cache found! (same params)');
                }

                // végigmegyünk a minta betűin, words a bemeneti szólista
                // null alapérték: nincsen, ekkor az összes szót vesszük (pl. placeholderek az első betűig)
                var words = null;
                for (var i in st.pattern) {
                    // ha van cache.cache a pozícióhoz
                    if (cache.cache[i]) {
                        // ha más betű van, akkor a cache.cache jelenlegi és hátrelévő pozíciói érvénytelenek
                        if (cache.cache[i].letter != st.pattern[i]) {
                            cache.cache = cache.cache.slice(0, i);

                            //console.log('cache miss! (different letter)');
                        }
                        else {
                            //console.log('cache found! (letter)');
                        }
                    }

                    // ha érvényes a cache.cache a pozícióhoz
                    if (cache.cache[i]) {
                        // a következő bemenet ez a szólista lesz
                        words = cache.cache[i].words;
                    }
                    else {
                        // ha placeholder karakter, akkor a szólista változatlan lesz
                        if (st.pattern[i] == '_') {
                            cache.cache[i] = {
                                letter: st.pattern[i],
                                words: words
                            };
                        }
                        // különben szűrés ...
                        else {
                            // ha nincs bemeneti szólista, tehát ez az első konkrét karakter
                            if (!words) {
                                // 0-nál magasabb pozíciók
                                if (i > 0)
                                    words = index.abc[i][st.pattern[i]];
                                // 0 pozíció, különleges
                                else
                                    words = index.abc[0][st.pattern[i]];

                                if (!words) {
                                    words = [];
                                }
                            }

                            var filtered = [];

                            if (words['range']) {
                                for (var w = words[0]; w < words[1]; w++) {
                                    var word = dict.words[w];
                                    if ((word.length == st.pattern.length || (st.partial && word.length > st.pattern.length)) && word[i] == st.pattern[i])
                                        filtered.push(w);
                                }
                            }
                            else {
                                for (var w in words) {
                                    var wordIndex = words[w];
                                    var word = dict.words[wordIndex];
                                    if ((word.length == st.pattern.length || (st.partial && word.length > st.pattern.length)) && word[i] == st.pattern[i])
                                        filtered.push(wordIndex);
                                }
                            }

                            cache.cache[i] = {
                                letter: st.pattern[i],
                                words: filtered
                            };

                            words = filtered;
                        }
                    }
                }

                if (st.single) {
                    if (cache.cache[cache.cache.length - 1].words['range']) {
                        var range = [cache.cache[cache.cache.length - 1].words[0], cache.cache[cache.cache.length - 1].words[1]];
                        var wordIndex = range[0] + Math.round(Math.random() * (range[1] - range[0]));
                        result = dict.words[wordIndex];
                    }
                    else {
                        range = [0, cache.cache[cache.cache.length - 1].words.length - 1];
                        var rangeIndex = range[0] + Math.round(Math.random() * (range[1] - range[0]));
                        var wordIndex = cache.cache[cache.cache.length - 1].words[rangeIndex];
                        result = dict.words[wordIndex];
                    }
                }
                else if (st.exists) {
                    result = cache.cache[cache.cache.length - 1].words.length > 0
                }
            }
            // ha nincs betű a mintában és nem részleges találat szükséges
            else if (!st.partial) {
                // ha létezik adott hosszra index
                if (st.exists) {
                    result = typeof index.length[st.pattern.length] != 'undefined';
                }
                else if (st.single) {
                    if (index.length[st.pattern.length]) {
                        var wordIndex = Math.round(Math.random() * (index.length[st.pattern.length].length - 1));
                        result = dict.words[index.length[st.pattern.length][wordIndex]];
                    }
                }
            }
            // ha nincs betű és részleges találat is megfelelő
            else {
                // megnézzük, hogy van-e hosszban megegyező vagy hosszabb szó (index alapján)
                var exists = false;
                for (var i in index.length) {
                    if (i >= st.partial) {
                        exists = true;
                        break;
                    }
                }

                result = exists;
            }
        }

        return result;
    };
}

var Dictionary = new function() {
    var datasource = null;

    this.setDatasource = function(ds, progress, completed) {
        datasource = ds;

        ds.load(progress, completed);
    };

    this.listWords = function(st) {
        return datasource.query(st);
    };

    this.getAbc = function() {
        return datasource.getAbc();
    };

    this.findWord = function(st) {
        return datasource.query(st);
    };
}();

function Backtrack() {

}

Backtrack.search = function (problem, findAll, rootProgress) {
    var solution = findAll ? [] : null;

    var search = function (state, rootProgress) {
        //console.log(state);

        if (!problem.isPartialSolution(state)) return false;
        if (problem.isSolution(state)) {
            if (!findAll) {
                solution = state;
                return;
            }
            else {
                solution.push(state);
            }
        }

        var actions = problem.getActions(state);
        actions.sort(function (a, b) {
            return Math.random() * 2 - 1;
        });

        for (var i = 0; i < actions.length && (findAll || (!findAll && !solution)); i++) {
            search(problem.applyAction(state, actions[i]));

            if (typeof rootProgress == 'function')
                rootProgress(i / actions.length);
        }
    };

    search(problem.getInitialState(), rootProgress);

    return solution;
};



function GenerationProblem(map, size, length) {
    var openset = [];

    for (var i = 0; i < map.length; i++) {
        openset.push(i);
    }

    this.isPartialSolution = function (state) {
        if (state.length > length)
            return false;

        if (state.length == 0)
            return true;

        var pattern = [];
        for (var i = 0; i < length; i++) {
            var c = i < state.length ? map[state[i]] : ' ';
            pattern[i] = c == ' ' ? '_' : c;
        }

        return Dictionary.findWord({
            exists: true,
            partial: true,
            pattern: pattern
        });
    };

    this.isSolution = function (state) {
        if (state.length != length)
            return;

        var pattern = [];
        for (var i = 0; i < length; i++) {
            var c = i < state.length ? map[state[i]] : ' ';
            pattern[i] = c == ' ' ? '_' : c;
        }

        return Dictionary.findWord({
            exists: true,
            pattern: pattern
        });
    };

    this.getInitialState = function () {
        return [];
    };

    this.getActions = function (state) {
        if (state.length == 0) {
            return openset;
        }

        var current = state[state.length - 1];

        var actions = [];
        for (var y = -1; y <= 1; y++) {
            for (var x = -1; x <= 1; x++) {
                var _y = Math.floor(current / size),
                    _x = current % size;

                if (_y + y >= 0 && _y + y < size &&
                    _x + x >= 0 && _x + x < size &&
                    state.indexOf((_y + y) * size + _x + x) == -1)
                    actions.push((_y + y) * size + _x + x);
            }
        }

        return actions;
    };

    this.applyAction = function (state, action) {
        var newState = state.slice(0);
        newState.push(action);

        return newState;
    }
}



function SolveProblem(map, size) {
    var openset = [];

    for (var i = 0; i < map.length; i++) {
        openset.push(i);
    }

    this.isPartialSolution = function (state) {
        if (state.length == 0)
            return true;

        var pattern = [];
        for (var i = 0; i < state.length; i++)
            pattern[i] = map[state[i]];

        return Dictionary.findWord({
            exists: true,
            partial: true,
            pattern: pattern
        });
    };

    this.isSolution = function (state) {
        var pattern = [];
        for (var i = 0; i < state.length; i++)
            pattern[i] = map[state[i]];

        return Dictionary.findWord({
            exists: true,
            pattern: pattern
        });
    };

    this.getInitialState = function () {
        return [];
    };

    this.getActions = function (state) {
        if (state.length == 0) {
            return openset;
        }

        var current = state[state.length - 1];

        var actions = [];
        for (var y = -1; y <= 1; y++) {
            for (var x = -1; x <= 1; x++) {
                var _y = Math.floor(current / size),
                    _x = current % size;

                if (_y + y >= 0 && _y + y < size &&
                    _x + x >= 0 && _x + x < size &&
                    state.indexOf((_y + y) * size + _x + x) == -1)
                    actions.push((_y + y) * size + _x + x);
            }
        }

        return actions;
    };

    this.applyAction = function (state, action) {
        var newState = state.slice(0);
        newState.push(action);

        return newState;
    }
}



function Puzzle(map, size) {
    this.map = map;
    this.size = size;
    this.words = null;
}

/* Új pálya generálása */

Puzzle.generate = function (size, progress, completed) {
    var map = [];
    var puzzle = new Puzzle(map, size);


    for (var i = 0; i < size * size; i++) {
        map[i] = ' ';
    }

    console.log("==========================================");

    function translate(map, solution) {
        var word = [];
        for (var ii in solution) {
            var c = map[solution[ii]];
            word[ii] = String(c == " " ? "_" : c);
        }
        return word;
    }

    progress(0, 'Szavak hozzáadása...');

    var T = 15;
    for (var t = 0; t < T; t++) {
        var length = Math.round(Math.random() * (size * size - 3) + 3);

        if (Dictionary.findWord({
                exists: true,
                length: length
            })) {
            var solution = Backtrack.search(new GenerationProblem(map, size, length));

            if (solution) {
                var pattern = translate(map, solution);

                console.log(pattern);

                var word = Dictionary.findWord({
                    single: true,
                    pattern: pattern
                });

                console.log(word);

                if (word)
                    for (var i in solution) map[solution[i]] = word[i];
            }
            else {
                console.log('');
            }
        }

        progress((t / T) * 50, 'Szavak hozzáadása...');
    }
    ;

    progress(50, 'Szavak ellenőrzése...');

    for (var i = 0; i < size * size; i++) {
        if (map[i] == ' ')
            map[i] = Dictionary.getAbc()[Math.floor(Math.random() * Dictionary.getAbc().length)];//'X';
    }

    console.log('');
    var s = "   ";
    for (var i = 0; i < size; i++) {
        s += i + " ";
    }
    console.log(s);
    s = "";
    for (var i in map) {
        s += map[i] + " ";
        if (i % size == size - 1) {
            console.log(Math.floor(i / size) + ": " + s);
            s = "";
        }
    }

    var solutions = Backtrack.search(new SolveProblem(map, size), true, function (percent) {
        progress(50 + 50 * percent, 'Szavak ellenőrzése...')
    });

    var words = "Szavak: ", prefix = '', found = {};
    puzzle.words = [];
    for (var i in solutions) {
        var word = translate(map, solutions[i]).join("");

        if (!found[word] && word.length > 2) {
            found[word] = word;
            words += prefix + word;
            prefix = ", ";
            puzzle.words.push(word);
        }
    }

    console.log(words);

    progress(100, 'Kész!');
    completed(puzzle);

    return puzzle;
};

console = { log: function() {} } || console;

onmessage = function (event) {
    switch (event.data.name) {
        case 'loadDictionary':
            handleLoadDictionary(event.data.url);
            break;

        case 'generatePuzzle':
            handleGeneratePuzzle(event.data.size);
            break;
    }
};

function handleLoadDictionary(url) {
    Dictionary.setDatasource(new JsonDatasource(url), function (progress, message) {
            postMessage({
                name: 'loadDictionaryProgress',
                progress: progress,
                message: message
            });
        },
        function () {
            postMessage({
                name: 'loadDitionaryCompleted'
            });
        });
}

function handleGeneratePuzzle(size) {
    var puzzle = Puzzle.generate(size, function (progress, message) {
            postMessage({
                name: 'generatePuzzleProgress',
                progress: progress,
                message: message
            });
        },
        function (puzzle) {
            postMessage({
                name: 'generatePuzzleCompleted',
                puzzle: {
                    map: puzzle.map,
                    size: puzzle.size,
                    words: puzzle.words
                }
            });
        });
}