//jscs:disable maximumLineLength
window.DATA = {
days: [
//Januar
{name: {de: 'Neujahr', en: 'New Year'}, d: 1, m: 1, holiday: ['AT', 'CH', 'DE', 'LI'], type: 'sec-0'},
{name: 'Hochfest der Gottesmutter Maria', d: 1, m: 1, type: 'rel-2'},
{name: 'Manuela, Wilhelm', d: 1, m: 1, type: 'rel-3'},
{name: 'Berchtoldstag', d: 2, m: 1, holiday: ['CH'], type: 'special-0'},
{name: 'Basilius der Große, Gregor von Nazianz, Dietmar', d: 2, m: 1, type: 'rel-3'},
{name: 'Heiligster Name Jesu, Zdislava, Genoveva von Paris, Odilo von Cluny, Gordius, Adela von Pfalzel, Telemach', d: 3, m: 1, type: 'rel-3'},
{name: 'Oringa Menabuoi, Angelika von Foligno, Elisabeth Anna Bayley Seton', d: 4, m: 1, type: 'rel-3'},
{name: 'Johannes Nepomuk Neumann, Eduard der Bekenner, Aemiliana, Roger von Todi, Raphaela Porres y Ayollón', d: 5, m: 1, type: 'rel-3'},
{name: {de: 'Heilige Drei Könige', en: 'Epiphany'}, d: 6, m: 1, holiday: ['AT', 'DE-BW', 'DE-BY', 'DE-ST', 'LI'], type: 'rel-0'},
{name: 'Makarius, der Schotte', d: 6, m: 1, type: 'rel-3'},
{name: 'Taufe des Herrn', d: 7, m: 1, w: 0, type: 'rel-3'},
{name: 'Raimund von Peñafort, Valentin von Rätien', d: 7, m: 1, type: 'rel-3'},
{name: 'Severin von Noricum', d: 8, m: 1, type: 'rel-3'},
{name: 'Petrus von Sebaste', d: 9, m: 1, type: 'rel-3'},
{name: 'Paulus von Theben, Leonie Aviat, Gregor X., Agatho, Wilhelm von Bourges, Pietro Orseolo', d: 10, m: 1, type: 'rel-3'},
{name: 'Theodosius, Thomas von Cori, Hyginus, Paulinus von Aquileja', d: 11, m: 1, type: 'rel-3'},
{name: 'Bernardo da Corleone', d: 12, m: 1, type: 'rel-3'},
{name: 'Hilarius von Poitiers, Mungo von Glasgow', d: 13, m: 1, type: 'rel-3'},
{name: 'Felix von Nola', d: 14, m: 1, type: 'rel-3'},
{name: 'Maurus, Habakuk', d: 15, m: 1, type: 'rel-3'},
{name: 'Antonius der Große', d: 17, m: 1, type: 'rel-3'},
{name: 'Art’s Birthday', d: 17, m: 1, type: 'sec-2'},
{name: 'Odilo von Bayern', d: 18, m: 1, type: 'rel-3'},
{name: 'Heinrich von Uppsala', d: 19, m: 1, type: 'rel-3'},
{name: 'Fabian, Sebastian', d: 20, m: 1, type: 'rel-3'},
{name: 'Agnes von Rom, Meinrad, Epiphanius von Pavia', d: 21, m: 1, type: 'rel-3'},
{name: 'Vinzenz Pallotti, Vinzenz von Saragossa', d: 22, m: 1, type: 'rel-3'},
{name: 'Heinrich Seuse', d: 23, m: 1, type: 'rel-3'},
{name: 'Franz von Sales', d: 24, m: 1, type: 'rel-3'},
{name: 'Welt-Lepra-Tag', d: 25, m: 1, w: 0, type: 'sec-2'},
{name: 'Heinrich Seuse, Bekehrung des hl. Apostels Paulus', d: 25, m: 1, type: 'rel-3'},
{name: 'Titus und Timotheus', d: 26, m: 1, type: 'rel-3'},
{name: 'Angela Merici', d: 27, m: 1, type: 'rel-3'},
{name: 'Tag des Gedenkens an die Opfer des Nationalsozialismus', d: 27, m: 1, type: 'sec-1'},
{name: 'Thomas von Aquin', d: 28, m: 1, type: 'rel-3'},
{name: 'Bathilde, Maria Ward, Martina', d: 30, m: 1, type: 'rel-3'},
{name: 'Aidán von Ferns, Johannes Bosco', d: 31, m: 1, type: 'rel-3'},
//Februar - April
{name: {de: 'Schmotziger Donnerstag', en: 'Fat Thursday'}, e: -52, type: 'sec-1'},
{name: 'Rosenmontag', e: -48, type: 'sec-0'},
{name: {de: 'Faschingsdienstag', en: 'Shrove Tuesday'}, e: -47, type: 'sec-0'},
{name: {de: 'Aschermittwoch', en: 'Ash Wednesday'}, e: -46, type: 'rel-1'},
{name: '1. Fastensonntag', e: -42, type: 'rel-1'},
{name: '2. Fastensonntag', e: -35, type: 'rel-1'},
{name: '3. Fastensonntag', e: -28, type: 'rel-1'},
{name: '4. Fastensonntag', e: -21, type: 'rel-1'},
{name: '5. Fastensonntag', e: -14, type: 'rel-1'},
{name: {de: 'Palmsonntag', en: 'Palm Sunday'}, e: -7, type: 'rel-1'},
{name: {de: 'Gründonnerstag', en: 'Maundy Thursday'}, e: -3, type: 'rel-1'},
{name: {de: 'Karfreitag', en: 'Good Friday'}, e: -2, holiday: ['AT', 'CH', 'DE'], type: 'rel-0'},
{name: {de: 'Karsamstag', en: 'Holy Saturday'}, e: -1, type: 'rel-1'},
{name: {de: 'Ostersonntag', en: 'Easter Sunday'}, e: 0, type: 'rel-0'},
{name: {de: 'Ostermontag', en: 'Easter Monday'}, e: 1, holiday: ['AT', 'CH', 'DE', 'LI'], type: 'rel-0'},
{name: 'Weißer Sonntag', e: 7, type: 'rel-1'},
//Februar
{name: 'Brigida von Kildare', d: 1, m: 2, type: 'rel-3'},
{name: {de: 'Darstellung des Herrn', en: 'Presentation of Jesus at the Temple'}, d: 2, m: 2, type: 'rel-2'},
{name: 'Blasius von Sebaste, Ansgar', d: 3, m: 2, type: 'rel-3'},
{name: 'Rabanus Maurus, Isidor von Pelusium', d: 4, m: 2, type: 'rel-3'},
{name: 'Weltkrebstag', d: 4, m: 2, type: 'sec-2'},
{name: 'Adelheid von Vilich, Agatha von Catania', d: 5, m: 2, type: 'rel-3'},
{name: 'Paul Miki', d: 6, m: 2, type: 'rel-3'},
{name: 'Richard von Wessex', d: 7, m: 2, type: 'rel-3'},
{name: 'Hieronymus Ämiliani, Josefine Bakhita', d: 8, m: 2, type: 'rel-3'},
{name: 'Apollonia', d: 9, m: 2, type: 'rel-3'},
{name: 'Scholastika von Nursia', d: 10, m: 2, type: 'rel-3'},
{name: 'Unsere Liebe Frau in Lourdes', d: 11, m: 2, type: 'rel-3'},
{name: 'Internationaler Tag des Radios', d: 13, m: 2, type: 'sec-3'},
{name: 'Valentin', d: 14, m: 2, type: 'rel-1'},
{name: 'Kyrill von Saloniki, Method von Saloniki', d: 14, m: 2, type: 'rel-3'},
{name: 'Juliana von Nikomedien', d: 16, m: 2, type: 'rel-3'},
{name: 'Sieben heiligen Gründer des Servitenordens', d: 17, m: 2, type: 'rel-3'},
{name: 'Barbatus von Benevent', d: 19, m: 2, type: 'rel-3'},
{name: 'Petrus Damian', d: 21, m: 2, type: 'rel-3'},
{name: 'Internationaler Tag der Muttersprache', d: 21, m: 2, type: 'sec-2'},
{name: 'Kathedra Petri', d: 22, m: 2, type: 'rel-2'},
{name: 'Polykarp von Smyrna', d: 23, m: 2, type: 'rel-3'},
{name: 'Matthias', d: 24, m: 2, type: 'rel-3'},
{name: 'Walburga', d: 25, m: 2, type: 'rel-3'},
{name: 'Markward von Prüm', d: 27, m: 2, type: 'rel-3'},
//März
{name: 'Weltgebetstag der Frauen', d: 1, m: 3, w: 5, type: 'rel-2'},
{name: 'Suitbert, Donatus von Basel', d: 1, m: 3, type: 'rel-3'},
{name: 'Agnes von Böhmen', d: 2, m: 3, type: 'rel-3'},
{name: 'Anselm von Nonantola', d: 3, m: 3, type: 'rel-3'},
{name: 'Tag des Artenschutzes', d: 3, m: 3, type: 'sec-2'},
{name: 'Kasimir', d: 4, m: 3, type: 'rel-3'},
{name: 'Fridolin von Säckingen', d: 6, m: 3, type: 'rel-3'},
{name: 'Perpetua und Felicitas, Volker von Segeberg', d: 7, m: 3, type: 'rel-3'},
{name: 'Johannes von Gott', d: 8, m: 3, type: 'rel-3'},
{name: 'Internationaler Frauentag', d: 8, m: 3, type: 'sec-2'},
{name: 'Bruno von Querfurt, Franziska von Rom', d: 9, m: 3, type: 'rel-3'},
{name: 'Johannes Baptist Righi', d: 12, m: 3, type: 'rel-3'},
{name: 'Mathilde', d: 14, m: 3, type: 'rel-3'},
{name: 'Klemens Maria Hofbauer', d: 15, m: 3, type: 'rel-3'},
{name: 'Patrick von Irland, Gertrud von Nivelles', d: 17, m: 3, type: 'rel-3'},
{name: 'Kyrill von Jerusalem', d: 18, m: 3, type: 'rel-3'},
{name: 'Josef', d: 19, m: 3, type: 'rel-2'},
{name: 'Benedikt von Nursia', d: 21, m: 3, type: 'rel-3'},
{name: 'Welttag gegen Rassismus', d: 21, m: 3, type: 'sec-2'},
{name: 'Welttag des Wassers', d: 22, m: 3, type: 'sec-2'},
{name: 'Turibio von Mangrovejo', d: 23, m: 3, type: 'rel-3'},
{name: 'Katharina von Schweden', d: 24, m: 3, type: 'rel-3'},
{name: 'Welttuberkulosetag', d: 24, m: 3, type: 'sec-2'},
{name: {de: 'Beginn der Sommerzeit', en: 'Start of (European) daylight saving time'}, d: 25, m: 3, w: 0, type: 'sec-0'},
{name: 'Verkündigung des Herrn', d: 25, m: 3, type: 'rel-2'},
{name: 'Dismas', d: 25, m: 3, type: 'rel-3'},
{name: 'Liudger, Kastulus', d: 26, m: 3, type: 'rel-3'},
{name: 'Berthold von Kalabrien', d: 29, m: 3, type: 'rel-3'},
{name: 'Guido von Pomposa', d: 31, m: 3, type: 'rel-3'},
//April - Juni
{name: {de: 'Christi Himmelfahrt', 'de-CH': 'Auffahrt', en: 'Ascension'}, e: 39, holiday: ['AT', 'CH', 'DE', 'LI'], type: 'rel-0'},
{name: {de: 'Pfingstsonntag', en: 'Pentecost Sunday'}, e: 49, type: 'rel-0'},
{name: {de: 'Pfingstmontag', en: 'Pentecost Monday'}, e: 50, holiday: ['AT', 'CH', 'DE', 'LI'], type: 'rel-0'},
{name: 'Dreifaltigkeitsfest', e: 56, type: 'rel-2'},
{name: {de: 'Fronleichnam', en: 'Corpus Christi'}, e: 60, holiday: ['AT', 'DE-BW', 'DE-BY', 'DE-HE', 'DE-NW', 'DE-RP', 'DE-SL', 'DE-SN-XF', 'DE-TH-XF', 'LI'], type: 'rel-1'},
{name: 'Herz-Jesu-Fest', e: 68, type: 'rel-2'},
{name: 'Unbeflecktes Herz Mariä', e: 69, type: 'rel-3'},
//April
{name: 'Franz von Paola', d: 2, m: 4, type: 'rel-3'},
{name: 'Richard von Chichester', d: 3, m: 4, type: 'rel-3'},
{name: 'Isidor von Sevilla, Benedikt der Mohr', d: 4, m: 4, type: 'rel-3'},
{name: 'Maria Creszentia Höss, Vinzenz Ferrer, Juliana von Lüttich', d: 5, m: 4, type: 'rel-3'},
{name: 'Internationaler Tag des Sports', d: 6, m: 4, type: 'sec-2'},
{name: 'Johann Baptist de la Salle', d: 7, m: 4, type: 'rel-3'},
{name: 'Weltgesundheitstag', d: 7, m: 4, type: 'sec-2'},
{name: 'Walter von Pontoise, Beate', d: 8, m: 4, type: 'rel-3'},
{name: 'Waltraud von Mons', d: 9, m: 4, type: 'rel-3'},
{name: 'Eberwin von Helfenstein', d: 10, m: 4, type: 'rel-3'},
{name: 'Stanislaus von Krakau', d: 11, m: 4, type: 'rel-3'},
{name: 'Julius I.', d: 12, m: 4, type: 'rel-3'},
{name: 'Martin I.', d: 13, m: 4, type: 'rel-3'},
{name: 'Tiburtius von Rom', d: 14, m: 4, type: 'rel-3'},
{name: 'Bernadette Soubirous', d: 16, m: 4, type: 'rel-3'},
{name: 'Kateri Tekakwitha', d: 17, m: 4, type: 'rel-3'},
{name: 'Leo IX., Sel. Marcel Callo', d: 19, m: 4, type: 'rel-3'},
{name: 'Hildegunde von Schönau', d: 20, m: 4, type: 'rel-3'},
{name: 'Anselm von Canterbury, Konrad von Parzham', d: 21, m: 4, type: 'rel-3'},
{name: 'Agapitus I.', d: 22, m: 4, type: 'rel-3'},
{name: 'Tag der Erde', d: 22, m: 4, type: 'sec-2'},
{name: 'Georg', d: 23, m: 4, type: 'rel-2'},
{name: 'Adalbert von Prag, Ibar von Beggerin', d: 23, m: 4, type: 'rel-3'},
{name: 'Welttag des Buches', d: 23, m: 4, type: 'sec-3'},
{name: 'Robert von Turlande, Fidelis von Sigmaringen', d: 24, m: 4, type: 'rel-3'},
{name: 'Markus, der Evangelist, Anianus von Alexandria', d: 25, m: 4, type: 'rel-3'},
{name: 'Johannes von Valence, Cletus', d: 26, m: 4, type: 'rel-3'},
{name: 'Petrus Armengol, Petrus Canisius', d: 27, m: 4, type: 'rel-3'},
{name: 'Pierre Chanel, Ludwig Maria Grignion de Montfort', d: 28, m: 4, type: 'rel-3'},
{name: 'Katharina von Siena, Hugo von Cluny', d: 29, m: 4, type: 'rel-3'},
{name: 'Pius V., Josef Benedikt Cottolengo', d: 30, m: 4, type: 'rel-3'},
//Mai
{name: {de: 'Maifeiertag', en: 'International Workers’ Day'}, d: 1, m: 5, holiday: ['AT', 'DE', 'LI'], type: 'sec-0'},
{name: 'Josef der Arbeiter', d: 1, m: 5, type: 'rel-3'},
{name: 'Athanasius der Große, Wiborada', d: 2, m: 5, type: 'rel-3'},
{name: 'Apostel Philippus, Jakobus der Gerechte, Jakobus der Jüngere', d: 3, m: 5, type: 'rel-3'},
{name: 'Welttag der Pressefreiheit', d: 3, m: 5, type: 'sec-2'},
{name: 'Florian, Guido von Pomposa', d: 4, m: 5, type: 'rel-3'},
{name: 'Godehard von Hildesheim', d: 5, m: 5, type: 'rel-3'},
{name: {de: 'Muttertag', en: 'Mother’s Day'}, d: 8, m: 5, w: 0, type: 'sec-0'},
{name: 'Tag der Befreiung', d: 8, m: 5, type: 'sec-2'},
{name: 'Europatag', d: 9, m: 5, type: 'sec-1'},
{name: 'Damian de Veuster, Gordianus', d: 10, m: 5, type: 'rel-3'},
{name: 'Mamertus', d: 11, m: 5, type: 'rel-3'},
{name: 'Nereus, Achilleus, Pankratius, Álvaro del Portillo', d: 12, m: 5, type: 'rel-3'},
{name: 'Unsere Liebe Frau in Fátima, Servatius', d: 13, m: 5, type: 'rel-3'},
{name: 'Bonifatius', d: 14, m: 5, type: 'rel-3'},
{name: 'Sophia von Rom', d: 15, m: 5, type: 'rel-3'},
{name: 'Internationaler Tag der Familie', d: 15, m: 5, type: 'sec-2'},
{name: 'Honorius von Amiens, Johannes Nepomuk', d: 16, m: 5, type: 'rel-3'},
{name: 'Welttag der Telekommunikation', d: 17, m: 5, type: 'sec-2'},
{name: 'Johannes I., Erik', d: 18, m: 5, type: 'rel-3'},
{name: 'Internationaler Museumstag', d: 18, m: 5, type: 'sec-2'},
{name: 'Alkuin, Maria Bernarda Bütler', d: 19, m: 5, type: 'rel-3'},
{name: 'Bernhardin von Siena', d: 20, m: 5, type: 'rel-3'},
{name: 'Konstantin, Eugen von Mazenod, Hermann Joseph von Steinfeld, Christophorus Magallanes', d: 21, m: 5, type: 'rel-3'},
{name: 'Rita von Cascia, Julia von Korsika', d: 22, m: 5, type: 'rel-3'},
{name: 'Tag des Grundgesetzes', d: 23, m: 5, region: ['DE'], type: 'sec-1'},
{name: 'Königin Ester', d: 24, m: 5, type: 'rel-3'},
{name: 'Sara, die Dienerin, Urban I., Beda Venerabilis, Gregor VII., Maria Magdalena de Pazzi', d: 25, m: 5, type: 'rel-3'},
{name: 'Philipp Neri', d: 26, m: 5, type: 'rel-3'},
{name: 'Augustinus', d: 27, m: 5, type: 'rel-3'},
{name: 'Jeanne d’Arc, Zdislava', d: 30, m: 5, type: 'rel-3'},
{name: 'Petronilla', d: 31, m: 5, type: 'rel-3'},
//Juni
{name: 'Simeon von Trier, Fortunatus von Todi, Justin', d: 1, m: 6, type: 'rel-3'},
{name: 'Marcellinus, Petrus', d: 2, m: 6, type: 'rel-3'},
{name: 'Karl Lwanga', d: 3, m: 6, type: 'rel-3'},
{name: 'Bonifatius, Adalar', d: 5, m: 6, type: 'rel-3'},
{name: 'Tag der Umwelt', d: 5, m: 6, type: 'sec-2'},
{name: 'Norbert von Xanten, Kevin von Glendalough', d: 6, m: 6, type: 'rel-3'},
{name: 'Robert of Newminster', d: 7, m: 6, type: 'rel-3'},
{name: 'Medardus von Vermandois', d: 8, m: 6, type: 'rel-3'},
{name: 'Tag der Ozeane', d: 8, m: 6, type: 'sec-2'},
{name: 'Columban von Iona, Ephräm der Syrer', d: 9, m: 6, type: 'rel-3'},
{name: 'Barnabas', d: 11, m: 6, type: 'rel-3'},
{name: 'Odulf von Utrecht, Basilides und Gefährten', d: 12, m: 6, type: 'rel-3'},
{name: 'Antonius von Padua', d: 13, m: 6, type: 'rel-3'},
{name: 'Elischa', d: 14, m: 6, type: 'rel-3'},
{name: 'Vitus', d: 15, m: 6, type: 'rel-3'},
{name: 'Benno von Meißen', d: 16, m: 6, type: 'rel-3'},
{name: 'Gedenktag an den Volksaufstand in der DDR', d: 17, m: 6, region: ['DE'], type: 'sec-1'},
{name: 'Romuald', d: 19, m: 6, type: 'rel-3'},
{name: 'Weltflüchtlingstag', d: 20, m: 6, type: 'sec-1'},
{name: 'Aloisius von Gonzaga', d: 21, m: 6, type: 'rel-3'},
{name: 'Thomas Morus, Aaron von Caerleon, Paulinus, John Fisher', d: 22, m: 6, type: 'rel-3'},
{name: 'Geburt Johannes’ des Täufers', d: 24, m: 6, type: 'rel-2'},
{name: 'Josemaría Escrivá de Balaguer y Albás', d: 26, m: 6, type: 'rel-3'},
{name: 'Kyrill von Alexandria, Hemma von Gurk', d: 27, m: 6, type: 'rel-3'},
{name: 'Irenäus von Lyon', d: 28, m: 6, type: 'rel-3'},
{name: 'Petrus und Paulus', d: 29, m: 6, type: 'rel-2'},
{name: 'Otto von Bamberg, Märtyrer von Rom', d: 30, m: 6, type: 'rel-3'},
//Juli
{name: 'Theoderich von Reims', d: 1, m: 7, type: 'rel-3'},
{name: 'Mariä Heimsuchung, Peter von Luxemburg', d: 2, m: 7, type: 'rel-3'},
{name: 'Thomas, Leo II.', d: 3, m: 7, type: 'rel-3'},
{name: 'Ulrich, Ulrich von Augsburg, Elisabeth von Portugal', d: 4, m: 7, type: 'rel-3'},
{name: 'Antonio Maria Zaccaria', d: 5, m: 7, type: 'rel-3'},
{name: 'Goar, Maria Goretti', d: 6, m: 7, type: 'rel-3'},
{name: 'Hedda von Wessex, Willibald', d: 7, m: 7, type: 'rel-3'},
{name: 'Kilian', d: 8, m: 7, type: 'rel-3'},
{name: 'Augustinus Zhao Rong', d: 9, m: 7, type: 'rel-3'},
{name: 'Olav, Erik, Alexander, Knud', d: 10, m: 7, type: 'rel-3'},
{name: 'Benedikt von Nursia, Oliver', d: 11, m: 7, type: 'rel-3'},
{name: 'Ansbald von Prüm, Johannes Gualbertus', d: 12, m: 7, type: 'rel-3'},
{name: 'Sara die Einsiedlerin, Heinrich und Kunigunde und Clelia Barbieri', d: 13, m: 7, type: 'rel-3'},
{name: 'Kamillus von Lellis', d: 14, m: 7, type: 'rel-3'},
{name: 'Bonaventura von Bagnoregio, Rosalia', d: 15, m: 7, type: 'rel-3'},
{name: 'Unsere Liebe Frau auf dem Berge Karmel, Maria Magdalena Postel', d: 16, m: 7, type: 'rel-3'},
{name: 'Charlotte Thouret', d: 17, m: 7, type: 'rel-3'},
{name: 'Arnold von Arnoldsweiler', d: 18, m: 7, type: 'rel-3'},
{name: 'Apollinaris, Margareta', d: 20, m: 7, type: 'rel-3'},
{name: 'Gedenktag zum Attentat vom 20. Juli 1944', d: 20, m: 7, region: ['DE'], type: 'sec-1'},
{name: 'Laurentius von Brindisi', d: 21, m: 7, type: 'rel-3'},
{name: 'Maria Magdalena', d: 22, m: 7, type: 'rel-3'},
{name: 'Birgitta von Schweden', d: 23, m: 7, type: 'rel-3'},
{name: 'Christophorus, Christina von Bolsena, Christina die Wunderbare, Scharbel Machluf', d: 24, m: 7, type: 'rel-3'},
{name: 'Jakobus der Ältere', d: 25, m: 7, type: 'rel-3'},
{name: 'Anna, Joachim', d: 26, m: 7, type: 'rel-3'},
{name: 'Berthold von Garsten', d: 27, m: 7, type: 'rel-3'},
{name: 'Timon', d: 28, m: 7, type: 'rel-3'},
{name: 'Beatrix von Rom, Olav, Marta von Betanien', d: 29, m: 7, type: 'rel-3'},
{name: 'Abdon und Sennen, Petrus Chysologus', d: 30, m: 7, type: 'rel-3'},
{name: 'Ignatius von Loyola', d: 31, m: 7, type: 'rel-3'},
//August
{name: 'Bundesfeiertag', d: 1, m: 8, holiday: ['CH'], type: 'nat-0'},
{name: 'Alfons Maria von Liguori', d: 1, m: 8, type: 'rel-3'},
{name: 'Eusebius, Pierre-Julien Eymard', d: 2, m: 8, type: 'rel-3'},
{name: 'Lydia', d: 3, m: 8, type: 'rel-3'},
{name: 'Agricola von Bologna, Pfarrer von Ars', d: 4, m: 8, type: 'rel-3'},
{name: 'Oswald (Northumbria), Weihetag von Santa Maria Maggiore', d: 5, m: 8, type: 'rel-3'},
{name: 'Verklärung des Herrn', d: 6, m: 8, type: 'rel-3'},
{name: 'Afra von Augsburg, Albertus Siculus, Xystus II., Kajetan von Thiene', d: 7, m: 8, type: 'rel-3'},
{name: 'Augsburger Friedensfest', d: 8, m: 8, holiday: ['DE-BY-XA'], type: 'special-0'},
{name: 'Dominikus, Cyriacus', d: 8, m: 8, type: 'rel-3'},
{name: 'Teresia Benedicta vom Kreuz (Edith Stein)', d: 9, m: 8, type: 'rel-3'},
{name: 'Laurentius von Rom', d: 10, m: 8, type: 'rel-3'},
{name: 'Klara von Assisi, Susanna', d: 11, m: 8, type: 'rel-3'},
{name: 'Johanna Franziska von Chantal', d: 12, m: 8, type: 'rel-3'},
{name: 'Internationaler Tag der Jugend', d: 12, m: 8, type: 'sec-2'},
{name: 'Kassian, Pontianus, Hippolyt', d: 13, m: 8, type: 'rel-3'},
{name: 'Maximilian Kolbe', d: 14, m: 8, type: 'rel-3'},
{name: {de: 'Mariä Himmelfahrt', en: 'Assumption of Mary'}, d: 15, m: 8, holiday: ['AT', 'DE-BY', 'LI'], type: 'rel-1'},
{name: 'Stephan I.', d: 16, m: 8, type: 'rel-3'},
{name: 'Altfrid', d: 17, m: 8, type: 'rel-3'},
{name: 'Helena', d: 18, m: 8, type: 'rel-3'},
{name: 'Sebaldus von Nürnberg, Johannes Eudes', d: 19, m: 8, type: 'rel-3'},
{name: 'Bernhard von Clairvaux', d: 20, m: 8, type: 'rel-3'},
{name: 'Pius X.', d: 21, m: 8, type: 'rel-3'},
{name: 'Maria Königin', d: 22, m: 8, type: 'rel-3'},
{name: 'Rosa von Lima, Kallinikos I.', d: 23, m: 8, type: 'rel-3'},
{name: 'Bartholomäus', d: 24, m: 8, type: 'rel-3'},
{name: 'Ludwig IX., Mirjam von Abellin, Josef von Calasanza', d: 25, m: 8, type: 'rel-3'},
{name: 'Johanna Elisabeth Bichier des Ages', d: 26, m: 8, type: 'rel-3'},
{name: 'Monika, Mutter von Augustinus von Hippo', d: 27, m: 8, type: 'rel-3'},
{name: 'Augustinus von Hippo', d: 28, m: 8, type: 'rel-3'},
{name: 'Enthauptung Johannes’ des Täufers, Sabina', d: 29, m: 8, type: 'rel-3'},
{name: 'Nikodemus, Paulinus', d: 31, m: 8, type: 'rel-3'},
//September
{name: 'Ägidius, Josua', d: 1, m: 9, type: 'rel-3'},
{name: 'Ingrid Elovsdotter', d: 2, m: 9, type: 'rel-3'},
{name: 'Gregor der Große', d: 3, m: 9, type: 'rel-3'},
{name: 'Rosalia', d: 4, m: 9, type: 'rel-3'},
{name: 'Magnus von Füssen', d: 6, m: 9, type: 'rel-3'},
{name: 'Ralph Corbie, Regina', d: 7, m: 9, type: 'rel-3'},
{name: 'Tag des offenen Denkmals', d: 8, m: 9, w: 0, type: 'sec-1'},
{name: 'Mariä Geburt', d: 8, m: 9, holiday: ['LI'], type: 'rel-2'},
{name: 'Petrus Claver', d: 9, m: 9, type: 'rel-3'},
{name: 'Mariä Namen', d: 12, m: 9, type: 'rel-3'},
{name: 'Johannes Chrysostomos', d: 13, m: 9, type: 'rel-3'},
{name: 'Kreuzerhöhung', d: 14, m: 9, type: 'rel-3'},
{name: 'Gedächtnis der Schmerzen Mariens, Oranna, Katharina von Genua', d: 15, m: 9, type: 'rel-3'},
{name: 'Cornelius, Cyprian', d: 16, m: 9, type: 'rel-3'},
{name: 'Hildegard von Bingen, Robert Bellarmin', d: 17, m: 9, type: 'rel-3'},
{name: 'Lambertus', d: 18, m: 9, type: 'rel-3'},
{name: 'Januarius', d: 19, m: 9, type: 'rel-3'},
{name: 'Andreas Kim Taegon, Paul Chong Hasang und seine Gefährten', d: 20, m: 9, type: 'rel-3'},
{name: 'Matthäus', d: 21, m: 9, type: 'rel-3'},
{name: 'Internationaler Friedenstag', d: 21, m: 9, type: 'sec-2'},
{name: 'Mauritius, Otto von Freising', d: 22, m: 9, type: 'rel-3'},
{name: 'Pio von Pietrelcina, Linus (Papst), Elisabeth, Mutter Johannes des Täufers', d: 23, m: 9, type: 'rel-3'},
{name: 'Rupert, Virgil', d: 24, m: 9, type: 'rel-3'},
{name: 'Niklaus von Flüe, Firmin der Ältere von Amiens', d: 25, m: 9, type: 'rel-3'},
{name: 'Paul VI., Kosmas und Damian', d: 26, m: 9, type: 'rel-3'},
{name: 'Vinzenz von Paul', d: 27, m: 9, type: 'rel-3'},
{name: 'Bernhardin von Feltre, Wenzel, Lorenzo Ruiz, Lioba', d: 28, m: 9, type: 'rel-3'},
{name: 'Erzengel Michael, Raphael und Gabriel', d: 29, m: 9, type: 'rel-3'},
{name: 'Hieronymus', d: 30, m: 9, type: 'rel-3'},
//Oktober
{name: {de: 'Erntedank', en: 'Harvest festival'}, d: 1, m: 10, w: 0, type: 'rel-1'},
{name: 'Therese von Lisieux', d: 1, m: 10, type: 'rel-3'},
{name: 'Schutzengel', d: 2, m: 10, type: 'rel-3'},
{name: 'Tag der Deutschen Einheit', d: 3, m: 10, y: 1990, holiday: ['DE'], type: 'nat-0'},
{name: 'Dionysios der Areopagit', d: 3, m: 10, type: 'rel-3'},
{name: 'Franz von Assisi', d: 4, m: 10, type: 'rel-3'},
{name: 'Welttierschutztag', d: 4, m: 10, type: 'sec-2'},
{name: 'Maria Faustyna Kowalska, Termelines/Timerlin', d: 5, m: 10, type: 'rel-3'},
{name: 'Bruno der Kartäuser', d: 6, m: 10, type: 'rel-3'},
{name: 'Unsere Liebe Frau vom Rosenkranz', d: 7, m: 10, type: 'rel-3'},
{name: 'Birgitta von Schweden', d: 8, m: 10, type: 'rel-3'},
{name: 'Dionysius (Denis) von Paris, Johannes Leonardi', d: 9, m: 10, type: 'rel-3'},
{name: 'Johannes XXIII.', d: 11, m: 10, type: 'rel-3'},
{name: 'Maximilian vom Pongau', d: 12, m: 10, type: 'rel-3'},
{name: 'Koloman', d: 13, m: 10, type: 'rel-3'},
{name: 'Burkard von Würzburg, Kallistus I.', d: 14, m: 10, type: 'rel-3'},
{name: 'Teresa von Ávila, Thekla von Kitzingen', d: 15, m: 10, type: 'rel-3'},
{name: 'Margareta Maria Alacoque, Hedwig von Andechs, Gallus', d: 16, m: 10, type: 'rel-3'},
{name: 'Ignatius von Antiochien', d: 17, m: 10, type: 'rel-3'},
{name: 'Lukas, der Evangelist', d: 18, m: 10, type: 'rel-3'},
{name: 'Jean de Brébeuf, Isaak Jogues und Gefährten, Paul vom Kreuz', d: 19, m: 10, type: 'rel-3'},
{name: 'Wendelin', d: 20, m: 10, type: 'rel-3'},
{name: 'John of Bridlington, Ursula von Köln, Sel. Karl I.', d: 21, m: 10, type: 'rel-3'},
{name: 'Johannes Paul II.', d: 22, m: 10, type: 'rel-3'},
{name: 'Jakobus der Gerechte, Severin von Köln, Johannes von Capestrano', d: 23, m: 10, type: 'rel-3'},
{name: 'Antonius Maria Claret, Everigisil', d: 24, m: 10, type: 'rel-3'},
{name: 'Tag der Vereinten Nationen', d: 24, m: 10, type: 'sec-2'},
{name: {de: 'Ende der Sommerzeit', en: 'End of (European) daylight saving time'}, d: 25, m: 10, w: 0, type: 'sec-0'},
{name: 'Crispinus und Crispinianus, Krispin', d: 25, m: 10, type: 'rel-3'},
{name: 'Nationalfeiertag', d: 26, m: 10, holiday: ['AT'], type: 'nat-0'},
{name: 'Wigand (Einsiedler)', d: 26, m: 10, type: 'rel-3'},
{name: 'Gaudiosus', d: 27, m: 10, type: 'rel-3'},
{name: 'Judas Thaddäus, Simon Zelotes', d: 28, m: 10, type: 'rel-3'},
{name: 'Beda Venerabilis', d: 29, m: 10, type: 'rel-3'},
{name: 'Bernhard Schwentner', d: 30, m: 10, type: 'rel-3'},
{name: {de: 'Reformationstag', en: 'Reformation Day'}, d: 31, m: 10, Y: 2016, holiday: ['DE-BB', 'DE-MV', 'DE-SN', 'DE-ST', 'DE-TH'], type: 'rel-0'},
{name: {de: 'Reformationstag', en: 'Reformation Day'}, d: 31, m: 10, y: 2017, Y: 2017, holiday: ['DE'], type: 'rel-0'},
{name: {de: 'Reformationstag', en: 'Reformation Day'}, d: 31, m: 10, y: 2018, holiday: ['DE-BB', 'DE-MV', 'DE-SN', 'DE-ST', 'DE-TH'], type: 'rel-0'},
{name: 'Wolfgang von Regensburg', d: 31, m: 10, type: 'rel-3'},
//November
{name: {de: 'Allerheiligen', en: 'All Saints’ Day'}, d: 1, m: 11, holiday: ['AT', 'DE-BW', 'DE-BY', 'DE-NW', 'DE-RP', 'DE-SL', 'LI'], type: 'rel-1'},
{name: {de: 'Allerseelen', en: 'All Souls’ Day'}, d: 2, m: 11, type: 'rel-1'},
{name: 'Hubertus, Pirminius, Malachias, Martin von Porres, Sel. Rupert Mayer', d: 3, m: 11, type: 'rel-3'},
{name: 'Karl Borromäus', d: 4, m: 11, type: 'rel-3'},
{name: 'sel. Bernhard Lichtenberg', d: 5, m: 11, type: 'rel-3'},
{name: 'Leonhard von Limoges', d: 6, m: 11, type: 'rel-3'},
{name: 'Ernst von Neresheim, Willibrord', d: 7, m: 11, type: 'rel-3'},
{name: 'Willehad', d: 8, m: 11, type: 'rel-3'},
{name: 'Theodor Stratelates, Weihetag der Lateranbasilika', d: 9, m: 11, type: 'rel-3'},
{name: 'Leo der Große', d: 10, m: 11, type: 'rel-3'},
{name: 'Martin', d: 11, m: 11, type: 'rel-1'},
{name: 'Theodor Studites', d: 11, m: 11, type: 'rel-3'},
{name: 'Kunibert von Köln, Josaphat', d: 12, m: 11, type: 'rel-3'},
{name: 'Volkstrauertag', d: 13, m: 11, w: 0, region: ['DE'], type: 'sec-1'},
{name: 'Stanislaus Kostka, Brictius von Tours, Didakus', d: 13, m: 11, type: 'rel-3'},
{name: 'Albert der Große, Leopold von Österreich', d: 15, m: 11, type: 'rel-3'},
{name: {'de-CH': 'Buss- und Bettag', en: 'Buß- und Bettag'}, d: 16, m: 11, w: 3, holiday: ['DE-SN'], type: 'rel-1'},
{name: 'Eucherius von Lyon, Margareta', d: 16, m: 11, type: 'rel-3'},
{name: 'Gertrud von Helfta, Gregor von Tours, Hilda von Whitby', d: 17, m: 11, type: 'rel-3'},
{name: 'Weihetag der Basiliken St. Peter und St. Paul', d: 18, m: 11, type: 'rel-3'},
{name: 'Elisabeth von Thüringen', d: 19, m: 11, type: 'rel-3'},
{name: {de: 'Christkönig', en: 'Feast of Christ the King'}, d: 20, m: 11, w: 0, type: 'rel-1'},
{name: 'Bernward von Hildesheim, Korbinian', d: 20, m: 11, type: 'rel-3'},
{name: 'Unsere Liebe Frau in Jerusalem', d: 21, m: 11, type: 'rel-3'},
{name: 'Cäcilia, Philemon und sel. Salvator Lilli', d: 22, m: 11, type: 'rel-3'},
{name: 'Clemens, Kolumban von Luxeuil', d: 23, m: 11, type: 'rel-3'},
{name: 'Andreas Dung-Lac', d: 24, m: 11, type: 'rel-3'},
{name: 'Katharina von Alexandrien', d: 25, m: 11, type: 'rel-3'},
{name: 'Stylian, Konrad von Konstanz, Gebhard', d: 26, m: 11, type: 'rel-3'},
{name: {de: '1. Adventssonntag', 'de-AT': '1. Adventsonntag', en: '1. Advent Sunday'}, d: 27, m: 11, w: 0, type: 'rel-0'},
{name: 'Josaphat von Indien', d: 27, m: 11, type: 'rel-3'},
{name: 'Apostel Andreas', d: 30, m: 11, type: 'rel-3'},
//Dezember
{name: 'Blanka von Kastilien, Eligius', d: 1, m: 12, type: 'rel-3'},
{name: 'Welt-AIDS-Tag', d: 1, m: 12, type: 'sec-2'},
{name: 'Bibiana, Luzius', d: 2, m: 12, type: 'rel-3'},
{name: 'Franz Xaver', d: 3, m: 12, type: 'rel-3'},
{name: {de: '2. Adventssonntag', 'de-AT': '2. Adventsonntag', en: '2. Advent Sunday'}, d: 4, m: 12, w: 0, type: 'rel-0'},
{name: 'Barbara', d: 4, m: 12, type: 'rel-1'},
{name: 'Anno II. von Köln, Christian von Oliva, Johannes von Damaskus, Sel. Adolph Kolping', d: 4, m: 12, type: 'rel-3'},
{name: 'Anno', d: 5, m: 12, type: 'rel-3'},
{name: 'Nikolaus', d: 6, m: 12, type: 'rel-1'},
{name: 'Henrika und Gefährtinnen', d: 6, m: 12, type: 'rel-3'},
{name: 'Ambrosius von Mailand', d: 7, m: 12, type: 'rel-3'},
{name: {de: 'Mariä Empfängnis', en: 'Immaculate Conception'}, d: 8, m: 12, holiday: ['AT', 'LI'], type: 'rel-1'},
{name: 'Pierre Fourier, Juan Diego Cuauhtlatoatzin', d: 9, m: 12, type: 'rel-3'},
{name: 'Tag der Menschenrechte', d: 10, m: 12, type: 'sec-2'},
{name: {de: '3. Adventssonntag', 'de-AT': '3. Adventsonntag', en: '3. Advent Sunday'}, d: 11, m: 12, w: 0, type: 'rel-0'},
{name: 'Damasus I.', d: 11, m: 12, type: 'rel-3'},
{name: 'Unsere Liebe Frau von Guadalupe, Vizelin von Oldenburg', d: 12, m: 12, type: 'rel-3'},
{name: 'Lucia von Syrakus, Odilia,', d: 13, m: 12, type: 'rel-3'},
{name: 'Berthold von Regensburg, Johannes vom Kreuz', d: 14, m: 12, type: 'rel-3'},
{name: 'Ado von Vienne', d: 16, m: 12, type: 'rel-3'},
{name: 'Sturmius, Ignatius von Antiochia, Olympias von Konstantinopel', d: 17, m: 12, type: 'rel-3'},
{name: {de: '4. Adventssonntag', 'de-AT': '4. Adventsonntag', en: '4. Advent Sunday'}, d: 18, m: 12, w: 0, type: 'rel-0'},
{name: 'Thomas (Apostel), Petrus Kanisius', d: 21, m: 12, type: 'rel-3'},
{name: 'Johannes von Krakau', d: 23, m: 12, type: 'rel-3'},
{name: {de: 'Heiligabend', en: 'Christmas Eve'}, d: 24, m: 12, type: 'rel-0'},
{name: 'Tarsilla, Delphin, Adam und Eva', d: 24, m: 12, type: 'rel-3'},
{name: {de: '1. Weihnachtsfeiertag', en: 'Christmas Day'}, d: 25, m: 12, holiday: ['AT', 'CH', 'DE', 'LI'], type: 'rel-0'},
{name: {de: '2. Weihnachtsfeiertag', en: 'Boxing Day'}, d: 26, m: 12, holiday: ['AT', 'CH', 'DE', 'LI'], type: 'rel-0'},
{name: 'Stephanus', d: 26, m: 12, type: 'rel-3'},
{name: 'Apostel Johannes', d: 27, m: 12, type: 'rel-3'},
{name: 'Unschuldige Kinder', d: 28, m: 12, type: 'rel-3'},
{name: 'Lothar I., Thomas Becket', d: 29, m: 12, type: 'rel-3'},
{name: 'Silvester I., Catherine Labouré, Melanie die Ältere', d: 31, m: 12, type: 'rel-3'},
//Islam
{name: 'Islamisches Neujahr', d: 1, m: 1, islamic: true, type: 'rel-2'},
{name: 'Aschura', d: 10, m: 1, islamic: true, type: 'rel-3'},
{name: 'Geburtstag des Propheten', d: 12, m: 3, islamic: true, type: 'rel-3'},
{name: 'Beginn des Ramadan', d: 1, m: 9, islamic: true, type: 'rel-2'},
{name: 'Fest des Fastenbrechens', d: 1, m: 10, islamic: true, type: 'rel-2'},
{name: 'Islamisches Opferfest', d: 10, m: 12, islamic: true, type: 'rel-2'},
//Jüdisch
{name: 'Rosch ha-Schana', d: 1, m: 1, jewish: true, type: 'rel-2'},
{name: 'Jom Kippur', d: 10, m: 1, jewish: true, type: 'rel-2'},
{name: 'Sukkot', d: 15, m: 1, jewish: true, type: 'rel-2'},
{name: 'Chanukka', d: 25, m: 3, jewish: true, type: 'rel-2'},
{name: 'Purim', d: 14, m: 6, jewish: true, type: 'rel-2'},
{name: 'Pessach', d: 15, m: 7, jewish: true, type: 'rel-2'}
],
shiftIslamic: {
	//abgeleitet aus Daten des KRM
	'DE': {
		'20131101': -1,
		'20150101': 0,
		'20150701': -1,
		'20150901': 0,
		'20151001': -1,
		'20160701': -2,
		'20160901': -1,
		'20161201': 0,
		'20170601': -1,
		'20171101': 0,
		'20180801': -1,
		'20190501': 0,
		'20190801': -1
	}
},
languages: {
	'de': 'Deutsch',
	'de-AT': 'Deutsch (Österreich)',
	'de-CH': 'Deutsch (Schweiz)',
	'en': 'English'
},
regions: { //ISO 3166-2
	'AT': 'Österreich',
	'CH': 'Schweiz',
	'DE': 'Deutschland',
	'DE-BW': 'D, Baden-Württemberg',
	'DE-BY': 'D, Bayern',
	'DE-BY-XA': 'D, BY, Augsburg',
	'DE-BE': 'D, Berlin',
	'DE-BB': 'D, Brandenburg',
	'DE-HB': 'D, Bremen',
	'DE-HH': 'D, Hamburg',
	'DE-HE': 'D, Hessen',
	'DE-MV': 'D, Mecklenburg-Vorpommern',
	'DE-NI': 'D, Niedersachsen',
	'DE-NW': 'D, Nordrhein-Westfalen',
	'DE-RP': 'D, Rheinland-Pfalz',
	'DE-SL': 'D, Saarland',
	'DE-SN': 'D, Sachsen',
	'DE-SN-XF': 'D, SN, mit Fronleichnam',
	'DE-ST': 'D, Sachsen-Anhalt',
	'DE-SH': 'D, Schleswig-Holstein',
	'DE-TH': 'D, Thüringen',
	'DE-TH-XF': 'D, TH, mit Fronleichnam',
	'LI': 'Liechtenstein'
},
types: {
	sec: {de: 'Säkulare Gedenk- und Feiertage', en: 'Secular holidays and commemorative days'}, //0: Tage, die in jedem Kalender stehen sollten, 1: weitere wichtige Tage, z. B. Beflaggungstage, 2: einigermaßen bekannte Gedenk- und Aktionstage, 3: obskure Gedenken- und Aktionstage
	rel: {de: 'Religiöse Gedenk- und Feiertage', en: 'Religious holidays and commemorative days'} //0: Tage, die in jedem Kalender stehen sollten, 1: weitere wichtige Tage, z. B. mit verbreitetem Brauchtum, 2: Hochfeste, bekannte Heilige, wichtige islamische/jüdische Feiertage, 3: Heiligengedenktage, sonstige religiöse Feiertage
	//nat: Nationalfeiertag
	//special: spezieller Feiertag
},
languageFallback: {
	en: 'de'
},
libraries: {
	'<a href="https://www.wikipedia.org" target="_blank">Wikipedia</a>': {de: 'die Daten', en: 'the data'},
	'<a href="http://agafonkin.com/en" target="_blank">Vladimir Agafonkin</a>': '<a href="https://github.com/mourner/suncalc" target="_blank">suncalc</a>',
	'<a href="https://github.com/ryanseys" target="_blank">Ryan Seys</a>': '<a href="https://github.com/ryanseys/lune" target="_blank">lune</a>',
	'<a href="https://commons.wikimedia.org/wiki/User:JayTanner/lunar-near-side-phase-set" target="_blank">Jay Tanner</a>': {de: 'die Bilder vom Mond (<a href="http://creativecommons.org/licenses/by-sa/3.0/legalcode" target="_blank">CC-BY-SA</a>)', en: 'the images of the moon (<a href="http://creativecommons.org/licenses/by-sa/3.0/legalcode" target="_blank">CC-BY-SA</a>)'}
},
l10n: {
	months: {
		de: ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'],
		'de-AT': ['Jänner', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'],
		en: ['January', 'February', 'March', 'April', 'Mai', 'June', 'July', 'August', 'September', 'October', 'November', 'December']
	},
	days: {
		de: ['Sonntag', 'Montag', 'Dienstag', 'Mittwoch', 'Donnerstag', 'Freitag', 'Samstag'],
		en: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday']
	},
	daysShort: {
		de: ['So', 'Mo', 'Di', 'Mi', 'Do', 'Fr', 'Sa'],
		en: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa']
	},
	riseSet: {
		de: {sunRise: 'Sonnenaufgang: ', sunSet: 'Sonnenuntergang: ', moonRise: 'Mondaufgang: ', moonSet: 'Monduntergang: '},
		en: {sunRise: 'Sunrise: ', sunSet: 'Sunset: ', moonRise: 'Moonrise: ', moonSet: 'Moonset: '}
	},
	moonData: {
		de: {
			'new': 'Neumond', waxing: 'Zunehmender Mond', full: 'Vollmond', waning: 'Abnehmender Mond',
			Pisces: '♓ Fische', Aries: '♈ Widder', Taurus: '♉ Stier', Gemini: '♊ Zwillinge',
			Cancer: '♋ Krebs', Leo: '♌ Löwe', Virgo: '♍ Jungfrau', Libra: '♎ Waage',
			Scorpio: '♏ Skorpion', Sagittarius: '♐ Schütze', Capricorn: '♑ Steinbock', Aquarius: '♒ Wassermann',
			from: 'ab', zodiac: ' im Zeichen '
		},
		en: {
			'new': 'New moon', waxing: 'Waxing moon', full: 'Full moon', waning: 'Waning moon',
			Pisces: '♓ Pisces', Aries: '♈ Aries', Taurus: '♉ Taurus', Gemini: '♊ Gemini',
			Cancer: '♋ Cancer', Leo: '♌ Leo', Virgo: '♍ Virgo', Libra: '♎ Libra',
			Scorpio: '♏ Scorpio', Sagittarius: '♐ Sagittarius', Capricorn: '♑ Capricorn', Aquarius: '♒ Aquarius',
			from: 'from', zodiac: ' in '
		}
	},
	navigation: {
		de: {
			month: 'Monat', today: 'Heute', choose: 'Datum wählen'
		},
		en: {
			month: 'Month', today: 'Today', choose: 'Choose date'
		}
	},
	settings: {
		de: {
			lang: 'Sprache: ', region: 'Region: ', riseSet: 'Auf- und Untergangszeiten',
			lat: 'Länge: ', long: 'Breite: ', currentLocation: 'aktueller Ort',
			moon: 'Mond: ', none: 'keine Anzeige', phase: 'nur Mondphase', zodiac: 'auch Tierkreiszeichen',
			thanks: 'Dank an:', 'for': ' für ',
			heading: 'Konfiguration', save: 'Speichern', discard: 'Verwerfen',
			help: '<b>Benutzung</b> <ul> <li><b>Tagesansicht</b><ul> <li>Blättern durch Wischgesten nach links oder rechts</li> <li>Direktauswahl des Datums am unteren Bildschirmrand</li> </ul></li> <li><b>Monatsübersicht</b><ul> <li>Blättern durch Wischen nach links oder rechts</li> <li>Wechsel zur Tagesansicht durch Antippen des gewünschten Datums</li> </ul></li> <li><b>Suche</b><ul> <li>Starten über Lupensymbol am oberen Bildschirmrand</li> <li>unterscheidet nicht zwischen Groß- und Kleinschreibung</li> <li>wechselt in Tagesansicht zum nächsten passenden Datum</li> <li>beim Blättern werden nur passende Daten angezeigt</li> <li>in Monatsübersicht werden passende Daten hervorgehoben</li> </ul></li> <li><b>Konfiguration</b><ul> <li>Aufruf über Zahnradsymbol am oberen Bildschirmrand</li> <li>Sprache (inkl. österreichischem und Schweizer Deutsch)</li> <li>Region (für Anzeige der Feiertage)</li> <li>Feier- und Gedenktage in mehreren Stufen einstellbar</li> <li>optional: Ort für Auf- und Untergangszeiten von Sonne und Mond</li> <li>optional: Mondphase und Tierkreiszeichen, in dem der Mond sich befindet</li> </ul></li> </ul>', source: 'Diese App ist freie Software, ihr Quellcode kann auf <a href="https://github.com/Schnark/calender" target="_blank">Github</a> heruntergeladen werden. Diese Software wird ohne ausdrückliche oder implizierte Garantie bereitgestellt.'
		},
		en: {
			lang: 'Language: ', region: 'Region: ', riseSet: 'Times for rise and set',
			lat: 'Latitude: ', long: 'Longitude: ', currentLocation: 'current location',
			moon: 'Moon: ', none: 'none', phase: 'phase only', zodiac: 'including zodiac',
			thanks: 'Thanks to:', 'for': ' for ',
			heading: 'Configuration', save: 'Save', discard: 'Discard',
			help: '<b>Usage</b> <ul> <li><b>Day view</b><ul> <li>Browse by swiping left or right</li> <li>Select date with buttons at the end of the screen</li> </ul></li> <li><b>Month view</b><ul> <li>Browse by swiping left or right</li> <li>Change to day view by tapping the date</li> </ul></li> <li><b>Search</b><ul> <li>Start with the magnifying glass at the start of the screen</li> <li>Case insensitive</li> <li>In day view will show next matching date</li> <li>While browsing only matching dates are shown</li> <li>In month view matching dates are highlighted</li> </ul></li> <li><b>Configuration</b><ul> <li>Start with cog symbol at the start of the screen</li> <li>Language (including English)</li> <li>Region (for display of holidays)</li> <li>Holidays and commemorative days configurable in different stages</li> <li>Optional: location for times for sunrise, sunset, moonrise and moonset</li> <li>Optional: phase of the moon and sign of zodiac which it is in</li> </ul></li> </ul>', source: 'This app is free software, its source code can be downloaded from <a href="https://github.com/Schnark/calender" target="_blank">Github</a>. This software is provided \'as-is\', without any express or implied warranty.'
		}
	}
}
};