// mozAppsAccess.js

function canUseMozApps() {
	
	if (useMozApps() && isMozAppsAvailableNavigator()) {
		return true;
	} else {
		return false;
	}
}

function isMozAppsAvailableNavigator() {
	
	if('mozApps' in window.navigator) {
		return true;
	} else {
		return false;
	}
}


function isInstalled(installedCallback) {
	if (isMozAppsAvailableNavigator()) {
		var installed = getMozInstalled(installedCallback);
		if (typeof str == 'string' || str instanceof String) {
			return false;
		} else {
			return installed;
		}
		
	} else {
		return false;
	}
	
}



function getMozInstalled(installedCallback) {
	
    try {
		var request = window.navigator.mozApps.getInstalled();
		request.onerror = function(e) {
	    	var text = "getMozInstalled Error : " + this.error.name;
			//notify(text);
	    	installedCallback(text);
		};
		request.onsuccess = function(e) {
			//notify("Success, number of apps: " + this.result.length);
			var appsRecord = this.result;
			installedCallback(appsRecord);
		};
	
    } catch (err) {
    	var text = "getMozInstalled Error : ";
    	if (typeof err === 'string') {
        	text += err;
    	} else if (err instanceof Error) {
        	text += err.message;
    	}
		//notify(text);
    	installedCallback(text);
    }
	
	
	
}

function getInstalledAppName(namedSuccessFunction,namedNullFunction,failureFunction) {
	
	if(canUseMozApps()) {
	    try {
			var request = window.navigator.mozApps.getSelf();
			request.onsuccess = function() {
				if (request.result != null) {
					// Pull the name of the app out of the App object
					var name = this.result.manifest.name;
					//notify("App is installed! name :" + name + ":");
					namedSuccessFunction(name);
				} else {
					var installed = window.navigator.mozApps.getInstalled();
					installed.onsuccess = function() {
						if (this.result != null) {
							// Pull the name of the app out of the App object
							var apps = this.result;
							//notify("App is installed! name :" + name + ":");
							namedNullFunction(apps);
						} else {
							  var error = "Error getInstalledAppName: " + "null getInstalled result";
							  failureFunction(error);
						}
					  };
					  installed.onerror = function() {
						  // Display error name from the DOMError object
						  var error = "Error getInstalledAppName: " + this.error.name;
						  notify(error);
						  failureFunction(error);
					};
				}
			  };
			  request.onerror = function() {
				  // Display error name from the DOMError object
				  var error = "Error getInstalledAppName: " + this.error.name;
				  notify(error);
				  failureFunction(error);
			};
	    } catch (err) {
	    	var text = "getInstalledAppName Error : ";
	    	if (typeof err === 'string') {
	        	text += err;
	    	} else if (err instanceof Error) {
	        	text += err.message;
	    	}
			//notify(text);
			failureFunction(text);
	    }
	} else {
		return false;
		
	}
	
}