"use strict";



var NAS_BOOKVIEW_SKEW_COEFFICIENT_DEFAULT = 20;

var NASBookViewTouchAreaNone	= 0;
var NASBookViewTouchAreaLeft	= 1;
var NASBookViewTouchAreaRight	= 2;



/*[Delegates]
class NASBookViewDelegate
{
public:
//    virtual void nasBookViewDidMotion(NASBookView* bookView){};
//    virtual void nasBookViewDidChange(NASBookView* bookView){};
	virtual void nasBookViewWillRemoveView(NASBookView* bookView, NASView* view){};
	virtual void nasBookViewDidRemoveView(NASBookView* bookView, NASView* view){};
};


class NASBookViewDataSource
{
public:
	virtual NASView* nasBookViewViewForPage(NASBookView* bookView, int page){return NULL;};
};
*/



var NASBookView = NASView.extend({
//public:
	m_pDelegate: null,
	m_pDataSource: null,

	m_fSkewCoefficient: NAS_BOOKVIEW_SKEW_COEFFICIENT_DEFAULT,

//protected:
	m_touchAreaBegan: undefined,
	m_touchAreaPrev: NASBookViewTouchAreaNone,

	m_viewLeft: undefined,
	m_viewRight: undefined,
	m_viewCenterLeft: undefined,
	m_viewCenterRight: undefined,

	m_sizeView: undefined,

	m_nCurrentPage: 0,

	m_fDiffCenterBegan: undefined,

	m_oStartPoint: cc.PointZero(),
	m_aPrevPoint: new Array(cc.PointZero(), cc.PointZero()),
	m_oSpeed: cc.PointZero(),

	m_bMoved: false,
	m_bTurning: false,
	m_bAnimating: false,
	m_bTip: undefined,
	m_viewAnimating: undefined,



    init:function () {
        this._super();

        return true;
    },

    onEnter:function()
	{
        this._super();

		if (this.m_pDataSource)
		{
			var viewLeft = this.m_pDataSource.nasBookViewViewForPage(this, this.m_nCurrentPage);
			if (viewLeft)
			{
				viewLeft.setPosition(cc.p(this.m_sizeView.width / 2 - viewLeft.getContentSize().width, 0));
				this.addChild(viewLeft);
			}

			var viewRight = this.m_pDataSource.nasBookViewViewForPage(this, this.m_nCurrentPage + 1);
			if (viewRight)
			{
				viewRight.setPosition(cc.p(this.m_sizeView.width / 2, 0));
				this.addChild(viewRight);
			}

			this.m_viewLeft = viewLeft;
			this.m_viewRight = viewRight;
		}

        this.scheduleUpdate();
    },


    onExit:function()
	{
        this.unscheduleUpdate();

        this._super();
    },



    viewTouchBegan:function(pTouch, pEvent)
	{
        var point = this.convertTouchToNodeSpace(pTouch);
        {
			if (this.m_bTurning || this.m_bAnimating)
			{
				// None
			}
			else
			{
				if (point.x < this.m_sizeView.width / 2)
				{
					this.m_touchAreaBegan = this.m_touchAreaPrev = NASBookViewTouchAreaLeft;
				}
				else
				{
					this.m_touchAreaBegan = this.m_touchAreaPrev = NASBookViewTouchAreaRight;
				}

				this.m_fDiffCenterBegan = Math.abs(point.x - this.m_sizeView.width / 2);

				this.m_oStartPoint = this.m_aPrevPoint[1] = this.m_aPrevPoint[0] = point;
				this.m_oSpeed = cc.PointZero();

				this.m_bMoved = false;

				if ((this.m_touchAreaBegan == NASBookViewTouchAreaLeft && this.m_viewLeft) ||
					(this.m_touchAreaBegan == NASBookViewTouchAreaRight && this.m_viewRight))
				{
					this.m_bTurning = true;
				}
				else
				{
					this.m_bTurning = false;
				}
			}
        }
        this._super(pTouch, pEvent);


        return true;
    },


    viewTouchMoved:function(pTouch, pEvent)
	{
        var point = this.convertTouchToNodeSpace(pTouch);
        {
			if (this.m_bAnimating)
			{
				// None
			}
			else if (!this.m_bMoved)
			{
                if(5 < Math.sqrt((this.m_aPrevPoint[0].x-point.x)*(this.m_aPrevPoint[0].x-point.x)+(this.m_aPrevPoint[0].y-point.y)*(this.m_aPrevPoint[0].y-point.y)))
                {
//                    NASView::viewTouchCancelled(pTouch, pEvent);
                    this.viewTouchCancelled(pTouch, pEvent); // ### chotto mondai aru to omou...
                    this.m_bMoved = true;

					var pageLeft = -1;
					var pageRight = -1;
					if (this.m_touchAreaPrev == NASBookViewTouchAreaLeft)
					{
						pageLeft = this.m_nCurrentPage - 2;
						pageRight = this.m_nCurrentPage - 1;
					}
					else if (this.m_touchAreaPrev == NASBookViewTouchAreaRight)
					{
						pageLeft = this.m_nCurrentPage + 2;
						pageRight = this.m_nCurrentPage + 3;
					}

					var viewLeft = this.m_pDataSource.nasBookViewViewForPage(this, pageLeft);
					if (viewLeft)
					{
						viewLeft.setPosition(cc.p(this.m_sizeView.width / 2 - viewLeft.getContentSize().width, 0));
						this.addChild(viewLeft);
					}

					var viewRight = viewRight = this.m_pDataSource.nasBookViewViewForPage(this, pageRight);
					if (viewRight)
					{
						viewRight.setPosition(cc.p(this.m_sizeView.width / 2, 0));
						this.addChild(viewRight);
					}

					if (this.m_touchAreaPrev == NASBookViewTouchAreaLeft)
					{
						this.m_viewCenterLeft = this.m_viewLeft;
						if (this.m_viewCenterLeft)
						{
							this.m_viewCenterLeft.removeFromParent(true);
							this.addChild(this.m_viewCenterLeft);
						}

						this.m_viewLeft = viewLeft;

						this.m_viewCenterRight = viewRight;
						if (this.m_viewCenterRight)
						{
							this.m_viewCenterRight.setVisible(false);
						}

						if (!this.m_viewLeft && !this.m_viewCenterRight)
						{
							this.m_bTip = true;
						}
						else
						{
							this.m_bTip = false;
						}
					}
					else if (this.m_touchAreaPrev == NASBookViewTouchAreaRight)
					{
						this.m_viewCenterRight = this.m_viewRight;
						if (this.m_viewCenterRight)
						{
							this.m_viewCenterRight.removeFromParent(true);
							this.addChild(this.m_viewCenterRight);
						}

						this.m_viewRight = viewRight;

						this.m_viewCenterLeft = viewLeft;
						if (this.m_viewCenterLeft)
						{
							this.m_viewCenterLeft.setVisible(false);
						}

						if (!this.m_viewRight && !this.m_viewCenterLeft)
						{
							this.m_bTip = true;
						}
						else
						{
							this.m_bTip = false;
						}
					}
                }
			}
			else if (this.m_bTurning)
			{
				//...
				var touchArea = NASBookViewTouchAreaNone;
				if (point.x < this.m_sizeView.width / 2)
				{
					touchArea = NASBookViewTouchAreaLeft;
				}
				else
				{
					touchArea = NASBookViewTouchAreaRight;
				}

				var diffCenter = point.x - this.m_sizeView.width / 2;
				var scale = Math.abs(diffCenter / this.m_fDiffCenterBegan);
				if (this.m_bTip)
				{
					var diffX = Math.abs(this.m_oStartPoint.x - point.x);
					scale = Math.pow((diffX - 480) / 480, 2) / 2.0 + 0.5;
				}
				if (1.0 <= scale)
				{
					scale = 1.0;
				}
				var skew = (1.0 - scale) * this.m_fSkewCoefficient;
				// cc.log("diff:"+diffCenter+" scale:"+scale+"");

				if (touchArea == NASBookViewTouchAreaLeft)
				{
					if (this.m_touchAreaPrev == NASBookViewTouchAreaRight)
					{
						if (!this.m_bTip)
						{
							cc.log("Left to Right");
							if (this.m_viewCenterLeft)
							{
								this.m_viewCenterLeft.setVisible(true);
							}
							if (this.m_viewCenterRight)
							{
								this.m_viewCenterRight.setVisible(false);
							}
						}
					}
				}
				else if (touchArea == NASBookViewTouchAreaRight)
				{
					if (this.m_touchAreaPrev == NASBookViewTouchAreaLeft)
					{
						if (!this.m_bTip)
						{
							cc.log("Right to Left");
							if (this.m_viewCenterLeft)
							{
								this.m_viewCenterLeft.setVisible(false);
							}
							if (this.m_viewCenterRight)
							{
								this.m_viewCenterRight.setVisible(true);
							}
						}
					}
				}

				if (this.m_viewCenterLeft && this.m_viewCenterLeft.isVisible())
				{
					this.m_viewCenterLeft.setSkewY(-skew);
					this.m_viewCenterLeft.setScaleX(scale);

					var rad = skew * Math.PI / 180;
					var y = Math.sin(rad) * this.m_viewCenterLeft.getContentSize().width;
					this.m_viewCenterLeft.setPosition(cc.p(this.m_sizeView.width / 2 - this.m_viewCenterLeft.getContentSize().width * scale, y));
				}

				if (this.m_viewCenterRight && this.m_viewCenterRight.isVisible())
				{
					this.m_viewCenterRight.setSkewY(skew);
					this.m_viewCenterRight.setScaleX(scale);
				}

				this.m_touchAreaPrev = touchArea;

				this.m_aPrevPoint[1] = this.m_aPrevPoint[0];
				this.m_aPrevPoint[0] = point;
			}
        }
        this._super(pTouch, pEvent);
    },


    viewTouchEnded:function(pTouch, pEvent)
	{
        var point = this.convertTouchToNodeSpace(pTouch);
        {
			if (this.m_bAnimating)
			{
				// None
			}
			else if (this.m_bMoved && this.m_bTurning)
            {
				this.m_bAnimating = true;
				this.m_bTurning = false;

				if (!this.m_bTip)
				{
					if (this.m_touchAreaPrev == NASBookViewTouchAreaLeft)
					{
						this.m_viewAnimating = this.m_viewCenterLeft;
					}
					else if (this.m_touchAreaPrev == NASBookViewTouchAreaRight)
					{
						this.m_viewAnimating = this.m_viewCenterRight;
					}
				}
				else
				{
					if (this.m_touchAreaBegan == NASBookViewTouchAreaLeft)
					{
						this.m_viewAnimating = this.m_viewCenterLeft;
					}
					else if (this.m_touchAreaBegan == NASBookViewTouchAreaRight)
					{
						this.m_viewAnimating = this.m_viewCenterRight;
					}
				}
            }
            else
            {
                this.m_oSpeed = cc.PointZero();
            }

        }
        this._super(pTouch, pEvent);

    },


    viewTouchCancelled:function(pTouch, pEvent)
	{
        var point = this.convertTouchToNodeSpace(pTouch);
        {
            this.m_oSpeed = cc.PointZero();
        }
        this._super(pTouch, pEvent);
    },



    update:function(dt)
	{
		if (this.m_bAnimating)
		{
			var bEnd = false;

			var scale = this.m_viewAnimating.getScaleX();

			scale += dt * 5.0;
			if (1.0 <= scale)
			{
				scale = 1.0;

				bEnd = true;
			}

			var skew = this.m_viewAnimating.getSkewY();
			var sign = 1.0;
			if (0.001 <= Math.abs(skew))
			{
				sign = skew / Math.abs(skew);
			}
			skew = (1.0 - scale) * this.m_fSkewCoefficient;

			this.m_viewAnimating.setSkewY(skew * sign);
			this.m_viewAnimating.setScaleX(scale);
			if ((!this.m_bTip && this.m_touchAreaPrev == NASBookViewTouchAreaLeft) || (this.m_bTip && this.m_touchAreaBegan == NASBookViewTouchAreaLeft))
			{
				var rad = skew * Math.PI / 180;
				var y = Math.sin(rad) * this.m_viewAnimating.getContentSize().width;
				this.m_viewAnimating.setPosition(cc.p(this.m_sizeView.width / 2 - this.m_viewAnimating.getContentSize().width * scale, y));
			}

			if (bEnd)
			{
				if (!this.m_bTip)
				{
					if (this.m_touchAreaPrev == NASBookViewTouchAreaLeft)
					{
						if (this.m_touchAreaBegan == NASBookViewTouchAreaRight)
						{
							this.m_nCurrentPage += 2;
						}

						if (this.m_viewLeft)
						{
							this.removeView(this.m_viewLeft);
						}
						if (this.m_viewCenterRight)
						{
							this.removeView(this.m_viewCenterRight);
						}

						this.m_viewLeft = this.m_viewCenterLeft;
						this.m_viewCenterLeft = null;
					}
					else if (this.m_touchAreaPrev == NASBookViewTouchAreaRight)
					{
						if (this.m_touchAreaBegan == NASBookViewTouchAreaLeft)
						{
							this.m_nCurrentPage -= 2;
						}

						if (this.m_viewRight)
						{
							this.removeView(this.m_viewRight);
						}
						if (this.m_viewCenterLeft)
						{
							this.removeView(this.m_viewCenterLeft);
						}

						this.m_viewRight = this.m_viewCenterRight;
						this.m_viewCenterRight = null;
					}
				}
				else
				{
					if (this.m_touchAreaBegan == NASBookViewTouchAreaLeft)
					{
						if (this.m_viewLeft)
						{
							this.removeView(this.m_viewLeft);
						}
						if (this.m_viewCenterRight)
						{
							this.removeView(this.m_viewCenterRight);
						}

						this.m_viewLeft = this.m_viewCenterLeft;
						this.m_viewCenterLeft = null;
					}
					else if (this.m_touchAreaBegan == NASBookViewTouchAreaRight)
					{
						if (this.m_viewRight)
						{
							this.removeView(this.m_viewRight);
						}
						if (this.m_viewCenterLeft)
						{
							this.removeView(this.m_viewCenterLeft);
						}

						this.m_viewRight = this.m_viewCenterRight;
						this.m_viewCenterRight = null;
					}
				}

				this.m_bAnimating = false;
			}
		}
    },


	removeView:function(view)
	{
		if (view)
		{
			if (this.m_pDelegate)
			{
				this.m_pDelegate.nasBookViewWillRemoveView(this, view);
			}

			view.removeFromParent(true);

			if (this.m_pDelegate)
			{
				this.m_pDelegate.nasBookViewDidRemoveView(this, view);
			}

			view = null;
		}
	},



	setViewSize:function(size)
	{
		this.m_sizeView = size;
	},

	getViewSize:function()
	{
		return this.m_sizeView;
	},

});



NASBookView.create = function(){
	var view = new NASBookView();

	return (view.init()) ? view : null;
};



