"use strict";



var NASScrollView = NASView.extend({
//public:
	m_pScrollee		: null,
	m_bBounceX		: true,
	m_bBounceY		: true,
	m_bPaging		: false,
	m_pDelegate		: null,

//protected:
	m_aPrevPoint	: new Array(cc.PointZero(), cc.PointZero()),
	m_oSpeed		: cc.PointZero(),
	m_nBounceX		: 0,
	m_nBounceY		: 0,
	m_oBounceTo		: cc.PointZero(),

    m_nPage         : 0,

    init:function () {
        this._super();

		this.m_pScrollee = NASView.create();
		this.addChild(this.m_pScrollee);

        return true;
    },



    onEnter:function () {
//    	cc.log("NASScrollView::onEnter");

        this._super();

        this.scheduleUpdate();
    },

    onExit:function () {
//    	cc.log("NASScrollView::onExit");

        this.unscheduleUpdate();

        this._super();
    },



    viewTouchBegan:function(touch, event){
//        cc.log("NASScrollView::viewTouchBegan");

        var point = this.convertTouchToNodeSpace(touch);
        {
            this.m_aPrevPoint[0] = cc.p(point.x, point.y);
            this.m_aPrevPoint[1] = cc.p(point.x, point.y);
            this.m_oSpeed = cc.PointZero();

            this.m_nBounceX = 0;
            this.m_nBounceY = 0;
        }
        this._super(touch, event);

        return true;
    },

    viewTouchMoved:function(touch, event){
//        cc.log("NASScrollView::viewTouchMoved");

        var point = this.convertTouchToNodeSpace(touch);
        {
            var p = this.m_pScrollee.getPosition();
            var p0 = cc.p(p.x, p.y);

			{
				var ss = this.m_pScrollee.getContentSize();
				var st = this.getContentSize();

				// X
				if(0.0 <= p.x || p.x <= -ss.width+st.width){
					p.x += (point.x - this.m_aPrevPoint[0].x) / 3.2;
				}
				else{
					p.x += point.x - this.m_aPrevPoint[0].x;
				}

				if(!this.m_bBounceX){
					if(0.0 < p.x){
						p.x = 0.0;
					}
					else
						if(p.x < -ss.width+st.width){
							p.x = -ss.width+st.width;
						}
				}

				// Y
				if(0.0 <= p.y || p.y <= -ss.height+st.height){
					p.y += (point.y - this.m_aPrevPoint[0].y) / 3.2;
				}
				else{
					p.y += point.y - this.m_aPrevPoint[0].y;
				}

				if(!this.m_bBounceY){
					if(0.0 < p.y){
						p.y = 0.0;
					}
					else
						if(p.y < -ss.height+st.height){
							p.y = -ss.height+st.height;
						}
				}

				if(!cc.pointEqualToPoint(p0, p)){
					this.m_pScrollee.viewTouchCancelled(touch, event);
					this.m_pScrollee.setPosition(p);
																							if(this.m_pDelegate) this.m_pDelegate.nasScrollViewDidScroll(this);
				}

				this.m_aPrevPoint[1] = cc.p(this.m_aPrevPoint[0].x, this.m_aPrevPoint[0].y);
				this.m_aPrevPoint[0] = cc.p(point.x, point.y);

			}
        }
        this._super(touch, event);
    },

    viewTouchEnded:function(touch, event){
//        cc.log("NASScrollView::viewTouchEnded");

        var point = this.convertTouchToNodeSpace(touch);
        {
			this.m_oSpeed.x = (point.x - this.m_aPrevPoint[1].x) / (1+1);
			this.m_oSpeed.y = (point.y - this.m_aPrevPoint[1].y) / (1+1);

			this.m_oSpeed.x += (0.0 < this.m_oSpeed.x) ? 0.01 : -0.01;
			this.m_oSpeed.y += (0.0 < this.m_oSpeed.y) ? 0.01 : -0.01;
        }
        this._super(touch, event);
    },

    viewTouchCancelled:function(touch, event){
//        cc.log("NASScrollView::viewTouchCancelled");

        var point = this.convertTouchToNodeSpace(touch);
        {
            this.m_oSpeed = cc.PointZero();
        }
        this._super(touch, event);
    },



    update:function (dt) {
        var p = this.m_pScrollee.getPosition();

        var p0 = cc.p(p.x, p.y);
        var s0 = cc.p(this.m_oSpeed.x, this.m_oSpeed.y);



        if( this.m_nBounceX ){
            if( p.x*this.m_nBounceX < this.m_oBounceTo.x*this.m_nBounceX ){
                p.x += this.m_oSpeed.x;

                if( this.m_oSpeed.x*this.m_nBounceX < 0.0 ){
                    this.m_oSpeed.x += (this.m_oBounceTo.x - p.x) / (0.15/dt);
                }else{
                    this.m_oSpeed.x = (this.m_oBounceTo.x - p.x) / (0.10/dt);
                    if( Math.abs(this.m_oSpeed.x) < 0.01 ){
                        p.x = this.m_oBounceTo.x;

                        this.m_nBounceX = 0;
                        this.m_oSpeed.x = 0.0;
                    }
                }
            }else{
                p.x += (this.m_oBounceTo.x - p.x - 1.0*this.m_nBounceX) / (0.10/dt) + this.m_oSpeed.x;
                this.m_oSpeed.x *= 0.55;
            }
        }
        else
            if( 0.01 <= Math.abs(this.m_oSpeed.x) ){
                var ss = this.m_pScrollee.getContentSize();
                var st = this.getContentSize();

                {
                    if(this.m_bPaging){
                        var nPageTo = Math.floor( (-p.x+st.width/2) / st.width );

                        if(7.0 < this.m_oSpeed.x){
                            nPageTo = Math.floor( -p.x / st.width );
                        }
                        else
                            if(this.m_oSpeed.x < -7.0){
                                nPageTo = Math.floor( -p.x / st.width + 1);
                            }

                        if(nPageTo < 0){
                            nPageTo = 0;
                        }
                        else
                            if(Math.floor((ss.width-1)/st.width) < nPageTo){
                                nPageTo = Math.floor( (ss.width-1)/st.width );
                            }

                        this.m_oBounceTo.x = -st.width * nPageTo;
                        if(p.x == this.m_oBounceTo.x){
                            this.m_oSpeed.x = 0.0;
                        }else{
                            if(this.m_bBounceX){
                                this.m_nBounceX = (p.x < this.m_oBounceTo.x) ? -1 : 1;
                            }else{
                                this.m_nBounceX = (p.x < this.m_oBounceTo.x) ? 1 : -1;
                                this.m_oSpeed.x = 0.0;
                            }
                        }

	                    if (this.m_bBounceX)
                        {
                            this.m_nPage = nPageTo;
                        }
                    }

                    p.x += this.m_oSpeed.x;

                    if(this.m_bBounceX){
                        if(0.0 < p.x){
                            // Left
                            this.m_oBounceTo.x = 0.0;
                            this.m_nBounceX = -1;
                        }
                        else
                            if(p.x < -ss.width+st.width){
                                // Right
                                this.m_oBounceTo.x = -ss.width+st.width;
                                this.m_nBounceX = 1;
                            }
                    }
                    else{
                        if(0.0 < p.x){
                            p.x = 0.0;
                            this.m_oSpeed.x = 0.0;
                        }
                        else
                            if(p.x < -ss.width+st.width){
                                p.x = -ss.width+st.width;
                                this.m_oSpeed.x = 0.0;
                            }
                    }

                }

                this.m_oSpeed.x *= 0.93;
            }
            else{
                this.m_oSpeed.x = 0.0;
            }



        if( this.m_nBounceY ){
            if( p.y*this.m_nBounceY < this.m_oBounceTo.y*this.m_nBounceY ){
                p.y += this.m_oSpeed.y;

                if( this.m_oSpeed.y*this.m_nBounceY < 0.0 ){
                    this.m_oSpeed.y += (this.m_oBounceTo.y - p.y) / (0.15/dt);
                }else{
                    this.m_oSpeed.y = (this.m_oBounceTo.y - p.y) / (0.10/dt);
                    if( Math.abs(this.m_oSpeed.y) < 0.01 ){
                        p.y = this.m_oBounceTo.y;

                        this.m_nBounceY = 0;
                        this.m_oSpeed.y = 0.0;
                    }
                }
            }else{
                p.y += (this.m_oBounceTo.y - p.y - 1.0*this.m_nBounceY) / (0.10/dt) + this.m_oSpeed.y;
                this.m_oSpeed.y *= 0.55;
            }
        }
        else
            if( 0.01 <= Math.abs(this.m_oSpeed.y) ){
                var ss = this.m_pScrollee.getContentSize();
                var st = this.getContentSize();

                {
                    if(this.m_bPaging){
                        var nPageTo = Math.floor( (-p.y+st.height/2) / st.height );

                        if(7.0 < this.m_oSpeed.y){
                            nPageTo = Math.floor( -p.y / st.height );
                        }
                        else
                            if(this.m_oSpeed.y < -7.0){
                                nPageTo = Math.floor( -p.y / st.height + 1 );
                            }

                        if(nPageTo < 0){
                            nPageTo = 0;
                        }
                        else
                            if(Math.floor((ss.height-1)/st.height) < nPageTo){
                                nPageTo = Math.floor( (ss.height-1)/st.height );
                            }

                        this.m_oBounceTo.y = -st.height * nPageTo;
                        if(p.y == this.m_oBounceTo.y){
                            this.m_oSpeed.y = 0.0;
                        }else{
                            if(this.m_bBounceY){
                                this.m_nBounceY = (p.y < this.m_oBounceTo.y) ? -1 : 1;
                            }else{
                                this.m_nBounceY = (p.y < this.m_oBounceTo.y) ? 1 : -1;
                                this.m_oSpeed.y = 0.0;
                            }
                        }

                        if (this.m_bBounceY)
                        {
                            this.m_nPage = nPageTo;
                        }
                    }

                    p.y += this.m_oSpeed.y;

                    if(this.m_bBounceY){
                        if(0.0 < p.y){
                            // Bottom
                            this.m_oBounceTo.y = 0.0;
                            this.m_nBounceY = -1;
                        }
                        else
                            if(p.y < -ss.height+st.height){
                                // Top
                                this.m_oBounceTo.y = -ss.height+st.height;
                                this.m_nBounceY = 1;
                            }
                    }
                    else{
                        if(0.0 < p.y){
                            p.y = 0.0;
                            this.m_oSpeed.y = 0.0;
                        }
                        else
                            if(p.y < -ss.height+st.height){
                                p.y = -ss.height+st.height;
                                this.m_oSpeed.y = 0.0;
                            }
                    }

                }

                this.m_oSpeed.y *= 0.93;
            }
            else{
                this.m_oSpeed.y = 0.0;
            }



        if(!cc.pointEqualToPoint(p0, p)){
            this.m_pScrollee.setPosition(p);
            																				if(this.m_pDelegate) this.m_pDelegate.nasScrollViewDidScroll(this);
        }

        if(!cc.pointEqualToPoint(s0, cc.PointZero()) && cc.pointEqualToPoint(this.m_oSpeed, cc.PointZero())){
                                                                                            if(this.m_pDelegate) this.m_pDelegate.nasScrollViewDidMotion(this);
        }
    },



    scrollTo:function(p)
    {
    	var nowPos = this.m_pScrollee.getPosition();

    	if(nowPos.x < p.x){
	    	this.m_nBounceX = -1;
	    }else{
	    	this.m_nBounceX =  1;
	    }
    	this.m_oBounceTo.x = p.x;

    	if(nowPos.y < p.y){
	    	this.m_nBounceY = -1;
	    }else{
	    	this.m_nBounceY =  1;
	    }
    	this.m_oBounceTo.y = p.y;
    },

    addView:function(node, zOrder, tag)
    {
    	if(tag){
			this.m_pScrollee.addChild(node, zOrder, tag);
    	}else
    	if(zOrder){
	        this.m_pScrollee.addChild(node, zOrder, node.getTag());
    	}else
    	{
	        this.m_pScrollee.addChild(node, node.getZOrder(), node.getTag());
    	}
    },

    getViewByTag:function(tag)
    {
        return this.m_pScrollee.getChildByTag(tag);
    },

    setViewOffset:function(p)
    {
        this.m_pScrollee.setPosition(p);
    },

    getViewOffset:function()
    {
        return this.m_pScrollee.getPosition();
    },

    setViewSize:function(size)
    {
        this.m_pScrollee.setContentSize(size);
    },

    getViewSize:function()
    {
        return this.m_pScrollee.getContentSize();
    },

    setPage:function(page)
    {
        this.m_nPage = page;
    },

    getPage:function()
    {
        return this.m_nPage;
    },

});



NASScrollView.create = function(){
	var view = new NASScrollView();

	return (view.init()) ? view : null;
};



