"use strict";



var g_NASClipLB = null;
var g_NASClipRT = null;



var NASView = cc.Node.extend({
	m_pParentView	: null,
	m_bTouch		: false,
	m_bClip			: false,
	m_bTouchEnable  : true,

    init:function () {
        this._super();

		this.ignoreAnchorPointForPosition(true);
		this.setAnchorPoint(cc.PointZero());

        return true;
    },



    onEnter:function () {
//    	cc.log("NASView::onEnter");
    	
        this._super();
        
        var parent = this.getParent();
        while(parent && !(this.m_pParentView = (parent instanceof NASView)?parent:null)){
            parent = parent.getParent();
        }
        
        if(this.m_pParentView){
            // none
        }else{
			cc.Director.getInstance().getTouchDispatcher().addTargetedDelegate(this, 0, true);
        }
    },

    onExit:function () {
//    	cc.log("NASView::onExit");
    	
        cc.Director.getInstance().getTouchDispatcher().removeDelegate(this);

		this.m_pParentView = null;
		
        this._super();
    },



    onTouchBegan:function (touch, event) {
//        cc.log("NASView::onTouchBegan");
        if(!this.m_bTouchEnable){
            return false;
        }

        if(this.m_bTouch){
        	return true;
        }else{
			var point = this.convertTouchToNodeSpace(touch);
		
			var rect = new cc.Rect();
			rect.origin = cc.PointZero();
			rect.size = this.getContentSize();
		
			var bBegan = false;
		
			if( !this.m_bClip || cc.rectContainsPoint(rect,point) ){
				this.m_bTouch = true;
			
				bBegan = this.viewTouchBegan(touch, event);
			}
		
			return this.m_pParentView ? bBegan : true;
		}
    },
    
    onTouchMoved:function (touch, event) {
//        cc.log("NASView::onTouchMoved " + touch.getLocation().x + "," + touch.getLocation().y);
        
        if(this.m_bTouch){
	        this.viewTouchMoved(touch, event);
        }
    },
    
    onTouchEnded:function (touch, event) {
//        cc.log("NASView::onTouchEnded");
        
        if(this.m_bTouch){
	        this.viewTouchEnded(touch, event);
	        
	        this.m_bTouch = false;
	    }
    },
    
    onTouchCancelled:function (touch, event) {
//        cc.log("NASView::onTouchCancelled");
        
        if(this.m_bTouch){
	        this.viewTouchCancelled(touch, event);
	        
	        this.m_bTouch = false;
	    }
    },



    viewTouchBegan:function(touch, event){
//        cc.log("NASView::viewTouchBegan");
    
        if(this._children && this._children.length > 0)
        {
        	for(var i=this._children.length-1; 0<=i; --i){
        		if(this._children[i].onTouchBegan){
        			if(this._children[i].onTouchBegan(touch, event)) return true;
        		}
        	}
        }
        
        return false;
    },

    viewTouchMoved:function(touch, event){
//        cc.log("NASView::viewTouchMoved");
    
        if(this._children && this._children.length > 0)
        {
        	for(var i=this._children.length-1; 0<=i; --i){
        		if(this._children[i].onTouchMoved){
        			this._children[i].onTouchMoved(touch, event);
        		}
        	}
        }
    },

    viewTouchEnded:function(touch, event){
//        cc.log("NASView::viewTouchEnded");
    
        if(this._children && this._children.length > 0)
        {
        	for(var i=this._children.length-1; 0<=i; --i){
        		if(this._children[i].onTouchEnded){
        			this._children[i].onTouchEnded(touch, event);
        		}
        	}
        }
    },

    viewTouchCancelled:function(touch, event){
//        cc.log("NASView::viewTouchCancelled");
    
        if(this._children && this._children.length > 0)
        {
        	for(var i=this._children.length-1; 0<=i; --i){
        		if(this._children[i].onTouchCancelled){
        			this._children[i].onTouchCancelled(touch, event);
        		}
        	}
        }
    },



	visit:function(ctx){
		if(this.m_bClip){
            var position = this.getPosition();
            var size = this.getContentSize();
            var lb = this.getParent().convertToWorldSpaceAR(cc.p(position.x, position.y));
            var rt = this.getParent().convertToWorldSpaceAR(cc.p(position.x+size.width, position.y+size.height));
            
            if(g_NASClipLB){
                if(lb.x < g_NASClipLB.x) lb.x = g_NASClipLB.x;
                if(lb.y < g_NASClipLB.y) lb.y = g_NASClipLB.y;
                if(g_NASClipRT.x < rt.x) rt.x = g_NASClipRT.x;
                if(g_NASClipRT.y < rt.y) rt.y = g_NASClipRT.y;
                
                if(0.0<rt.x-lb.x && 0.0<rt.y-lb.y){
					var oldLB = g_NASClipLB;
					var oldRT = g_NASClipRT;
				
					// setScissor
					ctx.save();
					g_NASClipLB = lb;
					g_NASClipRT = rt;
					{
						var parent = this.getParent();
						if(parent){
							var ppos = parent.getPosition();
						
							lb.x -= ppos.x;
							lb.y -= ppos.y;
							rt.x -= ppos.x;
							rt.y -= ppos.y;
						}
				
						ctx.beginPath();
						ctx.moveTo(lb.x, -lb.y);
						ctx.lineTo(lb.x, -rt.y);
						ctx.lineTo(rt.x, -rt.y);
						ctx.lineTo(rt.x, -lb.y);
						ctx.closePath();
//						ctx.strokeRect(lb.x, -lb.y, rt.x-lb.x, -(rt.y-lb.y));
						ctx.clip();
					}
                    
                    this._super(ctx);
                    
					// restoreScissor
					ctx.restore();
					g_NASClipLB = oldLB;
					g_NASClipRT = oldRT;
                }
            }
            else
            if(0.0<rt.x-lb.x && 0.0<rt.y-lb.y){
				var oldLB = g_NASClipLB;
				var oldRT = g_NASClipRT;
				
                // setScissor
				ctx.save();
				g_NASClipLB = lb;
				g_NASClipRT = rt;
                {
                	var parent = this.getParent();
                	if(parent){
                		var ppos = parent.getPosition();
                		
                		lb.x -= ppos.x;
                		lb.y -= ppos.y;
                		rt.x -= ppos.x;
                		rt.y -= ppos.y;
                	}
                
					ctx.beginPath();
					ctx.moveTo(lb.x, -lb.y);
					ctx.lineTo(lb.x, -rt.y);
					ctx.lineTo(rt.x, -rt.y);
					ctx.lineTo(rt.x, -lb.y);
					ctx.closePath();
//					ctx.strokeRect(lb.x, -lb.y, rt.x-lb.x, -(rt.y-lb.y));
					ctx.clip();
                }
                
                this._super(ctx);
                
                // restoreScissor
                ctx.restore();
				g_NASClipLB = oldLB;
				g_NASClipRT = oldRT;
            }
		}else
		{
			this._super(ctx);
		}
		
	},

});



NASView.create = function(){
	var view = new NASView();
	
	return (view.init()) ? view : null;
};



