/****************************************************************************
 Copyright (c) 2010-2012 cocos2d-x.org
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011      Zynga Inc.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

var CollectLayer = NASView.extend({
	isMouseDown: false,
	helloImg: null,
	helloLabel: null,
	circle: null,
	wall: null,
	egg1: null,
	egg2: null,
	egg3: null,
	egg4: null,
	rarePicture:null,
	closeButton:null,
	menuButton:null,
	
	
	init: function () {

		//////////////////////////////
		// 1. super init first
		this._super();

		this.removeAllChildren();
		
		
                cc.AudioEngine.getInstance().playMusic(s_GameMusic,true);
                cc.AudioEngine.getInstance().setMusicVolume(0.3);
                

		/////////////////////////////
		// 2. add a menu item with "X" image, which is clicked to quit the program
		//    you may modify it.
		// ask director the window size
		var size = cc.Director.getInstance().getWinSize();

		// add "Helloworld" splash screen"
		//    this.egg1 = cc.egg1.create(s_HelloWorld);
		//    this.egg1.setAnchorPoint(cc.p(0.5, 0.5));
		//    this.egg1.setPosition(cc.p(size.width / 2, size.height / 2));
		//    this.addChild(this.egg1, 0);

		this.backGround = cc.Sprite.create(s_collectBackGround);

		this.backGround.width = size.width;

		this.backGround.height = size.height;

		this.backGround.setAnchorPoint(cc.p(0.5, 0.5));

		this.backGround.setPosition(cc.p(size.width / 2, size.height / 2));

		this.addChild(this.backGround, 0);


		//ボタン番号：1
		var Rare = cc.UserDefault.getInstance().getIntegerForKey("Rare_" + 1);
		
	
		if (Rare > 0){
		 this.egg1 = NASButtonView.buttonWithFile(s_ClosedEgg, this, 0);
		 this.egg1.setAnchorPoint(0, 0);
		 this.egg1.setPosition(size.width / 100, size.height / 2);
		 this.egg1.setTag(1);
		 this.addChild(this.egg1, 0);
		 this.egg1.setTouchEnable(true);
	      
		}
		
		Rare = cc.UserDefault.getInstance().getIntegerForKey("Rare_" + 2);
		if (Rare > 0){
		 //ボタン番号：2
		 this.egg2 = NASButtonView.buttonWithFile(s_ClosedEgg, this, 0);
		 this.egg2.setAnchorPoint(0, 0);
		 this.egg2.setPosition(size.width / 2.2, size.height / 2);
		 this.egg2.setTag(2);
		 this.addChild(this.egg2, 0);
		 this.egg2.setTouchEnable(true);
	      
		}
		
		Rare = cc.UserDefault.getInstance().getIntegerForKey("Rare_" + 3);
		if (Rare > 0){
		 //ボタン番号：3
		 this.egg3 = NASButtonView.buttonWithFile(s_ClosedEgg, this, 0);
		 this.egg3.setAnchorPoint(0, 0);
		 this.egg3.setPosition(size.width / 100, size.height / 9);
		 this.egg3.setTag(3);
		 this.addChild(this.egg3, 0);
		 this.egg3.setTouchEnable(true);
		}
		
		Rare = cc.UserDefault.getInstance().getIntegerForKey("Rare_" + 4);
		if (Rare > 0){
		 //ボタン番号：4
		 this.egg4 = NASButtonView.buttonWithFile(s_ClosedEgg, this, 0);
		 this.egg4.setAnchorPoint(0, 0);
		 this.egg4.setPosition(size.width / 2.2, size.height / 9);
		 this.egg4.setTag(4);
		 this.addChild(this.egg4, 0);
		 this.egg4.setTouchEnable(true);
		}

		for (var i = 0 ; i < 4;i++ ){
			var nestSprite = cc.Sprite.create(s_Nest);
			nestSprite.setAnchorPoint(0,0);
		  if (i == 0){
			  nestSprite.setPosition(cc.p(size.width / 100 + 30, size.height / 2));
			}else if (i == 1){
			  nestSprite.setPosition(cc.p(size.width / 2.2 + 30, size.height / 2));
			}else if (i == 2){
			  nestSprite.setPosition(cc.p(size.width / 100 + 30, size.height / 9));
			}else if (i == 3){
			  nestSprite.setPosition(cc.p(size.width / 2.2 + 30, size.height / 9));
			}
		  this.addChild(nestSprite, 0);
		}


		var leafSprite = cc.Sprite.create(s_Leaf);
		leafSprite.setAnchorPoint(cc.p(0.5, 0.5));
		leafSprite.setPosition(cc.p(size.width / 2, 47));
		this.addChild(leafSprite, 0);
	      
		this.menuButton = NASButtonView.buttonWithFile(s_ButtonTitle, this, 0);
		this.menuButton.setAnchorPoint(0, 0);
		this.menuButton.setPosition(size.width / 4 , size.height / 100);
		this.menuButton.setTag(999);
		this.addChild(this.menuButton, 0);
	      
			      
		this.menuButton.setTouchEnable(true);
		
		for (var i = 1; i < 5 ; i++){
			var openFlag = cc.UserDefault.getInstance().getBoolForKey("open_" + i);
			if (openFlag){
			    this.setRareItem(i);
			}
   	 }
		
		//this.schedule(this.update);

	},

	buttonEvent: function (sender, event, pTouch) {
		var tag = sender.getTag();
		if (event == NASButtonViewEventTouchDown) {
			if (tag >= 10){
				if (tag == 99)	
				{
					this.rarePicture.removeFromParent();
					this.closeButton.removeFromParent();
					
					if (cc.UserDefault.getInstance().getIntegerForKey("Rare_" + 1) > 0) {
						this.egg1.setTouchEnable(true);
					}
					if (cc.UserDefault.getInstance().getIntegerForKey("Rare_" + 2) > 0) {
						this.egg2.setTouchEnable(true);
					}
					if (cc.UserDefault.getInstance().getIntegerForKey("Rare_" + 3) > 0) {
						this.egg3.setTouchEnable(true);
					}
					if (cc.UserDefault.getInstance().getIntegerForKey("Rare_" + 4) > 0) {
						this.egg4.setTouchEnable(true);
					}
					
					this.menuButton.setTouchEnable(true);

				}else if (tag == 999){
				    cc.Director.getInstance().replaceScene(cc.TransitionRotoZoom.create(0.5, new MyScene));
				}else {
					var size = cc.Director.getInstance().getWinSize();
	
					this.rarePicture = cc.Sprite.create("res/rare_picture_" + (tag / 10 - 1) + ".png");
					this.rarePicture.setAnchorPoint(cc.p(0.5, 0.5));
					this.rarePicture.setPosition(cc.p(size.width / 2 ,size.height / 2));
		
					this.addChild(this.rarePicture);
	
					this.closeButton = NASButtonView.buttonWithFile(s_CloseEggButton, this, 0);
					this.closeButton.setAnchorPoint(0, 0);
							this.closeButton.setPosition(240,370);
					this.closeButton.setTag(99);
					this.addChild(this.closeButton);
					
					this.closeButton.setTouchEnable(true);
					
					if (cc.UserDefault.getInstance().getIntegerForKey("Rare_" + 1) > 0) {
						this.egg1.setTouchEnable(false);
					}
					if (cc.UserDefault.getInstance().getIntegerForKey("Rare_" + 2) > 0) {
						this.egg2.setTouchEnable(false);
					}
					if (cc.UserDefault.getInstance().getIntegerForKey("Rare_" + 3) > 0) {
						this.egg3.setTouchEnable(false);
					}
					if (cc.UserDefault.getInstance().getIntegerForKey("Rare_" + 4) > 0) {
						this.egg4.setTouchEnable(false);
					}
					
					this.menuButton.setTouchEnable(false);
					
					cc.AudioEngine.getInstance().playEffect(s_RareMusic);

	
				}
		
			}else {
				cc.AudioEngine.getInstance().playEffect(s_Tap_0);
				var openFlag = cc.UserDefault.getInstance().getBoolForKey("open_" + tag);
				if (!openFlag){
					cc.UserDefault.getInstance().setIntegerForKey("open_" + tag, true);
					this.setRareItem(tag);
				}
			}
		}
	},
	
	setRareItem:function(tag){
		var openFlag = cc.UserDefault.getInstance().getBoolForKey("open_" + tag);
		if (openFlag){
		       var rareEffect = cc.Sprite.create(s_CollectionEffect);
		       rareEffect.setAnchorPoint(cc.p(0.5, 0.5));
		       rareEffect.setPosition(cc.p(90,70));
		
		       if (tag == 1) {
			       this.egg1.setSpriteWithTexture(cc.TextureCache.getInstance().addImage(s_OpenEgg));
			       this.egg1.setTag(10);
       
			       var rareItemRibbon = cc.Sprite.create(s_CollectionRibbon);
			       rareItemRibbon.setAnchorPoint(cc.p(0.5, 0.5));
			       rareItemRibbon.setPosition(cc.p(90,70));
			       this.egg1.addChild(rareItemRibbon,0);
			       this.egg1.addChild(rareEffect,0);
			       
		       
		       }
		       else if (tag == 2) {
			       this.egg2.setSpriteWithTexture(cc.TextureCache.getInstance().addImage(s_OpenEgg));
			       this.egg2.setTag(20);
		       
			       var rareItemRibbon = cc.Sprite.create(s_CollectionRacket);
			       rareItemRibbon.setAnchorPoint(cc.p(0.5, 0.5));
			       rareItemRibbon.setPosition(cc.p(90,70));
			       this.egg2.addChild(rareItemRibbon,0);
			       this.egg2.addChild(rareEffect,0);
				       
		       }
		       else if (tag == 3) {
			       this.egg3.setSpriteWithTexture(cc.TextureCache.getInstance().addImage(s_OpenEgg));
			       this.egg3.setTag(30);
		       
			       var rareItemRibbon = cc.Sprite.create(s_CollectionBoard);
			       rareItemRibbon.setAnchorPoint(cc.p(0.5, 0.5));
			       rareItemRibbon.setPosition(cc.p(90,70));
			       this.egg3.addChild(rareItemRibbon,0);
			       this.egg3.addChild(rareEffect,0);	
		       }
		       else if (tag == 4) {
			       this.egg4.setSpriteWithTexture(cc.TextureCache.getInstance().addImage(s_OpenEgg));
			       this.egg4.setTag(40);
		       
			       var rareItemRibbon = cc.Sprite.create(s_CollectionBall);
			       rareItemRibbon.setAnchorPoint(cc.p(0.5, 0.5));
			       rareItemRibbon.setPosition(cc.p(90,70));
			       this.egg4.addChild(rareItemRibbon,0);
			       this.egg4.addChild(rareEffect,0);
		       }else 
		       {       
       
		       }
	       }

	}
	

});


var CollectScene = cc.Scene.extend({
	onEnter: function () {
		this._super();
		var layer = new CollectLayer();
		this.addChild(layer);
		layer.init();
	}
});
