/****************************************************************************
 Copyright (c) 2010-2012 cocos2d-x.org
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011      Zynga Inc.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

var GameLayer = NASView.extend({
    isMouseDown:false,
    helloImg:null,
    circle:null,
    
    sprite:null,
    backgroundSprite:null,
    eggCountSprite:null,

    x:0.0,
    y:0.0,
    s:0.0,
    g:9.8,
    
    score:0,
    arrFallObj:null,
    arrBreakCount:null,
    
    spriteTutorial:null,
    buttonClose:null,
    
    maxNum:0,
    breakTotal:0,
    labelCount:0,
    labelScore:0,
    
    removeCnt:0,
    
    egg:null,
             
    moveTo:null,
             
    init:function (objNum) {
        //////////////////////////////
        // 1. super init first
        this._super();
        
        this.removeAllChildren();
        cc.AudioEngine.getInstance().stopMusic();

        
        cc.AudioEngine.getInstance().preloadSound(s_Tap_0);
        cc.AudioEngine.getInstance().preloadSound(s_Tap_1);
        cc.AudioEngine.getInstance().preloadSound(s_RareMusic);
        cc.AudioEngine.getInstance().preloadSound(s_BombMusic);
        
        cc.AudioEngine.getInstance().playMusic(s_GameMusic,true);
	cc.AudioEngine.getInstance().setMusicVolume(0.3);
        
        this.arrFallObj = new Array();
        this.arrBreakCount = new Array(0,0,0,0);
        this.maxNum = objNum;
        this.removeCnt = 0;

        /////////////////////////////
        // 2. add a menu item with "X" image, which is clicked to quit the program
        //    you may modify it.
        // ask director the window size
        var size = cc.Director.getInstance().getWinSize();

        // add a "close" icon to exit the progress. it's an autorelease object

        removeCnt = 0;
        this.backgroundSprite = cc.Sprite.create(s_GameBackGround);
        this.backgroundSprite.setAnchorPoint(cc.p(0.5, 0.5));
        this.backgroundSprite.setPosition(cc.p(size.width / 2, size.height / 2));
        this.addChild(this.backgroundSprite,0);
        
        for (var i = 0; i < this.maxNum; i++) {
            //code
            //this.arrFallObj.push(new Egg());
            this.arrFallObj.push(Egg.create(this,i));
            this.arrFallObj[i].setTag(i);
            this.arrFallObj[i].sprite.setTouchEnable(true);
            this.addChild(this.arrFallObj[i], 1);

        }
        
        this.spriteTutorial= cc.Sprite.create(s_Tutorial);
        this.spriteTutorial.setAnchorPoint(cc.p(0.5, 0.5));
        this.spriteTutorial.setPosition(cc.p(size.width / 2, size.height / 2));
        this.addChild(this.spriteTutorial,0);
     
        this.buttonClose = NASButtonView.buttonWithFile(s_CloseEggButton,this,0);
        this.buttonClose.setAnchorPoint(cc.p(0.5,0.5));
        this.buttonClose.setPosition(cc.p(this.spriteTutorial._position.x + 90 , this.spriteTutorial._position.y +141));
        this.buttonClose.setTag(99999);
        this.addChild(this.buttonClose);
                       
       // this.schedule(this.update);
        
        return true;
    },
    
    
    prepareEggCount:function(){
        var size = cc.Director.getInstance().getWinSize();

        this.eggCountSprite = cc.Sprite.create(s_EggNumber);
        this.eggCountSprite.setPosition(cc.p(50 ,size.height - 50));
        this.addChild(this.eggCountSprite);
        
        this.breakTotal = 0;
        this.labelCount = cc.LabelTTF.create(this.breakTotal, "Arial", 20);
        this.labelCount.setColor(cc.BLACK);
        this.labelCount.setPosition(cc.p(50, size.height - 50));
        this.addChild(this.labelCount);
        
     // this.score = 0;
     // this.labelScore = cc.LabelTTF.create(this.score, "Arial", 10);
     // this.labelScore.setPosition(cc.p(size.width - 50, size.height - 50));
     // this.addChild(this.labelScore);
                       
        this.hightScore = cc.UserDefault.getInstance().getIntegerForKey("hightScore");
        this.maxBreakCount = cc.UserDefault.getInstance().getIntegerForKey("maxBreakCount");
    },
   update:function(dt) {    
                if (removeCnt == this.maxNum) {
                    this.Result();
                    this.unschedule(this.update);
                }
   },
     
   buttonEvent:function(sender, event, pTouch){
       var tag = sender.getParent().getTag();
       var GameButtonTag = sender.getTag();
       if (event == NASButtonViewEventTouchDown) {
            if (GameButtonTag == 999) {
                // goto menu
                cc.AudioEngine.getInstance().stopMusic();
                remoCnt = 0;
                cc.Director.getInstance().replaceScene(cc.TransitionRotoZoom.create(0.5, new MyScene));
            }else if (GameButtonTag == 9999) {
                // retry
                removeCnt = 0;
                cc.Director.getInstance().replaceScene(cc.TransitionRotoZoom.create(0.5, GameLayer.create(this.maxNum + 10)));                
            } else if (GameButtonTag == 99999) {
                // close tutorial
                this.spriteTutorial.removeFromParent();
                this.buttonClose.removeFromParent();
                // game start
                this.prepareEggCount();
                for (var i = 0 ; i < this.maxNum; i++){
                    this.arrFallObj[i].sprite.runAction(this.arrFallObj[i].startAction);
                    this.schedule(this.update);
                }
            }else{
                this.arrFallObj[tag].HP -= 1;
                this.checkHitPoint(tag);
            }
        
       }
   },
    
   checkHitPoint:function(tag){
        var textureName;
        if (this.arrFallObj[tag].HP == 1) {
            //crack
            textureName = this.arrFallObj[tag].crackTextureName;
        }else if (this.arrFallObj[tag].HP > 1) {
            textureName = this.arrFallObj[tag].textureName;
        }else if (this.arrFallObj[tag].HP <= 0){
            //break
            cc.AudioEngine.getInstance().playEffect(this.arrFallObj[tag].sound);

            this.arrBreakCount[this.arrFallObj[tag].type] += 1;
            this.breakTotal += 1;
            this.arrFallObj[tag].sprite.setTouchEnable(false);
            this.arrFallObj[tag].sprite.runAction(this.arrFallObj[tag].action);
            this.score += this.arrFallObj[tag].scoreValue;
            textureName = this.arrFallObj[tag].breakTextureName;

            //type = 2 Rare
            if (this.arrFallObj[tag].type == 2) {
                var rnd = Math.random();
                var i = Math.floor(rnd * 4) + 1;
                var spriteRareItem = cc.Sprite.create("res/rareItem_" + i + ".png");
                spriteRareItem.setAnchorPoint(cc.p(0.5, 0.5));
                //spriteRareItem.setPosition(cc.p(this.arrFallObj[tag].positionX, this.arrFallObj[tag].positionY));
                spriteRareItem.setPosition(cc.p(35,37));
                this.arrFallObj[tag].sprite.addChild(spriteRareItem,0);
                
                var spriteEffect = cc.Sprite.create(s_RareEffect);
                spriteEffect.setAnchorPoint(cc.p(0.5, 0.5));
                spriteEffect.setPosition(cc.p(35,37));
                this.arrFallObj[tag].sprite.addChild(spriteEffect,0);
                
                var Rare = cc.UserDefault.getInstance().getIntegerForKey("Rare_" + i);
                cc.UserDefault.getInstance().setIntegerForKey("Rare_" + i, Rare + 1);
                Rare = cc.UserDefault.getInstance().getIntegerForKey("Rare_" + i);
            }else if (this.arrFallObj[tag].type == 3) {
                var spriteBomb = cc.Sprite.create(s_BombEffect);
                spriteBomb.setAnchorPoint(cc.p(0.5, 0.5));
                spriteBomb.setPosition(cc.p(50,40));
                this.arrFallObj[tag].sprite.addChild(spriteBomb,0);
            }
            this.updateScoreLabel();
        }

        this.arrFallObj[tag].sprite.setSpriteWithTexture(cc.TextureCache.getInstance().addImage(textureName));
    },
     
    updateScoreLabel:function(){
        var size = cc.Director.getInstance().getWinSize();

        this.labelCount.removeFromParent();
        this.labelCount = cc.LabelTTF.create(this.breakTotal, "Arial", 20);
        this.labelCount.setColor(cc.BLACK);
        this.labelCount.setPosition(cc.p(50, size.height - 50));
        this.addChild(this.labelCount);
        
   //  this.labelScore.removeFromParent();
   //  this.labelScore = cc.LabelTTF.create(this.score, "Arial", 10);
   //  this.labelScore.setPosition(cc.p(size.width - 50, size.height - 50));
   //  this.addChild(this.labelScore);
     
     },
     
     Result:function(){
        
        var size = cc.Director.getInstance().getWinSize();
        
        var hightScore = cc.UserDefault.getInstance().getIntegerForKey("hightScore");
        var maxBreakCount = cc.UserDefault.getInstance().getIntegerForKey("maxBreakCount");
        var showHighScore = hightScore;

        if (hightScore < this.score) {
            cc.UserDefault.getInstance().setIntegerForKey("hightScore", this.score);
            hightScore = cc.UserDefault.getInstance().getIntegerForKey("hightScore");
        }
        
        if (maxBreakCount < this.breakTotal) {
            cc.UserDefault.getInstance().setIntegerForKey("maxBreakCount", this.breakTotal);
            maxBreakCount = cc.UserDefault.getInstance().getIntegerForKey("maxBreakCount");
        }

         var resultPage = cc.Sprite.create(s_Result);
         resultPage.setAnchorPoint(cc.p(0.5,0.5));
         resultPage.setPosition(cc.p(size.width /2 , size.height/2 + 30));
         this.addChild(resultPage);
        
         // menu button
         var btnTitle = NASButtonView.buttonWithFile(s_ButtonTitle,this,0);
         btnTitle.setAnchorPoint(cc.p(0.5,0.5));
         btnTitle.setPosition(cc.p(resultPage._position.x - 150 , resultPage._position.y -240));
         btnTitle.setTag(999);
         this.addChild(btnTitle);
         
         // retry button
         var btnRetry = NASButtonView.buttonWithFile(s_ButtonRetry,this,0)
         btnRetry.setAnchorPoint(cc.p(0.5,0.5));
         btnRetry.setPosition(cc.p(resultPage._position.x  , resultPage._position.y -240));
         btnRetry.setTag(9999);
         this.addChild(btnRetry);
         
        var labelGameScore = cc.LabelTTF.create(this.score, "Arial", 20);
        labelGameScore.setColor(cc.BLACK);
        labelGameScore.setPosition(cc.p(size.width / 2+ 20, size.height / 2 - 75));
        this.addChild(labelGameScore);
        
        var labelHightScore = cc.LabelTTF.create(showHighScore, "Arial", 20);
        labelHightScore.setColor(cc.BLACK);
        labelHightScore.setPosition(cc.p(size.width / 2 + 20, size.height / 2 - 115));
        this.addChild(labelHightScore);
         
         for (var i = 0; i < 4 ;i++){
            var labelEggNum  = cc.LabelTTF.create(this.arrBreakCount[i], "Arial", 20);
            labelEggNum.setColor(cc.BLACK);
            labelEggNum.setPosition(cc.p(size.width / 2 + 20 , size.height / 2 + 98 - (i * 45) ));
            this.addChild(labelEggNum); 
        }
        
        var labelShougou; 
          if (this.score >= this.hightScore) {
            labelShougou = cc.LabelTTF.create("記録更新！！！", "Arial", 15);    
          }else if (this.score >= this.maxNum * 9 && this.score < this.hightScore) {
            labelShougou = cc.LabelTTF.create("目指せ新記録！！", "Arial", 15);    
          }else if (this.score < this.maxNum * 9){
            labelShougou = cc.LabelTTF.create("次はもっと頑張ろう！","Arial",15);
          }

        labelShougou.setPosition(cc.p(size.width / 2 , size.height / 2 + 150));
        labelShougou.setColor(cc.BLACK);
        this.addChild(labelShougou);
          
        this.labelCount.removeFromParent();
        this.eggCountSprite.removeFromParent();
     },
     
});



var GameScene = cc.Scene.extend({
    onEnter:function () {
        this._super();
        var layer = new GameLayer();
        this.addChild(layer);
        layer.init();
    }
});


GameLayer.create = function(mode){
    var scene = new GameLayer();
    
    return scene.init(mode) ? scene : null;
};





